/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.aoi;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import net.refractions.udig.aoi.AOIListener;
import net.refractions.udig.aoi.IAOIStrategy;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.project.render.IViewportModelListener;
import net.refractions.udig.project.render.ViewportModelEvent;
import net.refractions.udig.project.ui.ApplicationGIS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ScreenAOIStrategy
extends IAOIStrategy {
    private static String name = "Screen";
    protected IViewportModelListener watcher = new IViewportModelListener(){

        public void changed(ViewportModelEvent viewportEvent) {
            AOIListener.Event aoiEvent = new AOIListener.Event((IAOIStrategy)ScreenAOIStrategy.this);
            aoiEvent.bounds = viewportEvent.getType() == ViewportModelEvent.EventType.BOUNDS ? (ReferencedEnvelope)viewportEvent.getNewValue() : viewportEvent.getSource().getBounds();
            ScreenAOIStrategy.this.notifyListeners(aoiEvent);
        }
    };

    public ScreenAOIStrategy() {
        this.listenToViewport();
    }

    private void listenToViewport() {
        IViewportModel viewportModel = ApplicationGIS.getActiveMap().getViewportModel();
        viewportModel.addViewportModelListener(this.watcher);
    }

    public ReferencedEnvelope getExtent() {
        IMap currentMap = ApplicationGIS.getActiveMap();
        if (!currentMap.equals(ApplicationGIS.NO_MAP)) {
            return currentMap.getViewportModel().getBounds();
        }
        return null;
    }

    public Geometry getGeometry() {
        ReferencedEnvelope extent = this.getExtent();
        if (extent != null) {
            return new GeometryFactory().toGeometry((Envelope)extent);
        }
        return null;
    }

    public CoordinateReferenceSystem getCrs() {
        IMap currentMap = ApplicationGIS.getActiveMap();
        if (!currentMap.equals(ApplicationGIS.NO_MAP)) {
            return currentMap.getViewportModel().getCRS();
        }
        return null;
    }

    public String getName() {
        return name;
    }
}

