/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.adapters;

import java.util.ArrayList;
import net.refractions.udig.project.ui.internal.Messages;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class FeatureViewerProvider
extends LabelProvider
implements ITreeContentProvider {
    public Object[] getElements(Object inputElement) {
        Object[] children = this.getChildren(inputElement);
        if (children == null) {
            return null;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        int i = 0;
        while (i < children.length) {
            if (this.hasChildren(children[i])) {
                Object[] elements = this.getElements(children[i]);
                if (elements != null) {
                    int j = 0;
                    while (j < elements.length) {
                        list.add(elements[j]);
                        ++j;
                    }
                }
            } else {
                list.add(children[i]);
            }
            ++i;
        }
        return list.toArray();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Databag) {
            Databag data = (Databag)parentElement;
            Object value = data.source.getPropertyValue(data.descriptor.getId());
            if (value instanceof IPropertySource) {
                return this.createChildren((IPropertySource)value);
            }
        } else if (Platform.getAdapterManager().hasAdapter(parentElement, "org.eclipse.ui.views.properties.IPropertySource")) {
            IPropertySource source = (IPropertySource)Platform.getAdapterManager().getAdapter(parentElement, "org.eclipse.ui.views.properties.IPropertySource");
            return this.createChildren(source);
        }
        return null;
    }

    Object[] createChildren(IPropertySource source) {
        IPropertyDescriptor[] descriptors = source.getPropertyDescriptors();
        Object[] data = new Databag[descriptors.length];
        int i = 0;
        while (i < data.length) {
            data[i] = new Databag();
            ((Databag)data[i]).source = source;
            ((Databag)data[i]).descriptor = descriptors[i];
            ++i;
        }
        return data;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (Platform.getAdapterManager().hasAdapter(element, "org.eclipse.ui.views.properties.IPropertySource")) {
            return true;
        }
        if (element instanceof Databag) {
            Databag data = (Databag)element;
            Object value = data.source.getPropertyValue(data.descriptor.getId());
            if (value instanceof IPropertySource) {
                return true;
            }
        }
        return false;
    }

    public String getText(Object element) {
        if (element instanceof Databag) {
            Databag data = (Databag)element;
            return data.descriptor.getDisplayName();
        }
        return Messages.FeatureViewerProvider_unknown;
    }

    public static class Databag {
        IPropertySource source;
        IPropertyDescriptor descriptor;
    }
}

