/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.actions;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.style.sld.SLDContent;
import net.refractions.udig.ui.IDropAction;
import net.refractions.udig.ui.ViewerDropLocation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.styling.Style;

public class SLDDropAction
extends IDropAction {
    private Style style;

    public boolean accept() {
        URL url;
        block11: {
            if (this.getViewerLocation() == ViewerDropLocation.NONE) {
                return false;
            }
            url = null;
            try {
                if (this.getData() instanceof URL) {
                    url = (URL)this.getData();
                    break block11;
                }
                if (this.getData() instanceof File) {
                    url = ((File)this.getData()).toURL();
                    break block11;
                }
                if (!(this.getData() instanceof String)) break block11;
                try {
                    url = new URL((String)this.getData());
                }
                catch (MalformedURLException malformedURLException) {
                    url = new URL("file:///" + (String)this.getData());
                }
                if (!(url == null || url.getFile().toLowerCase().endsWith(".sld") && url.getQuery() == null)) {
                    url = null;
                }
            }
            catch (MalformedURLException e) {
                String msg = Messages.SLDDropAction_badSldUrl;
                ProjectUIPlugin.log(msg, e);
            }
        }
        if (url == null) {
            return false;
        }
        try {
            this.style = SLDContent.parse((URL)url);
        }
        catch (Throwable throwable) {
            return false;
        }
        return this.style != null && (this.getDestination() instanceof Layer || this.getDestination() instanceof Map);
    }

    public void perform(IProgressMonitor monitor) {
        if (!this.accept()) {
            throw new IllegalStateException("Data is not acceptable for this action!  Programatic Error!!!");
        }
        Object target = this.getDestination();
        if (target instanceof Layer) {
            this.dropOnLayer(monitor, (Layer)target);
        } else if (target instanceof Map) {
            this.dropOnLayer(monitor, ((Map)target).getEditManagerInternal().getSelectedLayer());
        }
    }

    private void dropOnLayer(IProgressMonitor monitor, Layer target) {
        Layer layer = target;
        try {
            SLDContent.apply((ILayer)layer, (Style)this.style, (IProgressMonitor)monitor);
            layer.refresh(null);
        }
        catch (IOException e) {
            String msg = Messages.SLDDropAction_sldParseError;
            ProjectUIPlugin.log(msg, e);
        }
    }
}

