/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.actions;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IProject;
import net.refractions.udig.project.IProjectElement;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class OpenMapAction
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    public void run(IAction action) {
        Shell activeShell = Display.getDefault().getActiveShell();
        String path = null;
        while (path == null) {
            FileDialog dialog = new FileDialog(activeShell);
            dialog.setText(Messages.OpenProject_openProject);
            path = dialog.open();
            if (path == null) {
                return;
            }
            this.loadMapFromString(path, ApplicationGIS.getActiveProject(), true);
        }
    }

    public void loadMapFromURL(URL url, IProject target, boolean openMap) {
        if (url == null) {
            throw new IllegalArgumentException("URL cannot be null.");
        }
        IProjectElement elem = null;
        if (target == null) {
            target = ApplicationGIS.getActiveProject();
        }
        Shell activeShell = null;
        try {
            elem = ApplicationGIS.loadProjectElement(url, target);
        }
        catch (Exception e) {
            ProjectUIPlugin.log("Could not load map from file: " + url, e);
            MessageDialog.openError(activeShell, (String)"Error reading map file", (String)"An unexpected error occurred while reading the map file.\nPlease send error log.");
            return;
        }
        if (!(elem instanceof IMap)) {
            MessageDialog.openError(activeShell, (String)"Error reading map file", (String)"The selected file does.");
            return;
        }
        if (openMap) {
            Map map = (Map)elem;
            ApplicationGIS.openMap((IMap)map);
        }
    }

    public void loadMapFromString(String filename, IProject target, boolean openMap) {
        URL url;
        if (filename == null) {
            throw new IllegalArgumentException("Filename cannot be null.");
        }
        File f = new File(filename);
        if (!f.exists()) {
            throw new RuntimeException("File does not exist: " + f.getAbsolutePath());
        }
        try {
            url = f.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        this.loadMapFromURL(url, target, openMap);
    }

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }
}

