/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.actions;

import java.io.IOException;
import java.util.Collections;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.core.AdapterUtil;
import net.refractions.udig.project.IEditManager;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.ui.FeatureTypeEditor;
import net.refractions.udig.ui.FeatureTypeEditorDialog;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.actions.ActionDelegate;
import org.geotools.data.FeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class NewLayerAction
extends ActionDelegate
implements IWorkbenchWindowActionDelegate {
    private IGeoResource resource = null;
    private final FeatureTypeEditorDialog.ValidateFeatureType performOK = new FeatureTypeEditorDialog.ValidateFeatureType(){

        public String validate(SimpleFeatureType featureType) {
            try {
                NewLayerAction.this.resource = CatalogPlugin.getDefault().getLocalCatalog().createTemporaryResource((Object)featureType);
                return null;
            }
            catch (Exception exception) {
                return Messages.NewLayerAction_duplicateName;
            }
        }
    };
    private IWorkbenchWindow window;

    public void runWithEvent(IAction action, Event event) {
        FeatureTypeEditorDialog dialog = new FeatureTypeEditorDialog(event.display.getActiveShell(), this.performOK);
        this.setDefaultGeomType(dialog);
        dialog.setBlockOnOpen(true);
        int code = dialog.open();
        if (code == 1) {
            return;
        }
        if (this.resource != null) {
            IMap map = ApplicationGIS.getActiveMap();
            int index = 0;
            if (map != ApplicationGIS.NO_MAP) {
                index = map.getMapLayers().size();
            }
            ApplicationGIS.addLayersToMap(map, Collections.singletonList(this.resource), index);
        }
    }

    private void setDefaultGeomType(FeatureTypeEditorDialog dialog) {
        if (this.window.getSelectionService() == null) {
            return;
        }
        ISelection selection = this.window.getSelectionService().getSelection();
        GeometryDescriptor geom = this.findGeometryType(selection);
        if (geom == null) {
            IMap map = ApplicationGIS.getActiveMap();
            if (map == ApplicationGIS.NO_MAP) {
                return;
            }
            IEditManager editManager = map.getEditManager();
            if (editManager == null) {
                return;
            }
            ILayer selectedLayer = editManager.getSelectedLayer();
            if (selectedLayer == null) {
                return;
            }
            SimpleFeatureType schema = selectedLayer.getSchema();
            if (schema == null) {
                return;
            }
            geom = schema.getGeometryDescriptor();
        }
        FeatureTypeEditor editor = dialog.getEditor();
        SimpleFeatureType ft = editor.createDefaultFeatureType();
        SimpleFeatureTypeBuilder builder = editor.builderFromFeatureType(ft);
        String defaultGeometry = ft.getGeometryDescriptor().getLocalName();
        if (defaultGeometry == null) {
            return;
        }
        builder.remove(defaultGeometry);
        builder.add((AttributeDescriptor)geom);
        builder.setDefaultGeometry(geom.getLocalName());
        dialog.setDefaultFeatureType(builder.buildFeatureType());
    }

    private GeometryDescriptor findGeometryType(ISelection selection) {
        if (selection.isEmpty()) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            for (Object elem : structured) {
                try {
                    IMap map;
                    ILayer layer;
                    FeatureSource source = (FeatureSource)AdapterUtil.instance.adaptTo(FeatureSource.class, elem, ProgressManager.instance().get(new Object[0]));
                    if (source != null) {
                        return ((SimpleFeatureType)source.getSchema()).getGeometryDescriptor();
                    }
                    if (!(elem instanceof IMap) || (layer = (map = (IMap)elem).getEditManager().getSelectedLayer()) == null || (source = (FeatureSource)AdapterUtil.instance.adaptTo(FeatureSource.class, (Object)layer, ProgressManager.instance().get(new Object[0]))) == null) continue;
                    return ((SimpleFeatureType)source.getSchema()).getGeometryDescriptor();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public void init(IWorkbenchWindow window) {
        this.window = window;
    }
}

