/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.ILegendItem;
import net.refractions.udig.project.internal.Folder;
import net.refractions.udig.project.internal.LayerLegendItem;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.ui.IDropAction;
import net.refractions.udig.ui.ViewerDropLocation;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.dnd.DropTargetEvent;

public class LegendDropAction
extends IDropAction {
    private boolean isLayerSource;
    private boolean isFolderSource;
    private boolean isMixedSource;
    private boolean isLayerTarget;
    private boolean isFolderTarget;
    private List<Object> sources;
    private Object target;

    public void init(IConfigurationElement element2, DropTargetEvent event2, ViewerDropLocation location2, Object destination2, Object data2) {
        super.init(element2, event2, location2, destination2, data2);
        this.initDropConditions();
    }

    public boolean accept() {
        return this.isValidObjects() && this.isValidDropLocation(this.getViewerLocation());
    }

    private boolean isValidObjects() {
        if (this.sources == null || this.target == null) {
            return false;
        }
        if (this.sources.size() > 1) {
            return false;
        }
        return this.sources.size() != 1 || this.sources.get(0) != this.getDestination();
    }

    private boolean isValidDropLocation(ViewerDropLocation location) {
        if (location == ViewerDropLocation.NONE) {
            return false;
        }
        if (location == ViewerDropLocation.ON) {
            if (this.isMixedSource) {
                return false;
            }
            if (this.isLayerSource && this.isLayerTarget) {
                return false;
            }
            if (this.isFolderSource && this.isLayerTarget) {
                return false;
            }
            if (this.isParent(this.getData(), this.getDestination())) {
                return false;
            }
            if (this.isDescendant(this.getData(), this.getDestination())) {
                return false;
            }
        } else if (this.isDescendant(this.getData(), this.getDestination())) {
            return false;
        }
        return true;
    }

    public void perform(IProgressMonitor monitor) {
        for (Object source : this.sources) {
            ViewerDropLocation location = this.getViewerLocation();
            if (ViewerDropLocation.NONE == location) continue;
            if (ViewerDropLocation.ON == location) {
                this.moveIn(source);
                continue;
            }
            this.move(source, location);
        }
    }

    private void moveIn(Object source) {
        ILegendItem sourceItem = (ILegendItem)source;
        Folder folder = (Folder)this.target;
        folder.getItems().add(sourceItem);
    }

    private void move(Object source, ViewerDropLocation location) {
        List<ILegendItem> targetSiblings;
        ILegendItem sourceItem = (ILegendItem)source;
        List<ILegendItem> sourceSiblings = this.getSiblings(source);
        if (sourceSiblings == (targetSiblings = this.getSiblings(this.target))) {
            sourceSiblings.remove(source);
            int targetIndexNew = targetSiblings.indexOf(this.getDestination());
            if (location == ViewerDropLocation.BEFORE) {
                targetSiblings.add(targetIndexNew, sourceItem);
            } else if (location == ViewerDropLocation.AFTER) {
                targetSiblings.add(targetIndexNew + 1, sourceItem);
            }
        } else {
            int targetIndex = targetSiblings.indexOf(this.getDestination());
            if (location == ViewerDropLocation.AFTER) {
                ++targetIndex;
            }
            targetSiblings.add(targetIndex, sourceItem);
        }
    }

    private List<ILegendItem> getSiblings(Object object) {
        Object parent = this.getParent(object);
        if (parent instanceof Map) {
            return ((Map)parent).getLegend();
        }
        if (parent instanceof Folder) {
            return ((Folder)parent).getItems();
        }
        return null;
    }

    private Object getParent(Object object) {
        Map map = this.getActiveMap();
        List items = map.getLegend();
        if (items.contains(object)) {
            return map;
        }
        for (ILegendItem item : items) {
            Object parent;
            if (!(item instanceof Folder) || (parent = this.getParent((Folder)item, object)) == null) continue;
            return parent;
        }
        return null;
    }

    private Object getParent(Folder folder, Object object) {
        if (folder.getItems().contains(object)) {
            return folder;
        }
        for (ILegendItem folderItem : folder.getItems()) {
            Object parent;
            if (!(folderItem instanceof Folder) || (parent = this.getParent((Folder)folderItem, object)) == null) continue;
            return parent;
        }
        return null;
    }

    private boolean isParent(Object source, Object target) {
        return this.getParent(source) == target;
    }

    private boolean isDescendant(Object source, Object target) {
        if (source instanceof Folder) {
            Folder folder = (Folder)source;
            for (ILegendItem folderItem : folder.getItems()) {
                if (folderItem == target) {
                    return true;
                }
                if (!(folderItem instanceof Folder) || !this.isDescendant(folderItem, target)) continue;
                return true;
            }
        }
        return false;
    }

    private Map getActiveMap() {
        return (Map)ApplicationGIS.getActiveMap();
    }

    private void initDropConditions() {
        this.checkSource(this.getData());
        this.checkTarget(this.getDestination());
    }

    private void checkSource(Object data) {
        this.sources = null;
        this.isFolderSource = false;
        this.isLayerSource = false;
        this.isMixedSource = false;
        if (data != null) {
            this.sources = new ArrayList<Object>();
            if (data instanceof Object[]) {
                Object[] objectArray = (Object[])data;
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object dataItem = objectArray[n2];
                    this.sources.add(dataItem);
                    ++n2;
                }
                this.isMixedSource = true;
            } else if (data instanceof LayerLegendItem) {
                this.sources.add(data);
                this.isLayerSource = true;
            } else if (data instanceof Folder) {
                this.sources.add(data);
                this.isFolderSource = true;
            }
        }
    }

    private void checkTarget(Object data) {
        this.target = null;
        this.isFolderTarget = false;
        this.isLayerTarget = false;
        if (data != null) {
            if (data instanceof LayerLegendItem) {
                this.target = data;
                this.isLayerTarget = true;
            } else if (data instanceof Folder) {
                this.target = data;
                this.isFolderTarget = true;
            }
        }
    }
}

