/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal.actions;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ServiceMover;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IProjectElement;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.impl.MapImpl;
import net.refractions.udig.project.ui.UDIGGenericAction;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConsolidateAction
extends UDIGGenericAction {
    private Project project;
    private File projectDataFolder;

    protected void operate(Project project) {
        this.project = project;
        this.projectDataFolder = this.checkProjectEnvironment();
        if (this.projectDataFolder == null) {
            throw new RuntimeException("Problems consolidating...");
        }
        List projectElements = project.getElements();
        for (IProjectElement projectElement : projectElements) {
            List layers = ((MapImpl)projectElement).getLayersInternal();
            for (ILayer layer : layers) {
                IService service = null;
                try {
                    service = layer.getGeoResource().service(null);
                    if (service.canResolve(ServiceMover.class)) {
                        ServiceMover tmp = (ServiceMover)service.resolve(ServiceMover.class, null);
                        String msg = tmp.move(this.projectDataFolder);
                        if (msg == null) continue;
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)"Comsolidation Error", (String)msg);
                        continue;
                    }
                    System.out.println("Not resolved: " + layer.getName());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private File checkProjectEnvironment() {
        URI projectUri = this.project.eResource().getURI();
        String devicePath = projectUri.devicePath();
        String projectFolderFile = new File(devicePath).getParent();
        File dataFolder = new File(String.valueOf(projectFolderFile) + File.separator + "data");
        if (dataFolder.exists() || dataFolder.mkdirs()) {
            return dataFolder;
        }
        return null;
    }
}

