/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.HashMap;
import java.util.Map;
import net.refractions.udig.project.IProjectElement;
import net.refractions.udig.project.ui.UDIGEditorInput;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class UDIGEditorInputDescriptor {
    protected String editorID;
    protected String name;
    protected Class type;
    protected IConfigurationElement extensionElement;
    protected Map<IProjectElement, UDIGEditorInput> instances = new HashMap<IProjectElement, UDIGEditorInput>();

    public UDIGEditorInput createInput(IProjectElement element) {
        if (!this.instances.containsKey(element)) {
            UDIGEditorInput input;
            try {
                input = (UDIGEditorInput)this.extensionElement.createExecutableExtension("class");
                input.setEditorId(this.editorID);
            }
            catch (CoreException e) {
                ProjectUIPlugin.log("Error creating input type", e);
                return null;
            }
            input.setProjectElement(element);
            this.instances.put(element, input);
        }
        return this.instances.get(element);
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public String getEditorID() {
        return this.editorID;
    }

    public void setEditorID(String editorID) {
        this.editorID = editorID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IConfigurationElement getExtensionElement() {
        return this.extensionElement;
    }

    public void setExtensionElement(IConfigurationElement extensionElement) {
        this.extensionElement = extensionElement;
    }
}

