/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.ContextModelListenerAdapter;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.CompositeRenderContext;
import net.refractions.udig.project.internal.render.ExecutorVisitor;
import net.refractions.udig.project.internal.render.RenderExecutor;
import net.refractions.udig.project.internal.render.RenderFactory;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.internal.render.RendererCreator;
import net.refractions.udig.project.internal.render.SelectionLayer;
import net.refractions.udig.project.internal.render.impl.CompositeRenderContextImpl;
import net.refractions.udig.project.internal.render.impl.RenderContextImpl;
import net.refractions.udig.project.internal.render.impl.RenderExecutorComposite;
import net.refractions.udig.project.internal.render.impl.RenderExecutorMultiLayer;
import net.refractions.udig.project.internal.render.impl.RenderManagerImpl;
import net.refractions.udig.project.internal.render.impl.TiledCompositeRendererImpl;
import net.refractions.udig.project.internal.render.impl.TiledRendererCreatorImpl;
import net.refractions.udig.project.internal.render.impl.UDIGLabelCache;
import net.refractions.udig.project.render.AbstractRenderMetrics;
import net.refractions.udig.project.render.ILabelPainter;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.IRenderer;
import net.refractions.udig.project.render.Tile;
import net.refractions.udig.project.render.TileStateChangedListener;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.RenderManagerAdapters;
import net.refractions.udig.project.ui.internal.render.displayAdapter.impl.ViewportPaneTiledSWT;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.lite.LabelCache;
import org.geotools.util.ObjectCache;
import org.geotools.util.ObjectCaches;

public class TiledRenderManagerDynamic
extends RenderManagerImpl {
    private static final int TILE_SIZE = 512;
    private Coordinate tileCenter = new Coordinate(0.0, 0.0);
    ContextModelListenerAdapter contextModelAdapter = RenderManagerAdapters.createContextModelListener(this);
    Adapter viewportListener = RenderManagerAdapters.createViewportListener(this);
    private Adapter viewportModelChangeListener = RenderManagerAdapters.createViewportModelChangeListener(this, this.viewportListener, this.contextModelAdapter);
    private Adapter visibilityChangedListener = RenderManagerAdapters.createVisibilityChangedAdapater(this);
    Adapter renderExecutorListener = RenderManagerAdapters.getRenderExecutorListener((RenderManager)this);
    Adapter selectionListener = RenderManagerAdapters.createLayerListener(this);
    ObjectCache tileCache = ObjectCaches.create((String)"soft", (int)50);
    Set<Tile> importantTiles = Collections.synchronizedSet(new HashSet());
    TileStateChangedListener tileStateListener = new TileStateChangedListener(){

        public void screenStateChanged(Tile t) {
            this.updateImportantTileList(t);
        }

        public void validationStateChanged(Tile t) {
            this.updateImportantTileList(t);
        }

        public void renderStateChanged(Tile t) {
        }

        public void contextStateChanged(Tile t) {
        }

        private void updateImportantTileList(Tile t) {
            if (t.getScreenState() == Tile.ScreenState.ONSCREEN || t.getTileState() == Tile.ValidatedState.VALIDATED) {
                TiledRenderManagerDynamic.this.importantTiles.add(t);
            } else {
                TiledRenderManagerDynamic.this.importantTiles.remove(t);
            }
        }
    };
    RenderTileJob tileRenderJob = null;
    private BufferedImage screen = null;

    public TiledRenderManagerDynamic() {
        this.rendererCreator = null;
        this.eAdapters().add((Object)this.viewportModelChangeListener);
    }

    public RendererCreator getRendererCreator() {
        this.checkState();
        if (this.rendererCreator == null) {
            this.initRenderCreator();
        }
        return this.rendererCreator;
    }

    private void initRenderCreator() {
        this.rendererCreator = new TiledRendererCreatorImpl(this.getTileSize(), (RenderManager)this);
        List layers = this.getMapInternal().getLayersInternal();
        ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 5, 0, null, (Object)layers);
        this.getRendererCreator().changed((Notification)notification);
    }

    private Tile getOrCreateTile(ReferencedEnvelope env) {
        Tile tile = (Tile)this.tileCache.get((Object)env);
        if (tile == null) {
            try {
                this.tileCache.writeLock((Object)env);
                tile = (Tile)this.tileCache.peek((Object)env);
                if (tile == null) {
                    tile = this.createTile(env);
                    this.tileCache.put((Object)env, (Object)tile);
                }
            }
            finally {
                this.tileCache.writeUnLock((Object)env);
            }
        }
        return tile;
    }

    private Tile createTile(ReferencedEnvelope key) {
        RenderExecutorComposite newRE = this.createRenderExecutor(key);
        Tile tile = new Tile(key, newRE, this.getTileSize());
        tile.setStateChangedListener(this.tileStateListener);
        this.importantTiles.add(tile);
        ((RenderContextImpl)newRE.getContext()).setLabelPainterLocal(newRE.getContext().getLabelPainter());
        return tile;
    }

    public void refresh(ILayer layer, Envelope bounds) {
        this.checkState();
        if (!this.renderingEnabled) {
            return;
        }
        if (this.getMapDisplay() == null || this.getMapDisplay().getWidth() < 1 || this.getMapDisplay().getHeight() < 1) {
            return;
        }
        SelectionLayer selectionLayer = this.getRendererCreator().findSelectionLayer(layer);
        ReferencedEnvelope areaOfInterest = null;
        areaOfInterest = bounds == null ? this.getMap().getViewportModel().getBounds() : new ReferencedEnvelope(bounds, this.getMap().getViewportModel().getCRS());
        ReferencedEnvelope viewportbounds = this.getMap().getViewportModel().getBounds();
        double resolution = viewportbounds.getWidth() / (double)this.getMapDisplay().getWidth();
        Collection<ReferencedEnvelope> tileBounds = this.computeTileBounds(areaOfInterest, resolution);
        this.setTileStateToOld(tileBounds);
        for (ReferencedEnvelope env : tileBounds) {
            ReferencedEnvelope bbox = env;
            if (bbox.isNull()) continue;
            Tile tile = this.getOrCreateTile(env);
            tile.setTileState(Tile.ValidatedState.VALIDATED);
            tile.setRenderState(Tile.RenderState.RENDERED);
            RenderExecutorComposite re = tile.getRenderExecutor();
            List<Object> torefresh = new ArrayList();
            if (tile.getContextState() == Tile.ContextState.INVALID) {
                torefresh = this.validateRendererConfiguration(tile);
                tile.setContextState(Tile.ContextState.OKAY);
            }
            ArrayList<Object> layersToUpdate = new ArrayList<Object>();
            layersToUpdate.add(layer);
            if (selectionLayer != null) {
                layersToUpdate.add(selectionLayer);
            }
            if (torefresh != null) {
                for (AbstractRenderMetrics abstractRenderMetrics : torefresh) {
                    layersToUpdate.add(abstractRenderMetrics.getRenderContext().getLayer());
                }
            }
            for (final ILayer iLayer : layersToUpdate) {
                re.visit(new ExecutorVisitor((Envelope)bbox){
                    private final /* synthetic */ Envelope val$bbox;
                    {
                        this.val$bbox = envelope;
                    }

                    public void visit(RenderExecutor executor) {
                        if (executor.getContext().getLayer() == iLayer) {
                            executor.getRenderer().setRenderBounds(this.val$bbox);
                            executor.getRenderer().setState(16);
                        }
                    }

                    public void visit(RenderExecutorMultiLayer executor) {
                        if (executor.getContext().getLayers().contains(iLayer)) {
                            executor.getRenderer().setState(16);
                        }
                    }

                    public void visit(RenderExecutorComposite executor) {
                        ArrayList executors = new ArrayList(executor.getRenderer().getRenderExecutors());
                        for (RenderExecutor child : executors) {
                            child.visit((ExecutorVisitor)this);
                        }
                    }
                });
            }
        }
    }

    public void refreshSelection(ILayer layer, Envelope bounds) {
        this.checkState();
        if (!this.renderingEnabled) {
            return;
        }
        if (this.getMapDisplay() == null || this.getMapDisplay().getWidth() < 1 || this.getMapDisplay().getHeight() < 1) {
            return;
        }
        final SelectionLayer selectionLayer = this.getRendererCreator().findSelectionLayer(layer);
        if (selectionLayer == null) {
            return;
        }
        ReferencedEnvelope areaOfInterest = null;
        areaOfInterest = bounds == null ? this.getMap().getViewportModel().getBounds() : new ReferencedEnvelope(bounds, this.getMap().getViewportModel().getCRS());
        ReferencedEnvelope viewportbounds = this.getMap().getViewportModel().getBounds();
        double resolution = viewportbounds.getWidth() / (double)this.getMapDisplay().getWidth();
        this.invalidateAllTilesRenderState();
        Collection<ReferencedEnvelope> tileBounds = this.computeTileBounds(areaOfInterest, resolution);
        this.setTileStateToOld(tileBounds);
        for (ReferencedEnvelope env : tileBounds) {
            Tile tile = this.getOrCreateTile(env);
            tile.setRenderState(Tile.RenderState.RENDERED);
            tile.setTileState(Tile.ValidatedState.VALIDATED);
            RenderExecutorComposite re = tile.getRenderExecutor();
            if (tile.getContextState() == Tile.ContextState.INVALID) {
                this.validateRendererConfiguration(tile);
                tile.setContextState(Tile.ContextState.OKAY);
            }
            ReferencedEnvelope bbox = env;
            re.visit(new ExecutorVisitor((Envelope)bbox){
                private final /* synthetic */ Envelope val$bbox;
                {
                    this.val$bbox = envelope;
                }

                public void visit(RenderExecutor executor) {
                    IRenderContext context = executor.getContext();
                    if (selectionLayer == context.getLayer()) {
                        executor.getRenderer().setRenderBounds(this.val$bbox);
                        context.clearImage();
                        executor.getRenderer().setState(16);
                    }
                }

                public void visit(RenderExecutorMultiLayer executor) {
                    CompositeRenderContext contexts = executor.getContext();
                    for (IRenderContext context : contexts.getContexts()) {
                        if (context.getLayer() != selectionLayer) continue;
                        executor.getRenderer().setState(16);
                        return;
                    }
                }

                public void visit(RenderExecutorComposite executor) {
                    for (RenderExecutor child : executor.getRenderer().getRenderExecutors()) {
                        child.visit((ExecutorVisitor)this);
                    }
                }
            });
        }
    }

    public void clearSelection(ILayer layer) {
        this.checkState();
        if (this.getMapDisplay() == null) {
            return;
        }
        SelectionLayer selectionLayer = this.getRendererCreator().findSelectionLayer(layer);
        if (selectionLayer == null) {
            return;
        }
        this.invalidateAllTilesRenderState();
        this.refreshImage();
    }

    private void setTileStateToOld(Collection<ReferencedEnvelope> validTiles) {
        for (ReferencedEnvelope key : this.tileCache.getKeys()) {
            Tile t = (Tile)this.tileCache.get((Object)key);
            if (t == null || validTiles.contains(key)) continue;
            t.setTileState(Tile.ValidatedState.OLD);
        }
    }

    public void renderTiles(Collection<Tile> tiles) {
        if (tiles == null || tiles.isEmpty()) {
            return;
        }
        if (this.tileRenderJob == null) {
            this.tileRenderJob = new RenderTileJob(this);
        }
        this.tileRenderJob.addTiles(tiles);
        this.tileRenderJob.schedule();
    }

    public void cancelTileRenderJobs() {
        if (this.tileRenderJob != null) {
            this.tileRenderJob.clear();
            this.tileRenderJob.cancel();
        }
    }

    public void renderTile(Tile tile) {
        boolean rendertile = tile.getRenderState() == Tile.RenderState.INVALID || tile.getRenderState() == Tile.RenderState.NEW;
        tile.setTileState(Tile.ValidatedState.VALIDATED);
        RenderExecutorComposite re = tile.getRenderExecutor();
        List<AbstractRenderMetrics> forrefresh = null;
        if (tile.getContextState() == Tile.ContextState.INVALID) {
            forrefresh = this.validateRendererConfiguration(tile);
            tile.setContextState(Tile.ContextState.OKAY);
            if (forrefresh == null) {
                rendertile = true;
            }
        }
        if (!rendertile && forrefresh != null) {
            for (AbstractRenderMetrics context : forrefresh) {
                List kids = ((TiledCompositeRendererImpl)re.getRenderer()).getChildren();
                for (TiledCompositeRendererImpl.RenderInfo r : kids) {
                    if (!r.getMetrics().getRenderContext().equals(context.getRenderContext())) continue;
                    r.getExecutor().getRenderer().setRenderBounds((Envelope)tile.getReferencedEnvelope());
                    r.getExecutor().getRenderer().setState(16);
                }
            }
        } else if (rendertile) {
            re.setRenderBounds((Envelope)tile.getReferencedEnvelope());
            re.render();
        }
        tile.setRenderState(Tile.RenderState.RENDERED);
        this.refreshImage();
    }

    public void softRefresh(Envelope bounds) {
        this.checkState();
        if (!this.renderingEnabled) {
            return;
        }
        this.getViewportModelInternal().setInitialized(true);
        if (this.getMapDisplay() == null) {
            return;
        }
        if (this.getMapDisplay().getWidth() < 1 || this.getMapDisplay().getHeight() < 1) {
            return;
        }
        ReferencedEnvelope areaOfInterest = null;
        areaOfInterest = bounds == null ? this.getMap().getViewportModel().getBounds() : new ReferencedEnvelope(bounds, this.getMap().getViewportModel().getCRS());
        ReferencedEnvelope viewportbounds = this.getMap().getViewportModel().getBounds();
        double resolution = viewportbounds.getWidth() / (double)this.getMapDisplay().getWidth();
        Collection<ReferencedEnvelope> tileBounds = this.computeTileBounds(areaOfInterest, resolution);
        this.setTileStateToOld(tileBounds);
        for (ReferencedEnvelope referencedEnvelope : tileBounds) {
            Tile tile = this.getOrCreateTile(referencedEnvelope);
            boolean rendertile = tile.getRenderState() == Tile.RenderState.INVALID || tile.getRenderState() == Tile.RenderState.NEW;
            tile.setTileState(Tile.ValidatedState.VALIDATED);
            RenderExecutorComposite re = tile.getRenderExecutor();
            List<AbstractRenderMetrics> forrefresh = null;
            if (tile.getContextState() == Tile.ContextState.INVALID) {
                forrefresh = this.validateRendererConfiguration(tile);
                tile.setContextState(Tile.ContextState.OKAY);
                if (forrefresh == null) {
                    rendertile = true;
                }
            }
            if (!rendertile && forrefresh != null) {
                for (AbstractRenderMetrics context : forrefresh) {
                    List kids = ((TiledCompositeRendererImpl)re.getRenderer()).getChildren();
                    for (TiledCompositeRendererImpl.RenderInfo r : kids) {
                        if (!r.getMetrics().getRenderContext().equals(context.getRenderContext())) continue;
                        r.getExecutor().getRenderer().setRenderBounds((Envelope)referencedEnvelope);
                        r.getExecutor().getRenderer().setState(16);
                    }
                }
                continue;
            }
            if (!rendertile) continue;
            List kids = ((TiledCompositeRendererImpl)re.getRenderer()).getChildren();
            for (TiledCompositeRendererImpl.RenderInfo r : kids) {
                r.getExecutor().getRenderer().setRenderBounds((Envelope)referencedEnvelope);
                r.getExecutor().getRenderer().setState(16);
            }
            re.setState(16);
        }
        if (!this.getMapInternal().getContextModel().eAdapters().contains((Object)this.contextModelAdapter)) {
            this.getMapInternal().getContextModel().eAdapters().add((Object)this.contextModelAdapter);
        }
        this.refreshImage();
    }

    public void refresh(Envelope bounds) {
        if (this.getRendererCreator() != null) {
            ((TiledRendererCreatorImpl)this.getRendererCreator()).reset();
        }
        if (this.getMapDisplay() instanceof ViewportPaneTiledSWT) {
            ViewportPaneTiledSWT tiledpane = (ViewportPaneTiledSWT)this.getMapDisplay();
            tiledpane.clearCachedTiles();
            tiledpane.clearReadyTiles();
        }
        this.disposeAllTiles();
        this.tileCache.clear();
        this.importantTiles.clear();
        this.softRefresh(bounds);
    }

    public void refreshImage() {
        ReferencedEnvelope areaOfInterest = this.getMap().getViewportModel().getBounds();
        ReferencedEnvelope viewportbounds = this.getMap().getViewportModel().getBounds();
        double resolution = viewportbounds.getWidth() / (double)this.getMapDisplay().getWidth();
        Collection<ReferencedEnvelope> tileBounds = this.computeTileBounds(areaOfInterest, resolution);
        for (ReferencedEnvelope referencedEnvelope : tileBounds) {
            Tile tile = this.getOrCreateTile(referencedEnvelope);
            RenderExecutorComposite re = tile.getRenderExecutor();
            if (tile.getRenderState() == Tile.RenderState.INVALID) {
                re.setRenderBounds((Envelope)tile.getReferencedEnvelope());
                re.getRenderer().setState(16);
                re.render();
            } else {
                re.getRenderer().setState(4);
            }
            tile.setRenderState(Tile.RenderState.RENDERED);
        }
    }

    public int getTileSize() {
        return 512;
    }

    public Collection<ReferencedEnvelope> computeTileBounds(ReferencedEnvelope viewBounds, double worldunitsperpixel) {
        double unittilesize = worldunitsperpixel * (double)this.getTileSize();
        double minx = viewBounds.getMinX();
        double minxtile = Math.floor((minx - this.tileCenter.x) / unittilesize) * unittilesize + this.tileCenter.x;
        double maxx = viewBounds.getMaxX();
        double maxxtile = (Math.floor((maxx - this.tileCenter.x) / unittilesize) + 1.0) * unittilesize + this.tileCenter.x;
        double miny = viewBounds.getMinY();
        double minytile = Math.floor((miny - this.tileCenter.y) / unittilesize) * unittilesize + this.tileCenter.y;
        double maxy = viewBounds.getMaxY();
        double maxytile = (Math.floor((maxy - this.tileCenter.y) / unittilesize) + 1.0) * unittilesize + this.tileCenter.y;
        ArrayList<ReferencedEnvelope> tileBounds = new ArrayList<ReferencedEnvelope>();
        int numberx = (int)Math.round((maxxtile - minxtile) / unittilesize);
        int numbery = (int)Math.round((maxytile - minytile) / unittilesize);
        int x = 0;
        while (x < numberx) {
            double xvalue = (double)x * unittilesize + minxtile;
            double xvaluemax = (double)(x + 1) * unittilesize + minxtile;
            xvalue = TiledRenderManagerDynamic.roundDouble(xvalue);
            xvaluemax = TiledRenderManagerDynamic.roundDouble(xvaluemax);
            int y = 0;
            while (y < numbery) {
                double yvalue = (double)y * unittilesize + minytile;
                double yvaluemax = (double)(y + 1) * unittilesize + minytile;
                yvalue = TiledRenderManagerDynamic.roundDouble(yvalue);
                yvaluemax = TiledRenderManagerDynamic.roundDouble(yvaluemax);
                ReferencedEnvelope env = new ReferencedEnvelope(xvalue, xvaluemax, yvalue, yvaluemax, viewBounds.getCoordinateReferenceSystem());
                tileBounds.add(env);
                ++y;
            }
            ++x;
        }
        return tileBounds;
    }

    private static double roundDouble(double number) {
        Long xBits = Double.doubleToLongBits(number);
        int nBits = 8;
        long invMask = (1L << nBits) - 1L;
        long mask = invMask ^ 0xFFFFFFFFFFFFFFFFL;
        xBits = xBits & mask;
        return Double.longBitsToDouble(xBits);
    }

    public void dispose() {
        HashSet<net.refractions.udig.project.internal.Map> set = new HashSet<net.refractions.udig.project.internal.Map>();
        set.add(this.getMapInternal());
        TreeIterator iter = this.getMapInternal().eAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            this.removeAdapters(obj);
        }
        try {
            this.getMapInternal().removeDeepAdapter(this.visibilityChangedListener);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ((ViewportPane)this.mapDisplay).setRenderManager(null);
        this.disposeAllTiles();
        this.tileCache.clear();
        this.importantTiles.clear();
        super.dispose();
    }

    private void disposeAllTiles() {
        for (ReferencedEnvelope key : this.tileCache.getKeys()) {
            Tile t = (Tile)this.tileCache.get((Object)key);
            if (t == null) continue;
            this.removeAdapters((EObject)t.getRenderExecutor());
            t.dispose();
        }
    }

    private void removeAdapters(EObject obj) {
        obj.eAdapters().remove((Object)this.viewportListener);
        obj.eAdapters().remove((Object)this.viewportModelChangeListener);
        obj.eAdapters().remove((Object)this.contextModelAdapter);
        obj.eAdapters().remove((Object)this.renderExecutorListener);
        obj.eAdapters().remove((Object)this.selectionListener);
    }

    public void setDisplayGen(IMapDisplay newDisplay) {
        IMapDisplay oldDisplay = this.mapDisplay;
        this.mapDisplay = newDisplay;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldDisplay, (Object)this.mapDisplay));
        }
    }

    public void setDisplay(IMapDisplay value) {
        this.checkState();
        ((ViewportPane)value).setRenderManager((RenderManager)this);
        this.setDisplayGen(value);
    }

    public NotificationChain basicSetMapInternal(net.refractions.udig.project.internal.Map newMap, NotificationChain msgs) {
        if (this.getMapInternal() != null) {
            this.getMapInternal().eAdapters().remove((Object)this.selectionListener);
            this.getMapInternal().removeDeepAdapter(this.selectionListener);
        }
        if (newMap != null) {
            newMap.eAdapters().add((Object)this.selectionListener);
            newMap.addDeepAdapter(this.selectionListener);
        }
        NotificationChain change = super.basicSetMapInternal(newMap, msgs);
        if (this.getMapInternal() != null) {
            this.getMapInternal().addDeepAdapter(this.visibilityChangedListener);
        }
        return change;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<AbstractRenderMetrics> validateRendererConfiguration(Tile t) {
        List currentconfiguration;
        this.checkState();
        if (this.rendererCreator == null) {
            this.initRenderCreator();
        }
        RenderExecutorComposite re = t.getRenderExecutor();
        TiledCompositeRendererImpl renderer = null;
        try {
            renderer = (TiledCompositeRendererImpl)re.getRenderer();
        }
        catch (Exception ex) {
            ProjectPlugin.log((String)"Error creating context for tile - Tile does not have a renderer.", (Throwable)ex);
            return null;
        }
        if (renderer == null) {
            ProjectPlugin.log((String)"Error creating context for tile - Tile does not have a renderer.");
            return null;
        }
        TiledRenderManagerDynamic tiledRenderManagerDynamic = this;
        synchronized (tiledRenderManagerDynamic) {
            currentconfiguration = renderer.getChildren().size() == 0 ? null : renderer.getChildrenMetrics();
        }
        ArrayList<AbstractRenderMetrics> newcontexts = new ArrayList<AbstractRenderMetrics>();
        ILabelPainter tilelabelpainter = ((RenderContextImpl)t.getRenderExecutor().getContext()).getLabelPainter();
        if (currentconfiguration == null) {
            Collection newconfig = ((TiledRendererCreatorImpl)this.getRendererCreator()).getConfiguration(t.getReferencedEnvelope());
            renderer.removeAllChildren();
            renderer.addChildren(newconfig);
            newcontexts = null;
            for (AbstractRenderMetrics abstractRenderMetrics : newconfig) {
                ((RenderContextImpl)abstractRenderMetrics.getRenderContext()).setLabelPainterLocal(tilelabelpainter);
            }
        } else {
            Collection newconfig = ((TiledRendererCreatorImpl)this.getRendererCreator()).getConfiguration(t.getReferencedEnvelope());
            ArrayList<AbstractRenderMetrics> removeList = new ArrayList<AbstractRenderMetrics>();
            ArrayList<AbstractRenderMetrics> addList = new ArrayList<AbstractRenderMetrics>();
            for (AbstractRenderMetrics metric : currentconfiguration) {
                if (newconfig.contains(metric)) continue;
                removeList.add(metric);
            }
            for (AbstractRenderMetrics metric : newconfig) {
                if (currentconfiguration.contains(metric)) continue;
                addList.add(metric);
                ((RenderContextImpl)metric.getRenderContext()).setLabelPainterLocal(tilelabelpainter);
            }
            newcontexts.addAll(addList);
            renderer.removeChildren(removeList);
            if (!addList.isEmpty()) {
                renderer.removeChildren(addList);
            }
            renderer.addChildren(addList);
            for (AbstractRenderMetrics metric : removeList) {
                ((RenderContextImpl)metric.getRenderContext()).dispose();
            }
        }
        return newcontexts;
    }

    private RenderExecutorComposite createRenderExecutor(ReferencedEnvelope bounds) {
        this.checkState();
        TiledCompositeRendererImpl renderer = RenderFactory.eINSTANCE.createTiledCompositeRenderer();
        CompositeRenderContextImpl context = new CompositeRenderContextImpl(){

            public synchronized BufferedImage getImage(int width, int height) {
                if (this.image == null || this.image.getWidth() < width || this.image.getHeight() < height) {
                    this.image = new BufferedImage(width, height, 5);
                    Graphics2D g = this.image.createGraphics();
                    g.setBackground(Color.WHITE);
                    g.clearRect(0, 0, width, height);
                    g.dispose();
                }
                return this.image;
            }

            public synchronized void clearImage(Rectangle paintArea) {
                if (this.image == null) {
                    return;
                }
                Graphics2D g = this.image.createGraphics();
                g.setBackground(Color.WHITE);
                g.clearRect(paintArea.x, paintArea.y, paintArea.width, paintArea.height);
                g.dispose();
            }
        };
        context.setMapInternal(this.getMapInternal());
        context.setRenderManagerInternal((RenderManager)this);
        context.setImageBounds(bounds);
        context.setImageSize(new Dimension(this.getTileSize(), this.getTileSize()));
        ((CompositeRenderContextImpl)context).setLabelPainterLocal((ILabelPainter)new UDIGLabelCache((LabelCache)new LabelCacheImpl()));
        renderer.setContext((IRenderContext)context);
        renderer.setName(Messages.RenderManagerDynamic_allLayers);
        RenderExecutorComposite renderExecutor = (RenderExecutorComposite)RenderFactory.eINSTANCE.createRenderExecutor((Renderer)renderer);
        renderExecutor.setName("Tiled (" + bounds.hashCode() + "): " + bounds.toString());
        renderExecutor.eAdapters().add((Object)this.renderExecutorListener);
        return renderExecutor;
    }

    public boolean areLayersRelatedByContext(ILayer layer, ILayer contained) {
        if (this.tileCache.getKeys().size() == 0) {
            return false;
        }
        if (layer == contained) {
            return true;
        }
        Tile t = null;
        Iterator keys = this.tileCache.getKeys().iterator();
        while (t == null && keys.hasNext()) {
            t = (Tile)this.tileCache.get((Object)((ReferencedEnvelope)keys.next()));
        }
        if (t == null) {
            return false;
        }
        RenderExecutorComposite parent = t.getRenderExecutor();
        List kids = ((TiledCompositeRendererImpl)parent.getRenderer()).getChildren();
        for (TiledCompositeRendererImpl.RenderInfo kid : kids) {
            IRenderContext childcontext = kid.getRenderer().getContext();
            if (childcontext instanceof CompositeRenderContext) {
                if (!((CompositeRenderContext)childcontext).getLayers().contains(layer)) continue;
                return ((CompositeRenderContext)childcontext).getLayers().contains(contained);
            }
            if (childcontext.getLayer() != layer) continue;
            return false;
        }
        return false;
    }

    public RenderExecutor getRenderExecutor() {
        return null;
    }

    public void setRenderExecutor(RenderExecutor newRenderExecutor) {
        throw new UnsupportedOperationException("This operation is not supported for a Tiled Render Manager Dynamic.");
    }

    public List<IRenderer> getRenderers() {
        throw new UnsupportedOperationException("Invalid operation for a Tiled RenderManager Dynamic.");
    }

    public Map<ReferencedEnvelope, Tile> getTiles(Collection<ReferencedEnvelope> bounds) {
        if (bounds == null) {
            ReferencedEnvelope viewportbounds = this.getViewportModelInternal().getBounds();
            bounds = this.computeTileBounds(viewportbounds, viewportbounds.getWidth() / (double)this.getMapDisplay().getWidth());
        }
        HashMap<ReferencedEnvelope, Tile> newTiles = new HashMap<ReferencedEnvelope, Tile>();
        try {
            for (ReferencedEnvelope env : bounds) {
                Tile tile = this.getOrCreateTile(env);
                tile.setScreenState(Tile.ScreenState.ONSCREEN);
                if (tile.getRenderState() == Tile.RenderState.INVALID) {
                    tile.getRenderExecutor().setRenderBounds((Envelope)tile.getReferencedEnvelope());
                    tile.getRenderExecutor().setState(16);
                }
                newTiles.put(env, tile);
            }
            for (ReferencedEnvelope referencedEnvelope : this.tileCache.getKeys()) {
                Tile t = (Tile)this.tileCache.get((Object)referencedEnvelope);
                if (t == null || newTiles.containsKey(referencedEnvelope)) continue;
                t.setScreenState(Tile.ScreenState.OFFSCREEN);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return newTiles;
    }

    private void invalidateAllTilesRenderState() {
        for (ReferencedEnvelope key : this.tileCache.getKeys()) {
            Tile t = (Tile)this.tileCache.get((Object)key);
            if (t == null) continue;
            t.setRenderState(Tile.RenderState.INVALID);
        }
    }

    private void invalidateAllTileContext() {
        for (ReferencedEnvelope key : this.tileCache.getKeys()) {
            Tile t = (Tile)this.tileCache.get((Object)key);
            if (t == null) continue;
            t.setContextState(Tile.ContextState.INVALID);
        }
    }

    public RenderedImage getImage() {
        ReferencedEnvelope bounds = this.getViewportModelInternal().getBounds();
        Collection<ReferencedEnvelope> tileBounds = this.computeTileBounds(bounds, bounds.getWidth() / (double)this.getMapDisplay().getWidth());
        if (this.screen == null || this.screen.getWidth() != this.getMapDisplay().getWidth() || this.screen.getHeight() != this.getMapDisplay().getHeight()) {
            this.screen = new BufferedImage(this.getMapDisplay().getWidth(), this.getMapDisplay().getHeight(), 2);
        }
        Graphics2D g = this.screen.createGraphics();
        g.setBackground(new Color(0, 0, 0, 0));
        g.clearRect(0, 0, this.getMapDisplay().getWidth(), this.getMapDisplay().getHeight());
        for (ReferencedEnvelope referencedEnvelope : this.tileCache.getKeys()) {
            Tile t = (Tile)this.tileCache.get((Object)referencedEnvelope);
            if (t == null || tileBounds.contains(referencedEnvelope)) continue;
            t.setScreenState(Tile.ScreenState.OFFSCREEN);
        }
        try {
            for (ReferencedEnvelope env : tileBounds) {
                Tile tile = this.getOrCreateTile(env);
                tile.setScreenState(Tile.ScreenState.ONSCREEN);
                BufferedImage tileimage = tile.getBufferedImage();
                Point a = this.getViewportModelInternal().worldToPixel(new Coordinate(env.getMinX(), env.getMinY()));
                Point b = this.getViewportModelInternal().worldToPixel(new Coordinate(env.getMaxX(), env.getMaxY()));
                g.drawImage(tileimage, a.x, b.y, b.x - a.x, a.y - b.y, null);
                g.setColor(Color.BLACK);
                g.drawLine(a.x, a.y, a.x, b.y);
                g.drawLine(a.x, b.y, b.x, b.y);
                g.drawLine(b.x, b.y, b.x, a.y);
                g.drawLine(b.x, a.y, a.x, a.y);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        g.dispose();
        return this.screen;
    }

    public void zorderChanged(Notification msg) {
        this.getRendererCreator().changed(msg);
        this.invalidateAllTilesRenderState();
        this.invalidateAllTileContext();
        Layer newV = (Layer)msg.getNewValue();
        this.refresh((ILayer)newV, null);
    }

    public void layersAdded(Notification msg) {
        this.getRendererCreator().changed(msg);
        this.invalidateAllTileContext();
        ArrayList<Layer> addedLayers = new ArrayList<Layer>();
        switch (msg.getEventType()) {
            case 3: {
                Layer layer = (Layer)msg.getNewValue();
                addedLayers.add(layer);
                break;
            }
            case 5: {
                for (Layer layer : (Collection)msg.getNewValue()) {
                    addedLayers.add(layer);
                }
                break;
            }
        }
        for (Layer layer : addedLayers) {
            this.refresh((ILayer)layer, null);
        }
    }

    public void layersRemoved(Notification msg) {
        this.getRendererCreator().changed(msg);
        this.invalidateAllTileContext();
        this.invalidateAllTilesRenderState();
        this.softRefresh(null);
    }

    public void crsChanged(Notification msg) {
        this.disposeAllTiles();
        this.tileCache.clear();
        this.importantTiles.clear();
        this.softRefresh(null);
    }

    public void viewportChanged(Notification msg) {
        if (this.getViewportModelInternal().isBoundsChanging()) {
            if (this.getMapDisplay() instanceof ViewportPaneTiledSWT) {
                Collection<Tile> newtiles = ((ViewportPaneTiledSWT)this.getMapDisplay()).updateReadyTiles();
                this.renderTiles(newtiles);
            }
        } else {
            if (this.getMapDisplay() instanceof ViewportPaneTiledSWT) {
                this.cancelTileRenderJobs();
            }
            if (ApplicationGIS.getActiveMap() != null && ApplicationGIS.getVisibleMaps().contains(ApplicationGIS.getActiveMap())) {
                this.softRefresh(null);
            }
        }
    }

    public void blackBoardChanged(Layer layer) {
        if (layer instanceof SelectionLayer) {
            return;
        }
        this.invalidateAllTilesRenderState();
        this.refresh((ILayer)layer, null);
    }

    public void layerMadeVisible(Layer layer) {
        ReferencedEnvelope areaOfInterest = this.getMap().getViewportModel().getBounds();
        ReferencedEnvelope viewportbounds = this.getMap().getViewportModel().getBounds();
        double resolution = viewportbounds.getWidth() / (double)this.getMapDisplay().getWidth();
        Collection<ReferencedEnvelope> tileBounds = this.computeTileBounds(areaOfInterest, resolution);
        for (ReferencedEnvelope key : this.tileCache.getKeys()) {
            Tile t = (Tile)this.tileCache.get((Object)key);
            if (tileBounds.contains(key)) continue;
            t.setRenderState(Tile.RenderState.INVALID);
        }
    }

    class RenderTileJob
    extends Job {
        private List<Tile> tilestorender;
        private TiledRenderManagerDynamic manager;

        public RenderTileJob(TiledRenderManagerDynamic manager) {
            super("Pan Tile Rendering Job");
            this.tilestorender = new ArrayList<Tile>();
            this.manager = manager;
        }

        public void addTiles(Collection<Tile> tiles) {
            this.tilestorender.addAll(tiles);
        }

        public void clear() {
            this.tilestorender.clear();
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.tilestorender.size() == 0) {
                return Status.OK_STATUS;
            }
            Tile t = this.tilestorender.remove(0);
            this.manager.renderTile(t);
            if (this.tilestorender.size() > 0) {
                this.schedule();
            }
            return Status.OK_STATUS;
        }
    }
}

