/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.ContextModelListenerAdapter;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.CompositeRenderContext;
import net.refractions.udig.project.internal.render.ExecutorVisitor;
import net.refractions.udig.project.internal.render.MultiLayerRenderer;
import net.refractions.udig.project.internal.render.RenderContext;
import net.refractions.udig.project.internal.render.RenderExecutor;
import net.refractions.udig.project.internal.render.RenderFactory;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.internal.render.SelectionLayer;
import net.refractions.udig.project.internal.render.impl.CompositeRenderContextImpl;
import net.refractions.udig.project.internal.render.impl.CompositeRendererImpl;
import net.refractions.udig.project.internal.render.impl.RenderExecutorComposite;
import net.refractions.udig.project.internal.render.impl.RenderExecutorMultiLayer;
import net.refractions.udig.project.internal.render.impl.RenderManagerImpl;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.RenderException;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.RenderManagerAdapters;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class RenderManagerDynamic
extends RenderManagerImpl {
    ContextModelListenerAdapter contextModelAdapter = RenderManagerAdapters.createContextModelListener(this);
    Adapter viewportListener = RenderManagerAdapters.createViewportListener(this);
    private Adapter viewportModelChangeListener = RenderManagerAdapters.createViewportModelChangeListener(this, this.viewportListener, this.contextModelAdapter);
    public volatile Collection<RenderContext> configuration = null;
    Adapter renderExecutorListener = RenderManagerAdapters.getRenderExecutorListener((RenderManager)this);
    Adapter selectionListener = RenderManagerAdapters.createLayerListener(this);

    public RenderManagerDynamic() {
        this.eAdapters().add((Object)this.viewportModelChangeListener);
    }

    public void refresh(final ILayer layer, Envelope bounds) {
        this.checkState();
        if (!this.renderingEnabled) {
            return;
        }
        if (this.getMapDisplay() == null || this.getRenderExecutor() == null) {
            return;
        }
        this.getRendererCreator().reset();
        this.validateRendererConfiguration();
        final SelectionLayer selectionLayer = this.getRendererCreator().findSelectionLayer(layer);
        final ReferencedEnvelope bbox = bounds == null || bounds instanceof ReferencedEnvelope ? (ReferencedEnvelope)bounds : new ReferencedEnvelope(bounds, this.getRenderExecutor().getContext().getCRS());
        this.getRenderExecutor().visit(new ExecutorVisitor(){

            public void visit(RenderExecutor executor) {
                if (executor.getContext().getLayer() == layer || selectionLayer == executor.getContext().getLayer()) {
                    executor.getRenderer().setRenderBounds((Envelope)bbox);
                    executor.getRenderer().setState(16);
                }
            }

            public void visit(RenderExecutorMultiLayer executor) {
                if (executor.getContext().getLayers().contains(layer) || executor.getContext().getLayers().contains(selectionLayer)) {
                    executor.getRenderer().setState(16);
                }
            }

            public void visit(RenderExecutorComposite executor) {
                ArrayList executors = new ArrayList(executor.getRenderer().getRenderExecutors());
                for (RenderExecutor child : executors) {
                    child.visit((ExecutorVisitor)this);
                }
            }
        });
    }

    public void refreshImage() {
        try {
            ((CompositeRendererImpl)this.getRenderExecutor().getRenderer()).refreshImage();
            this.getRenderExecutor().setState(4);
        }
        catch (RenderException e) {
            ProjectPlugin.log((String)"", (Throwable)e);
        }
    }

    public void refreshSelection(ILayer layer, Envelope bounds) {
        this.checkState();
        if (!this.renderingEnabled) {
            return;
        }
        if (this.getMapDisplay() == null || this.getRenderExecutor() == null) {
            return;
        }
        SelectionLayer selectionLayer = this.getRendererCreator().findSelectionLayer(layer);
        if (selectionLayer == null) {
            return;
        }
        this.getRendererCreator().reset();
        this.validateRendererConfiguration();
        this.getRenderExecutor().visit(new ExecutorVisitor((Layer)selectionLayer, bounds){
            private final /* synthetic */ Layer val$selectionLayer;
            private final /* synthetic */ Envelope val$bounds;
            {
                this.val$selectionLayer = layer;
                this.val$bounds = envelope;
            }

            public void visit(RenderExecutor executor) {
                IRenderContext context = executor.getContext();
                if (this.val$selectionLayer == context.getLayer()) {
                    executor.getRenderer().setRenderBounds(this.val$bounds);
                    if (this.val$bounds != null) {
                        Rectangle bounds2 = context.toShape(new ReferencedEnvelope(this.val$bounds, RenderManagerDynamic.this.getViewportModelInternal().getCRS())).getBounds();
                        context.clearImage(bounds2);
                    } else {
                        context.clearImage();
                    }
                    executor.getRenderer().setState(16);
                }
            }

            public void visit(RenderExecutorMultiLayer executor) {
                CompositeRenderContext contexts = executor.getContext();
                for (IRenderContext context : contexts.getContexts()) {
                    if (context.getLayer() != this.val$selectionLayer) continue;
                    executor.getRenderer().setState(16);
                    return;
                }
            }

            public void visit(RenderExecutorComposite executor) {
                for (RenderExecutor child : executor.getRenderer().getRenderExecutors()) {
                    child.visit((ExecutorVisitor)this);
                }
            }
        });
    }

    public void clearSelection(ILayer layer) {
        this.checkState();
        if (this.getMapDisplay() == null || this.getRenderExecutor() == null) {
            return;
        }
        SelectionLayer selectionLayer = this.getRendererCreator().findSelectionLayer(layer);
        if (selectionLayer == null) {
            return;
        }
        try {
            CompositeRendererImpl compositeRendererImpl = (CompositeRendererImpl)this.getRenderExecutor().getRenderer();
            compositeRendererImpl.refreshImage();
            compositeRendererImpl.setState(4);
        }
        catch (RenderException e) {
            ProjectUIPlugin.log("", e);
        }
    }

    public void refresh(Envelope bounds) {
        this.checkState();
        if (!this.renderingEnabled) {
            return;
        }
        this.getViewportModelInternal().setInitialized(true);
        if (this.getMapDisplay() == null) {
            return;
        }
        if (this.getMapDisplay().getWidth() < 1 || this.getMapDisplay().getHeight() < 1) {
            return;
        }
        this.getRendererCreator().reset();
        this.validateRendererConfiguration();
        if (!this.getMapInternal().getContextModel().eAdapters().contains((Object)this.contextModelAdapter)) {
            this.getMapInternal().getContextModel().eAdapters().add((Object)this.contextModelAdapter);
        }
        try {
            this.getRenderExecutor().setRenderBounds(bounds);
            this.getRenderExecutor().render();
        }
        catch (RenderException renderException) {}
    }

    void initRenderCreator(RenderContext context) {
        this.checkState();
        List layers = this.getMapInternal().getLayersInternal();
        this.getRendererCreator().setContext(context);
        ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 5, 0, null, (Object)layers);
        this.getRendererCreator().changed((Notification)notification);
    }

    public void dispose() {
        this.configuration = null;
        HashSet<Map> set = new HashSet<Map>();
        set.add(this.getMapInternal());
        TreeIterator iter = this.getMapInternal().eAllContents();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            this.removeAdapters(obj);
        }
        this.removeAdapters((EObject)this.getRenderExecutor());
        ((ViewportPane)this.mapDisplay).setRenderManager(null);
        super.dispose();
    }

    private void removeAdapters(EObject obj) {
        obj.eAdapters().remove((Object)this.viewportListener);
        obj.eAdapters().remove((Object)this.viewportModelChangeListener);
        obj.eAdapters().remove((Object)this.contextModelAdapter);
        obj.eAdapters().remove((Object)this.renderExecutorListener);
        obj.eAdapters().remove((Object)this.selectionListener);
    }

    public void setDisplayGen(IMapDisplay newDisplay) {
        IMapDisplay oldDisplay = this.mapDisplay;
        this.mapDisplay = newDisplay;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldDisplay, (Object)this.mapDisplay));
        }
    }

    public void setDisplay(IMapDisplay value) {
        this.checkState();
        ((ViewportPane)value).setRenderManager((RenderManager)this);
        this.setDisplayGen(value);
    }

    public void setRenderExecutor(RenderExecutor newRenderExecutor) {
        this.checkState();
        if (this.renderExecutor != null) {
            this.renderExecutor.eAdapters().remove((Object)this.renderExecutorListener);
        }
        if (newRenderExecutor != null && !newRenderExecutor.eAdapters().contains((Object)this.renderExecutorListener)) {
            newRenderExecutor.eAdapters().add((Object)this.renderExecutorListener);
        }
        super.setRenderExecutor(newRenderExecutor);
    }

    public NotificationChain basicSetMapInternal(Map newMap, NotificationChain msgs) {
        if (this.getMapInternal() != null) {
            this.getMapInternal().eAdapters().remove((Object)this.selectionListener);
            this.getMapInternal().removeDeepAdapter(this.selectionListener);
        }
        if (newMap != null) {
            newMap.eAdapters().add((Object)this.selectionListener);
            newMap.addDeepAdapter(this.selectionListener);
        }
        return super.basicSetMapInternal(newMap, msgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateRendererConfiguration() {
        Collection configuration2;
        ArrayList<RenderContext> configuration;
        this.checkState();
        RenderManagerDynamic renderManagerDynamic = this;
        synchronized (renderManagerDynamic) {
            configuration = this.configuration == null ? null : new ArrayList<RenderContext>(this.configuration);
        }
        if (configuration != null) {
            configuration2 = this.getRendererCreator().getConfiguration();
            ArrayList<RenderContext> removeList = new ArrayList<RenderContext>();
            ArrayList<RenderContext> addList = new ArrayList<RenderContext>();
            for (IRenderContext iRenderContext : configuration) {
                if (configuration2.contains(iRenderContext)) continue;
                removeList.add((RenderContext)iRenderContext);
            }
            for (RenderContext renderContext : configuration2) {
                if (configuration.contains(renderContext)) continue;
                addList.add(renderContext);
            }
            CompositeRenderContext compositeRenderContext = (CompositeRenderContext)this.getRenderExecutor().getContext();
            compositeRenderContext.removeContexts(removeList);
            if (!addList.isEmpty()) {
                compositeRenderContext.removeContexts(addList);
            }
            compositeRenderContext.addContexts(addList);
        } else {
            this.initRenderExecutor();
            configuration2 = this.getRendererCreator().getConfiguration();
            CompositeRenderContext compositecontext = (CompositeRenderContext)this.getRenderExecutor().getContext();
            compositecontext.clear();
            compositecontext.addContexts(configuration2);
        }
        RenderManagerDynamic renderManagerDynamic2 = this;
        synchronized (renderManagerDynamic2) {
            this.configuration = configuration2;
        }
        this.logRendererTypes();
    }

    private void initRenderExecutor() {
        this.checkState();
        MultiLayerRenderer renderExecutor = RenderFactory.eINSTANCE.createCompositeRenderer();
        CompositeRenderContextImpl context = new CompositeRenderContextImpl(){

            public synchronized BufferedImage getImage(int width, int height) {
                if (this.image == null || this.image.getWidth() < width || this.image.getHeight() < height) {
                    this.image = new BufferedImage(width, height, 5);
                    Graphics2D g = this.image.createGraphics();
                    g.setBackground(Color.WHITE);
                    g.clearRect(0, 0, width, height);
                    g.dispose();
                }
                return this.image;
            }

            public synchronized void clearImage(Rectangle paintArea) {
                if (this.image == null) {
                    return;
                }
                Graphics2D g = this.image.createGraphics();
                g.setBackground(Color.WHITE);
                g.clearRect(paintArea.x, paintArea.y, paintArea.width, paintArea.height);
                g.dispose();
            }
        };
        context.setMapInternal(this.getMapInternal());
        context.setRenderManagerInternal((RenderManager)this);
        renderExecutor.setContext((IRenderContext)context);
        this.initRenderCreator((RenderContext)context);
        renderExecutor.setName(Messages.RenderManagerDynamic_allLayers);
        this.setRenderExecutor(RenderFactory.eINSTANCE.createRenderExecutor((Renderer)renderExecutor));
    }

    private void logRendererTypes() {
        if (ProjectUIPlugin.isDebugging("net.refractions.udig.project.ui/debug/render/trace")) {
            final StringBuffer log = new StringBuffer("Current Renderers:");
            this.getRenderExecutor().visit(new ExecutorVisitor(){

                public void visit(RenderExecutor executor) {
                    log.append("\n\t" + executor.getClass().getSimpleName() + ":" + executor.getRenderer().getClass().getSimpleName() + "-" + executor.getContext().getLayer().getName());
                }

                public void visit(RenderExecutorComposite executor) {
                    log.append("\n\t" + executor.getRenderer().getClass().getSimpleName());
                    for (RenderExecutor child : executor.getRenderer().getRenderExecutors()) {
                        child.visit((ExecutorVisitor)this);
                    }
                }

                public void visit(RenderExecutorMultiLayer executor) {
                    log.append("\n\t" + executor.getRenderer().getClass().getSimpleName());
                }
            });
            System.out.println(log);
        }
    }

    public RenderExecutor getRenderExecutor() {
        this.checkState();
        if (this.renderExecutor == null) {
            this.initRenderExecutor();
        }
        return this.renderExecutor;
    }
}

