/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.internal.ui.IDropTargetProvider;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IProject;
import net.refractions.udig.project.IProjectElement;
import net.refractions.udig.project.element.ProjectElementAdapter;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectElement;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.ProjectRegistry;
import net.refractions.udig.project.internal.provider.LoadingPlaceHolder;
import net.refractions.udig.project.ui.AdapterFactoryLabelProviderDecorator;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.LayerApplicabilityMenuCreator;
import net.refractions.udig.project.ui.internal.MapPart;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.UDIGAdapterFactoryContentProvider;
import net.refractions.udig.project.ui.internal.UDIGEditorInputDescriptor;
import net.refractions.udig.project.ui.internal.ViewerLayerSorter;
import net.refractions.udig.project.ui.internal.actions.Delete;
import net.refractions.udig.project.ui.internal.actions.OpenProject;
import net.refractions.udig.project.ui.tool.IToolManager;
import net.refractions.udig.ui.UDIGDragDropUtilities;
import net.refractions.udig.ui.ZoomingDialog;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class ProjectExplorer
extends ViewPart
implements IMenuListener,
ISetSelectionTarget,
IDropTargetProvider {
    public static final String ID = "net.refractions.udig.project.ui.projectExplorer";
    public static final String PROJECT_EXPLORER_LINKED = "PROJECT_EXPLORER_LINKED";
    ProjectRegistry projectRegistry;
    private Composite container;
    TreeViewer treeViewer;
    private PropertySheetPage propertySheetPage;
    private static ProjectExplorer explorer = new ProjectExplorer();
    private IAction propertiesAction;
    private Action openAction;
    private Action openProjectAction;
    private UDIGAdapterFactoryContentProvider contentProvider;
    private Action linkAction;
    IPartListener2 editorListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference partRef) {
            if (ProjectExplorer.this.isLinkedWithEditor() && partRef.getPart(false) instanceof MapPart) {
                MapPart editor = (MapPart)partRef.getPart(false);
                ProjectExplorer.this.setSelection(Collections.singleton(editor.getMap()), true);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }
    };
    private IAction delAction = new Action(){
        Delete delete = new Delete(true);
        {
            this.setActionDefinitionId("org.eclipse.ui.edit.delete");
            ActionFactory.IWorkbenchAction actionTemplate = ActionFactory.DELETE.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            this.setText(actionTemplate.getText());
            this.setToolTipText(actionTemplate.getToolTipText());
            this.setImageDescriptor(actionTemplate.getImageDescriptor());
            this.setDescription(actionTemplate.getDescription());
            this.setDisabledImageDescriptor(actionTemplate.getDisabledImageDescriptor());
        }

        public void run() {
            this.delete.selectionChanged((IAction)this, ProjectExplorer.this.treeViewer.getSelection());
            this.delete.run((IAction)this);
        }
    };
    private LayerApplicabilityMenuCreator applicabilityCreator;
    Map editorInputsMap = new HashMap();
    Map defaultEditorMap = new HashMap();
    AtomicReference<SetSelectionListener> inputChangedListener = new AtomicReference();

    public ProjectExplorer() {
        CatalogPlugin.getDefault();
        explorer = this;
        this.projectRegistry = ProjectPlugin.getPlugin().getProjectRegistry();
    }

    public <T> List<T> getSelected(Class<T> clazz) {
        StructuredSelection selection = (StructuredSelection)this.treeViewer.getSelection();
        ArrayList selected = new ArrayList();
        for (Object obj : selection) {
            if (clazz == null || !clazz.isAssignableFrom(obj.getClass())) continue;
            selected.add(obj);
        }
        return selected;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
    }

    protected void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
    }

    public Composite getContainer() {
        return this.container;
    }

    public void createPartControl(Composite parent) {
        this.container = parent;
        Tree tree = new Tree(this.getContainer(), 268436226);
        this.treeViewer = new TreeViewer(tree);
        UDIGDragDropUtilities.addDragDropSupport((StructuredViewer)this.treeViewer, (IDropTargetProvider)this, (boolean)true, (boolean)true);
        this.treeViewer.setAutoExpandLevel(1);
        this.contentProvider = new UDIGAdapterFactoryContentProvider(this.getAdapterFactory());
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProviderDecorator(this.getAdapterFactory(), (StructuredViewer)this.treeViewer));
        this.treeViewer.setInput((Object)this.projectRegistry);
        ViewerFilter[] filters = new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof ProjectElement && parentElement instanceof Project) {
                    ProjectElement mapElement = (ProjectElement)element;
                    Project projectElement = (Project)parentElement;
                    List elements = projectElement.getElements(ProjectElement.class);
                    for (ProjectElement pElem : elements) {
                        List projectElements = pElem.getElements(ProjectElement.class);
                        for (ProjectElement projElem : projectElements) {
                            if (!projElem.equals(mapElement)) continue;
                            return false;
                        }
                    }
                }
                return true;
            }
        }};
        this.treeViewer.setFilters(filters);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
        this.setTreeSorter();
        this.createContextMenuFor((StructuredViewer)this.treeViewer);
        this.addMenuActions();
        this.addToobarActions();
        this.addSelectionListener();
        this.addDoubleCickListener();
        this.setGlobalActions();
    }

    private void setTreeSorter() {
        this.treeViewer.setSorter(new ViewerSorter(){
            ViewerLayerSorter layerSorter = new ViewerLayerSorter();

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof Layer && e2 instanceof Layer) {
                    return this.layerSorter.compare(viewer, e1, e2);
                }
                if (e1 instanceof LoadingPlaceHolder) {
                    return 1;
                }
                if (e2 instanceof LoadingPlaceHolder) {
                    return -1;
                }
                return super.compare(viewer, e1, e2);
            }
        });
    }

    private void addDoubleCickListener() {
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (PlatformUI.getWorkbench().isClosing()) {
                    return;
                }
                final Object obj = ((IStructuredSelection)ProjectExplorer.this.treeViewer.getSelection()).getFirstElement();
                if (!(obj instanceof IProjectElement)) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (obj != null) {
                                (this).ProjectExplorer.this.treeViewer.setExpandedState(obj, !(this).ProjectExplorer.this.treeViewer.getExpandedState(obj));
                            }
                        }
                    });
                    return;
                }
                ProjectExplorer.this.open((IProjectElement)obj, false);
            }
        });
    }

    private void addSelectionListener() {
        final IPreferenceStore preferenceStore = ProjectUIPlugin.getDefault().getPreferenceStore();
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection().isEmpty()) {
                    return;
                }
                Object obj = ((IStructuredSelection)ProjectExplorer.this.treeViewer.getSelection()).getFirstElement();
                if (obj instanceof IProject) {
                    ProjectExplorer.this.projectRegistry.setCurrentProject((Project)obj);
                }
                if (obj instanceof ILayer) {
                    ProjectExplorer.this.getViewSite().getActionBars().getStatusLineManager().setMessage(((ILayer)obj).getStatusMessage());
                }
                if (preferenceStore.getBoolean(ProjectExplorer.PROJECT_EXPLORER_LINKED) && obj instanceof IProjectElement) {
                    IWorkbenchPage page = ProjectExplorer.this.getSite().getPage();
                    IEditorPart part = page.findEditor((IEditorInput)ApplicationGIS.getInput((IProjectElement)obj));
                    page.bringToTop((IWorkbenchPart)part);
                }
            }
        });
    }

    private void setGlobalActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolManager toolManager = ApplicationGIS.getToolManager();
        toolManager.contributeGlobalActions((IWorkbenchPart)this, actionBars);
        toolManager.registerActionsWithPart((IWorkbenchPart)this);
        IKeyBindingService keyBindings = this.getSite().getKeyBindingService();
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.delAction);
        keyBindings.registerAction(this.delAction);
    }

    public AdapterFactory getAdapterFactory() {
        return ProjectUIPlugin.getDefault().getAdapterFactory();
    }

    private void addToobarActions() {
        this.getActionBars().getToolBarManager().add(this.createLinkAction());
        this.getActionBars().getToolBarManager().add((IContributionItem)new GroupMarker("additions"));
    }

    private IAction createLinkAction() {
        final IPreferenceStore preferenceStore = ProjectUIPlugin.getDefault().getPreferenceStore();
        this.linkAction = new Action(Messages.ProjectExplorer_link_name, 32){

            public void runWithEvent(Event event) {
                boolean linked = this.isChecked();
                preferenceStore.setValue(ProjectExplorer.PROJECT_EXPLORER_LINKED, linked);
                if (linked) {
                    ProjectExplorer.this.addEditorListener();
                } else {
                    ProjectExplorer.this.removeEditorListener();
                }
            }
        };
        boolean linked = preferenceStore.getBoolean(PROJECT_EXPLORER_LINKED);
        this.linkAction.setChecked(linked);
        this.linkAction.setImageDescriptor(ProjectUIPlugin.getDefault().getImageDescriptor("elcl16/link_co.gif"));
        this.linkAction.setDisabledImageDescriptor(ProjectUIPlugin.getDefault().getImageDescriptor("dlcl16/link_co.gif"));
        this.linkAction.setToolTipText(Messages.ProjectExplorer_link_tooltip);
        if (linked) {
            this.addEditorListener();
        }
        return this.linkAction;
    }

    protected void removeEditorListener() {
        this.getSite().getPage().removePartListener(this.editorListener);
    }

    protected void addEditorListener() {
        this.getSite().getPage().addPartListener(this.editorListener);
    }

    public boolean isLinkedWithEditor() {
        return this.linkAction.isChecked();
    }

    private void addMenuActions() {
        this.getActionBars().getMenuManager().add(this.getOpenProjectAction());
        this.getActionBars().getMenuManager().add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(key);
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new PropertySheetPage(){

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider(this.getAdapterFactory()));
        }
        return this.propertySheetPage;
    }

    public IActionBars getActionBars() {
        return this.getViewSite().getActionBars();
    }

    public void menuAboutToShow(IMenuManager manager) {
        boolean addOpenAction = false;
        for (Object obj : (IStructuredSelection)this.treeViewer.getSelection()) {
            if (!(obj instanceof IProjectElement)) continue;
            addOpenAction = true;
            break;
        }
        if (addOpenAction) {
            manager.add((IAction)this.getOpenAction());
        }
        manager.add(this.getOpenProjectAction());
        manager.add(this.delAction);
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)ApplicationGIS.getToolManager().createOperationsContextMenu(this.treeViewer.getSelection()));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)ActionFactory.EXPORT.create(this.getSite().getWorkbenchWindow()));
        if (!this.treeViewer.getSelection().isEmpty() && ((IStructuredSelection)this.treeViewer.getSelection()).getFirstElement() instanceof net.refractions.udig.project.internal.Map) {
            manager.add((IContributionItem)new Separator());
            manager.add(this.getPropertiesAction());
        }
    }

    private LayerApplicabilityMenuCreator getApplicabilityMenu() {
        if (this.applicabilityCreator == null) {
            this.applicabilityCreator = new LayerApplicabilityMenuCreator();
        }
        StructuredSelection selection = (StructuredSelection)this.treeViewer.getSelection();
        for (Object element : selection) {
            if (element instanceof Layer) continue;
            return null;
        }
        return this.applicabilityCreator;
    }

    private IAction getOpenProjectAction() {
        if (this.openProjectAction == null) {
            this.openProjectAction = new Action(){
                OpenProject delegate = new OpenProject();

                public void run() {
                    if (PlatformUI.getWorkbench().isClosing()) {
                        return;
                    }
                    this.delegate.run((IAction)this);
                }
            };
            this.openProjectAction.setText(Messages.ProjectExplorer_openProject_text);
            this.openProjectAction.setToolTipText(Messages.ProjectExplorer_openProject_tooltip);
        }
        return this.openProjectAction;
    }

    private IAction getPropertiesAction() {
        if (this.propertiesAction == null) {
            final Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            final PropertyDialogAction tmp = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)shell), (ISelectionProvider)this.treeViewer);
            this.propertiesAction = new Action(){

                public void runWithEvent(Event event) {
                    ZoomingDialog dialog = new ZoomingDialog(shell, (Dialog)tmp.createDialog(), ZoomingDialog.calculateBounds((TreeItem)ProjectExplorer.this.treeViewer.getTree().getSelection()[0], (int)-1));
                    dialog.open();
                }
            };
            this.propertiesAction.setText(tmp.getText());
            this.propertiesAction.setActionDefinitionId(tmp.getActionDefinitionId());
            this.propertiesAction.setDescription(tmp.getDescription());
            this.propertiesAction.setHoverImageDescriptor(tmp.getHoverImageDescriptor());
            this.propertiesAction.setImageDescriptor(tmp.getImageDescriptor());
            this.propertiesAction.setToolTipText(tmp.getToolTipText());
        }
        this.getActionBars().setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), this.propertiesAction);
        return this.propertiesAction;
    }

    private Action getOpenAction() {
        if (this.openAction == null) {
            this.openAction = new Action(){

                public void run() {
                    Iterator iter = ((IStructuredSelection)ProjectExplorer.this.treeViewer.getSelection()).iterator();
                    while (iter.hasNext()) {
                        ProjectExplorer.this.open((IProjectElement)iter.next(), false);
                    }
                }
            };
        }
        this.openAction.setText(Messages.ProjectExplorer_open_text);
        return this.openAction;
    }

    List getOpenWithActions(IProjectElement element) {
        Class<?> type = element instanceof ProjectElementAdapter ? ((ProjectElementAdapter)element).getBackingObject().getClass() : element.getClass();
        ArrayList<OpenWithActions> actions = (ArrayList<OpenWithActions>)this.editorInputsMap.get(type);
        if (actions == null) {
            actions = new ArrayList<OpenWithActions>();
            List<UDIGEditorInputDescriptor> inputs = ApplicationGIS.getEditorInputs(element);
            for (UDIGEditorInputDescriptor desc : inputs) {
                OpenWithActions openWithAction = new OpenWithActions(desc);
                openWithAction.setText(desc.getName());
                actions.add(openWithAction);
            }
            if (actions != null) {
                this.editorInputsMap.put(type, actions);
            }
        }
        return actions;
    }

    public void open(IProjectElement obj) {
        this.open(obj, false);
    }

    public void open(IProjectElement obj, boolean wait) {
        ApplicationGIS.openProjectElement(obj, wait);
    }

    public UDIGEditorInputDescriptor getEditorInput(IProjectElement obj) {
        List inputs = this.getOpenWithActions(obj);
        Class<?> type = obj instanceof ProjectElementAdapter ? ((ProjectElementAdapter)obj).getBackingObject().getClass() : obj.getClass();
        String defaultEditor = (String)this.defaultEditorMap.get(type);
        OpenWithActions action = null;
        if (defaultEditor == null) {
            action = (OpenWithActions)((Object)inputs.get(0));
        } else {
            for (OpenWithActions current : inputs) {
                if (!current.input.getEditorID().equals(defaultEditor)) continue;
                action = current;
                break;
            }
        }
        OpenWithActions finalAction = action;
        if (finalAction != null) {
            UDIGEditorInputDescriptor input = finalAction.input;
            return input;
        }
        throw new Error("Unable to create a input descriptor for this object.  A plugin may not be installed correctly");
    }

    public void selectReveal(ISelection selection) {
        this.treeViewer.setSelection(selection);
    }

    public static ProjectExplorer getProjectExplorer() {
        return explorer;
    }

    public void dispose() {
        if (PlatformUI.getWorkbench().isClosing()) {
            ProjectPlugin.getPlugin().turnOffEvents();
        }
        this.treeViewer.getLabelProvider().dispose();
        this.contentProvider.dispose();
        super.dispose();
    }

    public Object getTarget(DropTargetEvent event) {
        return this;
    }

    public void collapseToLevel(IProject project, int i) {
        this.treeViewer.collapseToLevel((Object)project, i);
    }

    public void setSelection(final IProject p, final boolean reveal) {
        Display d = Display.getCurrent();
        if (d == null) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProjectExplorer.this.treeViewer.setSelection((ISelection)new StructuredSelection(new Object[]{p}), reveal);
                }
            });
        } else {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(new Object[]{p}), reveal);
        }
    }

    public void setSelection(final Collection<? extends IProjectElement> element, final boolean reveal) {
        if (this.treeViewer == null) {
            return;
        }
        Display d = Display.getCurrent();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ProjectExplorer.this.inDisplaySelect(element, reveal);
            }
        };
        if (d == null) {
            Display.getDefault().asyncExec(runnable);
        } else {
            d.asyncExec(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void inDisplaySelect(Collection<? extends IProjectElement> element, boolean reveal) {
        if (this.treeViewer == null) {
            return;
        }
        List<Object> visibleElements = this.getLoadedElements();
        if (visibleElements.containsAll(element)) {
            this.treeViewer.setSelection((ISelection)new StructuredSelection(element.toArray()), reveal);
            return;
        }
        UDIGAdapterFactoryContentProvider uDIGAdapterFactoryContentProvider = this.contentProvider;
        synchronized (uDIGAdapterFactoryContentProvider) {
            SetSelectionListener old = this.inputChangedListener.getAndSet(new SetSelectionListener(element, reveal));
            this.contentProvider.removeListener(old);
            this.contentProvider.addListener(this.inputChangedListener.get());
        }
        for (IProjectElement iProjectElement : element) {
            IProject project = iProjectElement.getProject();
            this.treeViewer.setExpandedState((Object)project, true);
        }
    }

    private List<Object> getLoadedElements() {
        if (this.treeViewer == null) {
            return Collections.emptyList();
        }
        Tree tree = (Tree)this.treeViewer.getControl();
        TreeItem[] items = tree.getItems();
        ArrayList<Object> data = new ArrayList<Object>();
        this.collectData(items, data);
        return data;
    }

    private void collectData(TreeItem[] items, List<Object> data) {
        if (items.length == 0) {
            return;
        }
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object data2 = item.getData();
            if (data != null) {
                data.add(data2);
                this.collectData(item.getItems(), data);
            }
            ++n2;
        }
    }

    public void setSelection(IProjectElement element, Object elementChild) {
        throw new UnsupportedOperationException("This method has not been implemented yet");
    }

    class OpenWithActions
    extends Action {
        UDIGEditorInputDescriptor input;

        public OpenWithActions(UDIGEditorInputDescriptor input) {
            this.input = input;
        }

        public void run() {
            Iterator iter = ((IStructuredSelection)ProjectExplorer.this.treeViewer.getSelection()).iterator();
            while (iter.hasNext()) {
                ProjectExplorer.this.defaultEditorMap.put(this.input.getType(), this);
                ProjectExplorer.this.open((IProjectElement)iter.next(), false);
            }
        }
    }

    private class SetSelectionListener
    implements UDIGAdapterFactoryContentProvider.InputChangedListener {
        private Collection<? extends IProjectElement> elements;
        private boolean reveal;

        public SetSelectionListener(Collection<? extends IProjectElement> element, boolean reveal) {
            this.reveal = reveal;
            this.elements = element;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isValid() {
            UDIGAdapterFactoryContentProvider uDIGAdapterFactoryContentProvider = ProjectExplorer.this.contentProvider;
            synchronized (uDIGAdapterFactoryContentProvider) {
                block4: {
                    if (ProjectExplorer.this.inputChangedListener.get() == this) break block4;
                    ProjectExplorer.this.contentProvider.removeListener(this);
                    return false;
                }
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void trySetSelection() {
            List expandedElements = ProjectExplorer.this.getLoadedElements();
            if (expandedElements.containsAll(this.elements)) {
                ProjectExplorer.this.treeViewer.setSelection((ISelection)new StructuredSelection(this.elements.toArray()), this.reveal);
                UDIGAdapterFactoryContentProvider uDIGAdapterFactoryContentProvider = ProjectExplorer.this.contentProvider;
                synchronized (uDIGAdapterFactoryContentProvider) {
                    ProjectExplorer.this.contentProvider.removeListener(this);
                    ProjectExplorer.this.inputChangedListener.set(null);
                }
            }
        }

        @Override
        public void changed() {
            if (this.isValid()) {
                if (Display.getCurrent() == null) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            SetSelectionListener.this.trySetSelection();
                        }
                    });
                } else {
                    this.trySetSelection();
                }
            }
        }
    }
}

