/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.ui.internal.AWTColor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class PaletteRadioPanel {
    List<Color> colours = new ArrayList<Color>();
    List<Image> images = new ArrayList<Image>();
    Point fExtent;
    Composite composite;

    public PaletteRadioPanel(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.fExtent = this.computeImageSize((Control)this.composite);
    }

    public Control getRadioButtons(AWTColor[] coloursToUse) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = coloursToUse.length * 2;
        this.composite.setLayout((Layout)gridLayout);
        int i = 0;
        while (i < coloursToUse.length) {
            AWTColor awtColour = coloursToUse[i];
            Color swtColour = new Color((Device)this.composite.getDisplay(), new RGB(awtColour.getColour().getRed(), awtColour.getColour().getGreen(), awtColour.getColour().getBlue()));
            this.colours.add(swtColour);
            Button b = new Button(this.composite, 0x800000);
            Image image = new Image((Device)this.composite.getDisplay(), this.fExtent.x, this.fExtent.y);
            this.images.add(image);
            GC gc = new GC((Drawable)image);
            gc.setBackground(swtColour);
            gc.fillRectangle(0, 0, this.fExtent.x, this.fExtent.y);
            gc.dispose();
            b.setImage(image);
            GridData data = new GridData();
            b.setLayoutData((Object)data);
            Button radio = new Button(this.composite, 16);
            data = new GridData();
            radio.setLayoutData((Object)data);
            ++i;
        }
        return this.composite;
    }

    public void dispose() {
        int i = 0;
        while (i < this.colours.size()) {
            this.colours.remove(i).dispose();
            this.images.remove(i).dispose();
            ++i;
        }
    }

    protected Point computeImageSize(Control window) {
        GC gc = new GC((Drawable)window);
        Font f = JFaceResources.getFontRegistry().get("org.eclipse.jface.defaultfont");
        gc.setFont(f);
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        Point p = new Point(height * 3 - 6, height);
        return p;
    }
}

