/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.PaletteCombo;
import net.refractions.udig.project.ui.internal.dialogs.ColorEditor;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.palette.ColourScheme;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.geotools.brewer.color.BrewerPalette;

public class PaletteDefaultChooserPanel {
    Composite composite;
    ScrolledComposite scrolledComposite;
    BrewerPalette mapPalette = null;
    ColourScheme mapScheme = null;
    Combo paletteSelectionCombo = null;
    Combo quantityCombo = null;
    ArrayList<PaletteCombo> allLayerControls = new ArrayList();
    Map map = null;
    ColorEditor colorEditor;
    int numberOfLayers = 0;

    public Control createPaletteDefaultChooserPanel(Composite parent, Map thisMap) {
        this.map = thisMap;
        this.numberOfLayers = this.map.getLayersInternal().size();
        this.mapPalette = this.map.getColorPalette();
        this.mapScheme = new ColourScheme(this.map.getColourScheme().getColourPalette(), this.map.getColourScheme().getSizePalette());
        if (this.mapScheme.getSizePalette() < this.numberOfLayers) {
            this.mapScheme.setSizePalette(this.numberOfLayers);
        }
        this.scrolledComposite = new ScrolledComposite(parent, 768);
        this.composite = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.setContent((Control)this.composite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.composite.setLayout((Layout)gridLayout);
        Label titleLabel = new Label(this.composite, 0);
        titleLabel.setText(Messages.PaletteDefaultChooserPanel_title);
        GridData data = new GridData();
        data.horizontalSpan = 4;
        titleLabel.setLayoutData((Object)data);
        Label backgroundColor = new Label(this.composite, 0);
        backgroundColor.setText(Messages.PaletteDefaultChooserPanel_MapBackgroundColor);
        data = new GridData();
        data.horizontalSpan = 1;
        backgroundColor.setLayoutData((Object)data);
        this.colorEditor = new ColorEditor(this.composite);
        Color bgColor = (Color)thisMap.getBlackboard().get("mapBackgroundColor");
        if (backgroundColor != null) {
            this.colorEditor.setColorValue(new RGB(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue()));
        }
        Composite colorc = new Composite(this.composite, 0);
        data = new GridData();
        data.horizontalSpan = 2;
        colorc.setLayoutData((Object)data);
        Label paletteLabel = new Label(this.composite, 0);
        paletteLabel.setText(Messages.PaletteDefaultChooserPanel_palette);
        data = new GridData();
        data.horizontalSpan = 1;
        paletteLabel.setLayoutData((Object)data);
        this.paletteSelectionCombo = new Combo(this.composite, 12);
        String[] names = PlatformGIS.getColorBrewer().getPaletteNames();
        this.paletteSelectionCombo.setItems(names);
        int index = 0;
        int i = 0;
        while (i < names.length) {
            if (names[i].equalsIgnoreCase(this.mapPalette.getName())) {
                index = i;
                break;
            }
            ++i;
        }
        this.paletteSelectionCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = PaletteDefaultChooserPanel.this.paletteSelectionCombo.getSelectionIndex();
                String name = PaletteDefaultChooserPanel.this.paletteSelectionCombo.getItem(index);
                BrewerPalette palette = PlatformGIS.getColorBrewer().getPalette(name);
                PaletteDefaultChooserPanel.this.mapScheme = new ColourScheme(palette, Integer.parseInt(PaletteDefaultChooserPanel.this.quantityCombo.getItem(PaletteDefaultChooserPanel.this.quantityCombo.getSelectionIndex())));
                PaletteDefaultChooserPanel.this.updateLayerDisplay();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.paletteSelectionCombo.select(index);
        data = new GridData();
        data.horizontalSpan = 3;
        data.widthHint = 50;
        this.paletteSelectionCombo.setLayoutData((Object)data);
        Label quantityLabel = new Label(this.composite, 0);
        quantityLabel.setText(Messages.PaletteDefaultChooserPanel_colours);
        data = new GridData();
        data.horizontalSpan = 1;
        quantityLabel.setLayoutData((Object)data);
        this.quantityCombo = new Combo(this.composite, 12);
        int minColours = this.mapScheme.getMinColours();
        int maxColours = this.mapPalette.getMaxColors();
        int i2 = minColours;
        while (i2 <= maxColours) {
            this.quantityCombo.add(Integer.toString(i2));
            ++i2;
        }
        this.quantityCombo.select(this.quantityCombo.indexOf(Integer.toString(this.mapScheme.getSizePalette())));
        this.quantityCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PaletteDefaultChooserPanel.this.mapScheme.setSizePalette(Integer.parseInt(PaletteDefaultChooserPanel.this.quantityCombo.getText()));
                PaletteDefaultChooserPanel.this.updateLayerDisplay();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        data = new GridData();
        data.horizontalSpan = 3;
        data.widthHint = 50;
        this.quantityCombo.setLayoutData((Object)data);
        Label checkBoxLabel = new Label(this.composite, 0);
        checkBoxLabel.setText(Messages.PaletteDefaultChooserPanel_check);
        data = new GridData();
        data.horizontalSpan = 4;
        checkBoxLabel.setLayoutData((Object)data);
        this.createLayerDisplay();
        Point pt = this.composite.computeSize(-1, -1);
        this.composite.setSize(pt);
        return this.scrolledComposite;
    }

    void createLayerDisplay() {
        if (this.allLayerControls != null && this.allLayerControls.size() > 0) {
            Iterator<PaletteCombo> iter = this.allLayerControls.iterator();
            while (iter.hasNext()) {
                iter.next().dispose();
            }
            this.allLayerControls = new ArrayList();
        }
        List layers = this.map.getMapLayers();
        for (Layer layer : layers) {
            PaletteCombo layerColourCombo = new PaletteCombo(this.composite);
            Control layerCombo = layerColourCombo.getPaletteCombo(layer);
            GridData data = new GridData();
            data.horizontalSpan = 3;
            layerCombo.setLayoutData((Object)data);
            this.allLayerControls.add(layerColourCombo);
        }
        Point pt = this.composite.computeSize(-1, -1);
        this.composite.setSize(pt);
        this.composite.layout(true);
        this.scrolledComposite.layout(true);
    }

    void updateLayerDisplay() {
        for (PaletteCombo thisLayer : this.allLayerControls) {
            thisLayer.updateContents(this.mapScheme);
        }
    }

    public void dispose() {
        Control[] controls = this.composite.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].dispose();
            ++i;
        }
        this.composite.dispose();
        this.scrolledComposite.dispose();
    }

    public ArrayList<PaletteCombo> getAllLayerControls() {
        return this.allLayerControls;
    }

    public Color getMapBackgroundColor() {
        return new Color(this.colorEditor.getColorValue().red, this.colorEditor.getColorValue().green, this.colorEditor.getColorValue().blue);
    }

    public void updateMapBackgroundColor(Color newColor) {
        this.colorEditor.setColorValue(new RGB(newColor.getRed(), newColor.getGreen(), newColor.getBlue()));
    }

    public void updatePalette(String newPalette) {
        int i = 0;
        while (i < this.paletteSelectionCombo.getItemCount()) {
            if (this.paletteSelectionCombo.getItem(i).equals(newPalette)) {
                this.paletteSelectionCombo.select(i);
                break;
            }
            ++i;
        }
        String name = this.paletteSelectionCombo.getItem(this.paletteSelectionCombo.getSelectionIndex());
        BrewerPalette palette = PlatformGIS.getColorBrewer().getPalette(name);
        this.mapScheme = new ColourScheme(palette, Integer.parseInt(this.quantityCombo.getItem(this.quantityCombo.getSelectionIndex())));
        this.updateLayerDisplay();
    }

    public ColourScheme getCurrentColourScheme() {
        return this.mapScheme;
    }
}

