/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.ui.export.CatalogExport;
import net.refractions.udig.catalog.ui.export.CatalogExportWizard;
import net.refractions.udig.catalog.ui.export.Data;
import net.refractions.udig.catalog.ui.export.ExportResourceSelectionState;
import net.refractions.udig.catalog.ui.workflow.State;
import net.refractions.udig.catalog.ui.workflow.Workflow;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizard;
import net.refractions.udig.catalog.ui.workflow.WorkflowWizardPageProvider;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerFactory;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.ui.internal.MapEditorPart;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;

public final class MapSaveStrategy
extends CatalogExport {
    private final ExportResourceSelectionState state;
    private MapEditorPart editor;

    public MapSaveStrategy(ExportResourceSelectionState state, MapEditorPart editor) {
        super(false);
        this.state = state;
        this.editor = editor;
        this.initWorkflow();
    }

    protected Workflow createWorkflow() {
        Workflow workflow = new Workflow(new State[]{this.state});
        return workflow;
    }

    protected WorkflowWizard createWorkflowWizard(Workflow workflow, Map<Class<? extends State>, WorkflowWizardPageProvider> map) {
        CatalogExportWizard catalogExportWizard = new CatalogExportWizard(workflow, map){

            protected boolean performFinish(IProgressMonitor monitor) {
                boolean result = super.performFinish(monitor);
                this.replaceExportedLayers(MapSaveStrategy.this.state);
                try {
                    MapSaveStrategy.this.editor.getMap().getEditManagerInternal().commitTransaction();
                    MapSaveStrategy.this.editor.setDirty(false);
                }
                catch (IOException e) {
                    ProjectUIPlugin.log("failed committing transaction", e);
                    MessageDialog.openError(null, (String)Messages.MapSaveStrategy_error_title, (String)Messages.MapSaveStrategy_error_messages);
                }
                return result;
            }

            private void replaceExportedLayers(ExportResourceSelectionState layerState) {
                List exportedLayers = layerState.getExportData();
                for (Data data : exportedLayers) {
                    Collection exported = data.getExportedResources();
                    this.replaceLayer(data.getResource(), exported);
                }
            }

            private void replaceLayer(IGeoResource resource, Collection<IGeoResource> exported) {
                Layer found;
                List layers = MapSaveStrategy.this.editor.getMap().getLayersInternal();
                do {
                    found = null;
                    for (Layer layer : layers) {
                        if (!URLUtils.urlEquals((URL)layer.getID(), (URL)resource.getIdentifier(), (boolean)false)) continue;
                        found = layer;
                        break;
                    }
                    if (found == null) continue;
                    layers.addAll(layers.indexOf(found), this.toLayers(found, exported));
                    layers.remove(found);
                } while (found != null);
            }

            private Collection<Layer> toLayers(Layer found, Collection<IGeoResource> exported) {
                LayerFactory layerFactory = MapSaveStrategy.this.editor.getMap().getLayerFactory();
                ArrayList<Layer> newLayers = new ArrayList<Layer>();
                for (IGeoResource exportedResource : exported) {
                    try {
                        Layer createLayer = layerFactory.createLayer(exportedResource);
                        StyleBlackboard clone = (StyleBlackboard)found.getStyleBlackboard().clone();
                        createLayer.setStyleBlackboard(clone);
                        newLayers.add(createLayer);
                    }
                    catch (IOException e) {
                        throw (RuntimeException)new RuntimeException().initCause(e);
                    }
                }
                return newLayers;
            }
        };
        catalogExportWizard.setSelectExportedInCatalog(false);
        return catalogExportWizard;
    }
}

