/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceFactory;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.catalog.internal.ui.ResourceSelectionPage;
import net.refractions.udig.project.IProjectElement;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerFactory;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectFactory;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.ui.UDIGEditorInput;
import net.refractions.udig.project.ui.internal.MapPart;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectExplorer;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.ui.ExceptionDisplayer;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class MapFactory {
    public static final int MAX_RESOURCES_IN_SERVICE = 1;
    private static final MapFactory INSTANCE = new MapFactory();

    private MapFactory() {
    }

    public void processURLs(List<URL> resources) {
        this.processURLs(resources, null);
    }

    public void processURLs(List<URL> resources, Project target) {
        this.processURLs(resources, target, false);
    }

    public void processURLs(List<URL> resources, Project target, boolean newMap) {
        this.process(target, resources, newMap);
    }

    public void processResolves(List<IResolve> resources, Project target, boolean newMap) {
        this.process(target, resources, newMap);
    }

    public void process(final Project target, final List resources, final boolean newMap) {
        if (resources == null) {
            throw new InvalidParameterException("Parameter 'resources' cannot be null.");
        }
        Job job = new Job(Messages.ProjectUIPlugin_loadingServices_title){

            /*
             * WARNING - void declaration
             */
            protected IStatus run(IProgressMonitor monitor) {
                void var7_11;
                boolean mapExists;
                ArrayList<IOException> exceptions = new ArrayList<IOException>();
                ArrayList<IService> services = new ArrayList<IService>();
                ArrayList<IGeoResource> geoResources = new ArrayList<IGeoResource>();
                ArrayList<Layer> layers = new ArrayList<Layer>();
                for (Object object : resources) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    monitor.beginTask(Messages.MapFactory_taskSorting, resources.size());
                    try {
                        if (object instanceof URL) {
                            services.addAll(MapFactory.this.handleURL((URL)object, monitor));
                        } else if (object instanceof File) {
                            try {
                                services.addAll(MapFactory.this.handleURL(((File)object).toURL(), monitor));
                            }
                            catch (MalformedURLException malformedURLException) {}
                        } else if (object instanceof String) {
                            try {
                                services.addAll(MapFactory.this.handleURL(new URL((String)object), monitor));
                            }
                            catch (MalformedURLException malformedURLException) {}
                        } else if (object instanceof IService) {
                            services.add((IService)object);
                        } else if (object instanceof IGeoResource) {
                            geoResources.add((IGeoResource)object);
                        } else if (object instanceof Layer) {
                            layers.add((Layer)object);
                        } else if (object instanceof Map) {
                            services.addAll(CatalogPlugin.getDefault().getServiceFactory().createService((Map)object));
                        }
                    }
                    catch (IOException e) {
                        exceptions.add(e);
                        ProjectUIPlugin.log(null, e);
                    }
                    monitor.worked(1);
                }
                ArrayList<IResolve> unChosenServices = new ArrayList<IResolve>();
                for (IResolve iResolve : services) {
                    monitor.beginTask(Messages.ProjectUIPlugin_loadingServices_task, services.size());
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        List resources2 = MapFactory.this.handleResolve(iResolve, monitor);
                        if (resources2.size() > 1) {
                            unChosenServices.add(iResolve);
                        } else {
                            geoResources.addAll(resources2);
                        }
                    }
                    catch (IOException e) {
                        exceptions.add(e);
                        ProjectUIPlugin.log(null, e);
                    }
                    monitor.worked(1);
                }
                if (unChosenServices.size() > 0) {
                    geoResources.addAll(MapFactory.this.getResourcesFromUser(unChosenServices));
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                net.refractions.udig.project.internal.Map map = new CurrentMapFinder().getCurrentMap();
                boolean bl = mapExists = map != null;
                if (map == null || newMap) {
                    net.refractions.udig.project.internal.Map map2 = MapFactory.this.getMap(monitor, target, newMap);
                }
                if (var7_11.getBlackboard().get("mapBackgroundColor") == null) {
                    ScopedPreferenceStore store = ProjectPlugin.getPlugin().getPreferenceStore();
                    RGB background = PreferenceConverter.getColor((IPreferenceStore)store, (String)"backgroundColor");
                    var7_11.getBlackboard().put("mapBackgroundColor", (Object)new Color(background.red, background.green, background.blue));
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                LayerFactory factory = var7_11.getLayerFactory();
                if (factory == null) {
                    factory = ProjectFactory.eINSTANCE.createLayerFactory();
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                for (IGeoResource resource : geoResources) {
                    monitor.beginTask(Messages.MapFactory_retrieveTask, geoResources.size());
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        IService service = resource.service(monitor);
                        CatalogPlugin.getDefault().getLocalCatalog().add(service);
                        Layer layer = factory.createLayer(resource);
                        if (layer != null) {
                            layers.add(layer);
                        }
                    }
                    catch (IOException e) {
                        exceptions.add(e);
                        ProjectUIPlugin.log(null, e);
                    }
                    monitor.worked(1);
                }
                if (!layers.isEmpty()) {
                    var7_11.getLayersInternal().addAll(layers);
                }
                if (var7_11.getLayersInternal().size() > 0 || newMap) {
                    ProjectExplorer.getProjectExplorer().open((IProjectElement)var7_11);
                } else if (!mapExists) {
                    var7_11.getProjectInternal().getElementsInternal().remove(var7_11);
                }
                if (exceptions.size() != 0) {
                    String message = null;
                    message = exceptions.size() > 1 ? Messages.MapFactory_multiError : Messages.MapFactory_error;
                    ExceptionDisplayer.displayExceptions(exceptions, (String)message, (String)"net.refractions.udig.project.ui");
                }
                monitor.done();
                return new Status(0, "net.refractions.udig.project.ui", 0, Messages.ProjectUIPlugin_success, null);
            }
        };
        job.schedule();
    }

    private List<IGeoResource> getResourcesFromUser(List<IResolve> unChosenServices) {
        final ResourceSelectionPage page = new ResourceSelectionPage(Messages.ProjectUIPlugin_resourceSelectionPage_title);
        page.setResources(unChosenServices, null);
        final ArrayList<IGeoResource> chosenResources = new ArrayList<IGeoResource>();
        PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Wizard wizard = new Wizard(){

                    public void addPages() {
                        this.addPage((IWizardPage)page);
                    }

                    public boolean performFinish() {
                        List list = page.getCheckedElements();
                        for (Object object : list) {
                            if (!(object instanceof IGeoResource)) continue;
                            chosenResources.add((IGeoResource)object);
                        }
                        return true;
                    }
                };
                WizardDialog dialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                dialog.setBlockOnOpen(true);
                dialog.open();
            }
        });
        return chosenResources;
    }

    private List<IGeoResource> handleResolve(IResolve resolve, IProgressMonitor monitor) throws IOException {
        if (resolve instanceof IService) {
            IService service = (IService)resolve;
            this.resources(service.resources(monitor));
        }
        return Collections.emptyList();
    }

    private List<IService> handleURL(URL url, IProgressMonitor monitor) throws IOException {
        if (url.getFile().toLowerCase().endsWith(".udig")) {
            this.handleProjectURL(url, monitor);
            return Collections.emptyList();
        }
        List<IService> goodServices = this.acquireGoodServices(url, monitor);
        if (goodServices.isEmpty()) {
            throw new IOException("No service available for " + url);
        }
        return goodServices;
    }

    private void handleProjectURL(URL url, IProgressMonitor monitor) {
        monitor = this.validateMonitor(monitor);
        monitor.subTask(Messages.ProjectUIPlugin_loadingProject_task);
        File file = URLUtils.urlToFile((URL)url);
        ProjectPlugin.getPlugin().getProjectRegistry().getProject(file.getAbsolutePath());
    }

    public List<Layer> processResources(IProgressMonitor monitor, List<Object> resources) {
        return this.processResources(monitor, resources, null);
    }

    List<IService> acquireGoodServices(URL url, IProgressMonitor monitor) throws IOException {
        if (url == null) {
            return Collections.emptyList();
        }
        IServiceFactory factory = CatalogPlugin.getDefault().getServiceFactory();
        List result = factory.createService(url);
        if (result.isEmpty()) {
            throw new IOException("Could not acquire a working service for " + url);
        }
        ArrayList<IService> good = new ArrayList<IService>();
        IOException notGood = null;
        for (IService service : result) {
            try {
                if (service.resources(monitor) == null) continue;
                good.add(service);
            }
            catch (IOException bad) {
                notGood = bad;
            }
        }
        if (good.isEmpty()) {
            if (notGood != null) {
                throw notGood;
            }
            throw new IOException("Could not acquire a working service for " + url);
        }
        return good;
    }

    public List<Layer> processResources(IProgressMonitor monitor, List<Object> resources, Object target) {
        monitor = this.validateMonitor(monitor);
        ArrayList<Layer> layers = new ArrayList<Layer>();
        ArrayList<IService> services = new ArrayList<IService>();
        ArrayList<IGeoResource> georesources = new ArrayList<IGeoResource>();
        if (resources.isEmpty()) {
            return layers;
        }
        for (Object object : resources) {
            if (monitor.isCanceled()) {
                return null;
            }
            if (object instanceof Layer) {
                layers.add((Layer)object);
            }
            if (object instanceof IService) {
                services.add((IService)object);
                continue;
            }
            if (object instanceof IGeoResource) {
                georesources.add((IGeoResource)object);
                continue;
            }
            if (!(object instanceof Map)) continue;
            services.addAll(CatalogPlugin.getDefault().getServiceFactory().createService((Map)object));
        }
        return layers;
    }

    List<IGeoResource> resources(List<? extends IResolve> resolveList) throws IOException {
        ArrayList<IGeoResource> build = new ArrayList<IGeoResource>();
        for (IResolve iResolve : resolveList) {
            if (iResolve instanceof IGeoResource) {
                build.add((IGeoResource)iResolve);
                continue;
            }
            if (!(iResolve instanceof IService)) continue;
            build.addAll(this.resources(((IService)iResolve).resources(null)));
        }
        return build;
    }

    public net.refractions.udig.project.internal.Map getMap(IProgressMonitor monitor, Project project2, boolean createMap) {
        net.refractions.udig.project.internal.Map map = null;
        if (!createMap) {
            map = new CurrentMapFinder().getCurrentMap();
        }
        if (map != null) {
            return map;
        }
        Project project = project2;
        if (project == null) {
            project = ProjectPlugin.getPlugin().getProjectRegistry().getCurrentProject();
        }
        if (project == null) {
            project = ProjectPlugin.getPlugin().getProjectRegistry().getDefaultProject();
        }
        String mapName = this.getNewMapName(project);
        net.refractions.udig.project.internal.Map newmap = ProjectFactory.eINSTANCE.createMap(project, mapName, new ArrayList());
        return newmap;
    }

    private String getNewMapName(Project currentProject) {
        String name = Messages.ProjectUIPlugin_newMap_name;
        int count = currentProject.getElementsInternal().size() + 1;
        return String.valueOf(name) + count;
    }

    IProgressMonitor validateMonitor(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    public static MapFactory instance() {
        return INSTANCE;
    }

    private static class CurrentMapFinder
    implements Runnable {
        net.refractions.udig.project.internal.Map map = null;

        private CurrentMapFinder() {
        }

        net.refractions.udig.project.internal.Map getCurrentMap() {
            this.map = null;
            PlatformGIS.syncInDisplayThread((Runnable)this);
            return this.map;
        }

        @Override
        public void run() {
            if (this.isMapOpen()) {
                UDIGEditorInput input = (UDIGEditorInput)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
                this.map = (net.refractions.udig.project.internal.Map)input.getProjectElement();
            }
        }

        boolean isMapOpen() {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor() instanceof MapPart;
        }
    }
}

