/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.ITransientResolve;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.internal.ui.IDropTargetProvider;
import net.refractions.udig.internal.ui.UDIGControlDropListener;
import net.refractions.udig.internal.ui.UDIGDropHandler;
import net.refractions.udig.project.EditManagerEvent;
import net.refractions.udig.project.IEditManagerListener;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ILayerListener;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IMapCompositionListener;
import net.refractions.udig.project.IMapListener;
import net.refractions.udig.project.LayerEvent;
import net.refractions.udig.project.MapCompositionEvent;
import net.refractions.udig.project.MapEvent;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoRedoCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.interceptor.MapInterceptor;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.commands.ChangeCRSCommand;
import net.refractions.udig.project.internal.commands.selection.SelectLayerCommand;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.render.IViewportModelListener;
import net.refractions.udig.project.render.ViewportModelEvent;
import net.refractions.udig.project.render.displayAdapter.IMapDisplayListener;
import net.refractions.udig.project.ui.AnimationUpdater;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.IAnimation;
import net.refractions.udig.project.ui.UDIGEditorInput;
import net.refractions.udig.project.ui.controls.ScaleRatioLabel;
import net.refractions.udig.project.ui.internal.FeatureAnimation;
import net.refractions.udig.project.ui.internal.LayerSelectionListener;
import net.refractions.udig.project.ui.internal.MapEditorPart;
import net.refractions.udig.project.ui.internal.MapEditorSite;
import net.refractions.udig.project.ui.internal.MapToolPaletteFactory;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.ReplaceableSelectionProvider;
import net.refractions.udig.project.ui.internal.SaveDialog;
import net.refractions.udig.project.ui.internal.SaveMapPaletteRunnable;
import net.refractions.udig.project.ui.internal.commands.draw.DrawFeatureCommand;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import net.refractions.udig.project.ui.tool.IMapEditorSelectionProvider;
import net.refractions.udig.project.ui.tool.IToolManager;
import net.refractions.udig.project.ui.viewers.MapEditDomain;
import net.refractions.udig.project.ui.viewers.MapViewer;
import net.refractions.udig.ui.CRSChooserDialog;
import net.refractions.udig.ui.IBlockingSelection;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.PreShutdownTask;
import net.refractions.udig.ui.ProgressManager;
import net.refractions.udig.ui.ShutdownTaskList;
import net.refractions.udig.ui.UDIGDragDropUtilities;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.jface.action.StatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.SubActionBars2;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MapEditorWithPalette
extends GraphicalEditorWithFlyoutPalette
implements IDropTargetProvider,
IAdaptable,
MapEditorPart {
    private static final String LAYER_DIRTY_KEY = "DIRTY";
    public static final String ID = "net.refractions.udig.project.ui.mapEditor";
    private MapEditDomain editDomain;
    final StatusLineManager statusLineManager = new StatusLineManager();
    private MapEditorSite mapEditorSite;
    private boolean dirty = false;
    private PaletteRoot paletteRoot;
    private MapViewer viewer = null;
    private Composite composite;
    private UDIGDragDropUtilities.DropTargetDescriptor dropTarget;
    public boolean isTesting;
    private UDIGDragDropUtilities.DragSourceDescriptor dragSource;
    ILayerListener layerListener = new ILayerListener(){

        public void refresh(LayerEvent event) {
            if (event.getType() == LayerEvent.EventType.EDIT_EVENT) {
                MapEditorWithPalette.this.setDirty(true);
                event.getSource().getBlackboard().put(MapEditorWithPalette.LAYER_DIRTY_KEY, (Object)"true");
            }
        }
    };
    IMapCompositionListener mapCompositionListener = new IMapCompositionListener(){

        public void changed(MapCompositionEvent event) {
            switch (event.getType()) {
                case MANY_ADDED: {
                    Collection added = (Collection)event.getNewValue();
                    for (ILayer layer : added) {
                        layer.addListener(MapEditorWithPalette.this.layerListener);
                    }
                    break;
                }
                case MANY_REMOVED: {
                    Collection removed = (Collection)event.getOldValue();
                    for (ILayer layer : removed) {
                        this.removeListenerFromLayer(event, layer);
                    }
                    break;
                }
                case ADDED: {
                    ((ILayer)event.getNewValue()).addListener(MapEditorWithPalette.this.layerListener);
                    break;
                }
                case REMOVED: {
                    ILayer removedLayer = (ILayer)event.getOldValue();
                    this.removeListenerFromLayer(event, removedLayer);
                    break;
                }
            }
            boolean dirty = MapEditorWithPalette.this.isMapDirty();
            if (dirty != MapEditorWithPalette.this.isDirty()) {
                MapEditorWithPalette.this.setDirty(dirty);
            }
        }

        private void removeListenerFromLayer(MapCompositionEvent event, ILayer removedLayer) {
            removedLayer.removeListener(MapEditorWithPalette.this.layerListener);
            MapEditorWithPalette.this.setDirty(MapEditorWithPalette.this.isMapDirty());
        }
    };
    IMapListener mapListener = new IMapListener(){

        public void changed(final MapEvent event) {
            if (MapEditorWithPalette.this.composite == null) {
                return;
            }
            if (MapEditorWithPalette.this.getMap() == null || MapEditorWithPalette.this.composite.isDisposed()) {
                event.getSource().removeMapListener((IMapListener)this);
                return;
            }
            MapEditorWithPalette.this.composite.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    block0 : switch (event.getType()) {
                        case NAME: {
                            MapEditorWithPalette.this.setPartName((String)event.getNewValue());
                            break;
                        }
                        case EDIT_MANAGER: {
                            for (ILayer layer : event.getSource().getMapLayers()) {
                                if (!layer.hasResource(ITransientResolve.class)) continue;
                                MapEditorWithPalette.this.setDirty(true);
                                break block0;
                            }
                            break;
                        }
                    }
                }
            });
        }
    };
    IEditManagerListener editListener = new IEditManagerListener(){

        public void changed(EditManagerEvent event) {
            switch (event.getType()) {
                case -1: {
                    if (this.hasTemporaryLayers()) break;
                    MapEditorWithPalette.this.setDirty(false);
                    break;
                }
                case -4: {
                    if (this.hasTemporaryLayers()) break;
                    MapEditorWithPalette.this.setDirty(false);
                    break;
                }
            }
        }

        private boolean hasTemporaryLayers() {
            if (MapEditorWithPalette.this.getMap() == null) {
                return false;
            }
            List layers = MapEditorWithPalette.this.getMap().getLayersInternal();
            if (layers == null) {
                return false;
            }
            for (Layer layer : layers) {
                if (!layer.hasResource(ITransientResolve.class)) continue;
                return true;
            }
            return false;
        }
    };
    private LayerSelectionListener layerSelectionListener;
    private ReplaceableSelectionProvider replaceableSelectionProvider;
    private PreShutdownTask shutdownTask = new PreShutdownTask(){

        public int getProgressMonitorSteps() {
            return 3;
        }

        public boolean handlePreShutdownException(Throwable t, boolean forced) {
            ProjectUIPlugin.log("error prepping map editors for shutdown", t);
            return true;
        }

        public boolean preShutdown(IProgressMonitor monitor, IWorkbench workbench, boolean forced) throws Exception {
            monitor.beginTask("Saving Map Editor", 3);
            this.save((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (MapEditorWithPalette.this.dirty) {
                if (!forced) {
                    return false;
                }
                MapEditorWithPalette.this.setDirty(false);
            }
            MapEditorWithPalette.this.removeTemporaryLayers((IPreferenceStore)ProjectPlugin.getPlugin().getPreferenceStore());
            monitor.worked(1);
            Resource resource = MapEditorWithPalette.this.getMap().eResource();
            if (resource != null) {
                try {
                    IPreferenceStore p = ProjectUIPlugin.getDefault().getPreferenceStore();
                    int numEditors = p.getInt(MapEditorWithPalette.ID);
                    String id = "net.refractions.udig.project.ui.mapEditor:" + numEditors;
                    p.setValue(MapEditorWithPalette.ID, ++numEditors);
                    String value = resource.getURI().toString();
                    p.setDefault(id, "");
                    p.setValue(id, value);
                }
                catch (Exception e) {
                    ProjectUIPlugin.log("Failure saving which maps are open", e);
                }
            }
            monitor.worked(1);
            monitor.done();
            return true;
        }

        private void save(final IProgressMonitor monitor) {
            if (MapEditorWithPalette.this.dirty) {
                PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SaveDialog d = new SaveDialog(Display.getCurrent().getActiveShell(), MapEditorWithPalette.this.getMap());
                        int result = d.open();
                        if (result == 2) {
                            MapEditorWithPalette.this.doSave(monitor);
                        } else if (result != 1) {
                            MapEditorWithPalette.this.setDirty(false);
                        }
                    }
                });
            }
        }
    };
    private FlashFeatureListener selectFeatureListener = new FlashFeatureListener();
    private boolean flashFeatureRegistered = false;
    private Action propertiesAction;
    IPartListener2 partlistener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == MapEditorWithPalette.this) {
                MapEditorWithPalette.this.registerFeatureFlasher();
                IToolManager tools = ApplicationGIS.getToolManager();
                tools.setCurrentEditor(MapEditorWithPalette.this);
            }
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == MapEditorWithPalette.this) {
                MapEditorWithPalette.this.deregisterFeatureFlasher();
                MapEditorWithPalette.this.visible = false;
            }
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == MapEditorWithPalette.this) {
                MapEditorWithPalette.this.deregisterFeatureFlasher();
                MapEditorWithPalette.this.visible = false;
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == MapEditorWithPalette.this) {
                MapEditorWithPalette.this.registerFeatureFlasher();
                MapEditorWithPalette.this.visible = true;
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    };
    private boolean draggingEnabled;
    private volatile boolean visible = false;

    public MapEditorWithPalette() {
        ProjectUIPlugin.getDefault().getFeatureEditProcessor();
    }

    @Override
    public Composite getComposite() {
        return this.composite;
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = MapToolPaletteFactory.createPalette();
        }
        return this.paletteRoot;
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return MapToolPaletteFactory.createPalettePreferences();
    }

    public Object getAdapter(Class adaptee) {
        if (adaptee.isAssignableFrom(Map.class)) {
            return this.getMap();
        }
        if (adaptee.isAssignableFrom(ViewportPane.class)) {
            return this.viewer.getViewport();
        }
        return super.getAdapter(adaptee);
    }

    private void clearLayerDirtyFlag() {
        List layers = this.getMap().getMapLayers();
        for (ILayer layer : layers) {
            layer.getBlackboard().put(LAYER_DIRTY_KEY, null);
        }
    }

    @Override
    public void setFont(Control control) {
        this.viewer.setFont(control);
    }

    protected void updateCRS() {
        Map map = this.getMap();
        if (map == null) {
            this.getSite().getPage().closeEditor((IEditorPart)this, false);
            return;
        }
        CoordinateReferenceSystem crs = map.getViewportModel().getCRS();
        if (crs == null || crs.getName() == null) {
            return;
        }
        final String full = crs.getName().getCode();
        if (full == null || this.isSame(full)) {
            return;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null) {
            display = Display.getDefault();
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IStatusLineManager bar = MapEditorWithPalette.this.mapEditorSite.getActionBars().getStatusLineManager();
                if (bar == null) {
                    return;
                }
                StatusBarButton label = (StatusBarButton)bar.find("CRS Display");
                if (label == null) {
                    label = new StatusBarButton("CRS Display", full);
                    bar.appendToGroup("MIDDLE_GROUP", (IContributionItem)label);
                    label.setVisible(true);
                    bar.update(true);
                    return;
                }
                label.setText(full);
            }
        });
    }

    protected void updateScaleLabel() {
        if (this.composite.isDisposed()) {
            return;
        }
        if (Display.getCurrent() != null) {
            this.doUpdateScaleLabel();
            return;
        }
        Display display = PlatformUI.getWorkbench().getDisplay();
        if (display == null) {
            display = Display.getDefault();
        }
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                MapEditorWithPalette.this.doUpdateScaleLabel();
            }
        });
    }

    void doUpdateScaleLabel() {
        IStatusLineManager bar = this.mapEditorSite.getActionBars().getStatusLineManager();
        if (bar == null) {
            return;
        }
        ScaleRatioLabel label = (ScaleRatioLabel)bar.find("Current scale");
        if (label == null) {
            label = new ScaleRatioLabel(this);
            bar.appendToGroup("MIDDLE_GROUP", (IContributionItem)label);
            label.setVisible(true);
            bar.update(true);
        }
        label.setViewportModel(this.getMap().getViewportModel());
    }

    private boolean isSame(String crs) {
        StatusBarButton label;
        IStatusLineManager bar = this.getActionbar().getStatusLineManager();
        return bar != null && (label = (StatusBarButton)bar.find("CRS Display")) != null && crs.equals(label.getText());
    }

    public void dispose() {
        if (this.isTesting) {
            return;
        }
        if (this.getSite() == null || this.getSite().getPage() == null) {
            return;
        }
        this.runMapClosingInterceptors();
        this.deregisterFeatureFlasher();
        this.getSite().getPage().removePartListener(this.partlistener);
        if (this.viewer != null) {
            this.viewer.getViewport().removePaneListener((IMapDisplayListener)this.getMap().getViewportModelInternal());
        }
        this.getMap().getViewportModelInternal().setInitialized(false);
        this.selectFeatureListener = null;
        this.partlistener = null;
        if (this.statusLineManager != null) {
            this.statusLineManager.dispose();
        }
        MapToolPaletteFactory.dispose(this.paletteRoot);
        this.paletteRoot = null;
        final ScopedPreferenceStore store = ProjectPlugin.getPlugin().getPreferenceStore();
        if (!PlatformUI.getWorkbench().isClosing()) {
            ShutdownTaskList.instance().removePreShutdownTask(this.shutdownTask);
            try {
                this.getRenderManager().dispose();
            }
            catch (Throwable t) {
                ProjectUIPlugin.log("Shutting down rendering - " + t, null);
            }
            this.getMap().getEditManagerInternal().setEditFeature(null, null);
            try {
                PlatformGIS.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        ProjectUIPlugin.log("error saving map: " + MapEditorWithPalette.this.getMap().getName(), exception);
                    }

                    public void run() throws Exception {
                        MapEditorWithPalette.this.removeTemporaryLayers((IPreferenceStore)store);
                        Project p = MapEditorWithPalette.this.getMap().getProjectInternal();
                        if (p != null) {
                            Map map;
                            Resource resource;
                            if (p.eResource() != null && p.eResource().isModified()) {
                                p.eResource().save(ProjectPlugin.getPlugin().saveOptions);
                            }
                            if ((resource = (map = MapEditorWithPalette.this.getMap()).eResource()) != null) {
                                resource.save(ProjectPlugin.getPlugin().saveOptions);
                            }
                            p.eNotify((Notification)new ENotificationImpl((InternalEObject)p, 1, 1, null, null));
                        } else {
                            Resource resource = MapEditorWithPalette.this.getMap().eResource();
                            if (resource != null) {
                                resource.save(ProjectPlugin.getPlugin().saveOptions);
                            }
                        }
                        if (MapEditorWithPalette.this.viewer != null) {
                            MapEditorWithPalette.this.viewer.dispose();
                            MapEditorWithPalette.this.viewer = null;
                        }
                    }
                });
            }
            catch (Exception e) {
                ProjectPlugin.log((String)"Exception while saving Map", (Throwable)e);
            }
        }
        super.dispose();
    }

    private void runMapClosingInterceptors() {
        List interceptors = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.project.mapInterceptor");
        for (IConfigurationElement element : interceptors) {
            if (!"mapClosing".equals(element.getName())) continue;
            try {
                MapInterceptor interceptor = (MapInterceptor)element.createExecutableExtension("class");
                interceptor.run(this.getMap());
            }
            catch (Exception e) {
                ProjectPlugin.log((String)"", (Throwable)e);
            }
        }
    }

    private void removeTemporaryLayers(IPreferenceStore store) {
        if (store.getBoolean("P_REMOVE_LAYERS")) {
            List layers = this.getMap().getLayersInternal();
            ArrayList<Layer> layersToRemove = new ArrayList<Layer>();
            for (Layer layer : layers) {
                if (layer.getGeoResources().isEmpty() || !((IGeoResource)layer.getGeoResources().get(0)).canResolve(ITransientResolve.class)) continue;
                layersToRemove.add(layer);
            }
            if (!layers.isEmpty()) {
                if (this.getMap().eResource() != null) {
                    this.getMap().eResource().setModified(true);
                }
                layers.removeAll(layersToRemove);
            }
        }
    }

    public void doSave(IProgressMonitor monitor) {
        boolean[] success = new boolean[1];
        PlatformGIS.syncInDisplayThread((Runnable)new SaveMapPaletteRunnable(this, success));
        if (success[0]) {
            this.setDirty(false);
        } else {
            monitor.setCanceled(true);
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        ApplicationGIS.getToolManager();
    }

    protected void setInput(IEditorInput input) {
        if (this.getEditorInput() != null) {
            Map map = (Map)((UDIGEditorInput)this.getEditorInput()).getProjectElement();
            if (this.viewer != null) {
                this.viewer.setMap(null);
            }
            map.removeMapCompositionListener(this.mapCompositionListener);
            map.removeMapListener(this.mapListener);
            map.getEditManager().removeListener(this.editListener);
        }
        super.setInput(input);
        if (input != null) {
            if (this.viewer != null) {
                this.viewer.setMap((Map)((UDIGEditorInput)input).getProjectElement());
            }
            this.getMap().addMapCompositionListener(this.mapCompositionListener);
            this.getMap().addMapListener(this.mapListener);
            this.getMap().getEditManager().addListener(this.editListener);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    private boolean isMapDirty() {
        boolean dirty = false;
        for (ILayer layer : this.getMap().getMapLayers()) {
            boolean layerIsDirty;
            if (layer.hasResource(ITransientResolve.class)) {
                dirty = true;
            }
            boolean bl = layerIsDirty = layer.getBlackboard().get(LAYER_DIRTY_KEY) != null;
            if (!layerIsDirty) continue;
            dirty = true;
        }
        return dirty;
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    @Override
    public void setDirty(boolean dirty) {
        if (dirty == this.dirty) {
            return;
        }
        this.dirty = dirty;
        if (!dirty) {
            this.clearLayerDirtyFlag();
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MapEditorWithPalette.this.firePropertyChange(257);
            }
        });
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    public void createPartControl(Composite parent) {
        ShutdownTaskList.instance().addPreShutdownTask(this.shutdownTask);
        if (this.editDomain == null) {
            this.editDomain = new MapEditDomain(this);
        }
        this.setEditDomain(this.editDomain);
        super.createPartControl(parent);
    }

    protected Control getGraphicalControl() {
        return this.composite;
    }

    protected void createGraphicalViewer(Composite parent) {
        this.composite = new Composite(parent, 262144);
        this.composite.setLayout((Layout)new FormLayout());
        this.composite.setFont(parent.getFont());
        this.setPartName(this.getMap().getName());
        this.setTitleToolTip(Messages.MapEditor_titleToolTip);
        this.setTitleImage(ProjectUIPlugin.getDefault().getImage("obj16/map_obj.gif"));
        ScopedPreferenceStore preferenceStore = ProjectPlugin.getPlugin().getPreferenceStore();
        boolean istiled = preferenceStore.getBoolean("P_TILED_RENDERING");
        this.viewer = !istiled ? new MapViewer(this.composite, 0x20000000) : new MapViewer(this.composite, 262146);
        this.viewer.init((IWorkbenchPart)this);
        Map input = (Map)((UDIGEditorInput)this.getEditorInput()).getProjectElement();
        if (input != null) {
            this.viewer.setMap(input);
        }
        FormData formdata = new FormData();
        formdata.top = new FormAttachment(0);
        formdata.bottom = new FormAttachment(100, -ScaleRatioLabel.STATUS_LINE_HEIGHT);
        formdata.left = new FormAttachment(0);
        formdata.right = new FormAttachment(100);
        this.viewer.getViewport().getControl().setLayoutData((Object)formdata);
        this.statusLineManager.add((IContributionItem)new GroupMarker("BEGIN_GROUP"));
        this.statusLineManager.add((IContributionItem)new GroupMarker("MIDDLE_GROUP"));
        this.statusLineManager.add((IContributionItem)new GroupMarker("END_GROUP"));
        this.statusLineManager.createControl(this.composite, 2048);
        formdata = new FormData();
        formdata.left = new FormAttachment(0);
        formdata.right = new FormAttachment(100);
        formdata.top = new FormAttachment(this.viewer.getViewport().getControl(), 0, 1024);
        formdata.bottom = new FormAttachment(100);
        this.statusLineManager.getControl().setLayoutData((Object)formdata);
        this.getSite().getPage().addPartListener(this.partlistener);
        this.registerFeatureFlasher();
        this.viewer.getViewport().addPaneListener((IMapDisplayListener)this.getMap().getViewportModelInternal());
        this.layerSelectionListener = new LayerSelectionListener(new LayerSelectionListener.Callback(){

            @Override
            public void callback(List<Layer> layers) {
                if (MapEditorWithPalette.this.composite.isDisposed()) {
                    MapEditorWithPalette.this.getSite().getPage().removePostSelectionListener((ISelectionListener)MapEditorWithPalette.this.layerSelectionListener);
                    return;
                }
                if (!MapEditorWithPalette.this.composite.isVisible()) {
                    return;
                }
                Layer layer = layers.get(0);
                if (layer.getMap() == MapEditorWithPalette.this.getMap() && MapEditorWithPalette.this.getMap().getEditManager().getSelectedLayer() != layer) {
                    SelectLayerCommand selectLayerCommand = new SelectLayerCommand((ILayer)layer);
                    selectLayerCommand.setMap((IMap)MapEditorWithPalette.this.getMap());
                    try {
                        selectLayerCommand.run(ProgressManager.instance().get(new Object[0]));
                    }
                    catch (Exception e) {
                        throw (RuntimeException)new RuntimeException().initCause(e);
                    }
                    MapEditorWithPalette.this.getMap().sendCommandSync((MapCommand)new UndoRedoCommand((UndoableMapCommand)selectLayerCommand));
                }
            }
        });
        this.getSite().getPage().addPostSelectionListener((ISelectionListener)this.layerSelectionListener);
        for (Layer layer : this.getMap().getLayersInternal()) {
            layer.addListener(this.layerListener);
        }
        this.dropTarget = UDIGDragDropUtilities.addDropSupport((Control)this.viewer.getViewport().getControl(), (IDropTargetProvider)this);
        this.replaceableSelectionProvider = new ReplaceableSelectionProvider();
        this.getSite().setSelectionProvider((ISelectionProvider)this.replaceableSelectionProvider);
        this.runMapOpeningInterceptor(this.getMap());
        this.mapEditorSite = new MapEditorSite(super.getSite(), this);
        this.updateCRS();
        this.updateScaleLabel();
        this.getMap().getViewportModel().addViewportModelListener(new IViewportModelListener(){

            public void changed(ViewportModelEvent event) {
                if (MapEditorWithPalette.this.getMap() == null) {
                    event.getSource().removeViewportModelListener((IViewportModelListener)this);
                    return;
                }
                if (event.getType() == ViewportModelEvent.EventType.CRS) {
                    MapEditorWithPalette.this.updateCRS();
                }
            }
        });
        this.setDirty(this.isMapDirty());
    }

    private void runMapOpeningInterceptor(Map map) {
        List interceptors = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.project.mapInterceptor");
        for (IConfigurationElement element : interceptors) {
            if (!"mapOpening".equals(element.getName())) continue;
            try {
                MapInterceptor interceptor = (MapInterceptor)element.createExecutableExtension("class");
                interceptor.run(map);
            }
            catch (Exception e) {
                ProjectPlugin.log((String)"", (Throwable)e);
            }
        }
    }

    protected synchronized void registerFeatureFlasher() {
        if (!this.flashFeatureRegistered) {
            this.flashFeatureRegistered = true;
            IWorkbenchPage page = this.getSite().getPage();
            page.addPostSelectionListener((ISelectionListener)this.selectFeatureListener);
        }
    }

    protected synchronized void deregisterFeatureFlasher() {
        this.flashFeatureRegistered = false;
        this.getSite().getPage().removePostSelectionListener((ISelectionListener)this.selectFeatureListener);
    }

    void createContextMenu() {
        Menu menu = this.viewer.getMenu();
        if (menu == null) {
            final MenuManager contextMenu = new MenuManager();
            contextMenu.setRemoveAllWhenShown(true);
            contextMenu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager mgr) {
                    IToolManager tm = ApplicationGIS.getToolManager();
                    contextMenu.add(tm.getENTERAction());
                    contextMenu.add((IContributionItem)new Separator());
                    contextMenu.add(tm.getZOOMTOSELECTEDAction());
                    contextMenu.add((IContributionItem)new Separator());
                    contextMenu.add(tm.getBACKWARD_HISTORYAction());
                    contextMenu.add(tm.getFORWARD_HISTORYAction());
                    contextMenu.add((IContributionItem)new Separator());
                    contextMenu.add(tm.getCOPYAction((IWorkbenchPart)MapEditorWithPalette.this));
                    contextMenu.add(tm.getPASTEAction((IWorkbenchPart)MapEditorWithPalette.this));
                    contextMenu.add(tm.getDELETEAction());
                    tm.contributeActiveModalTool((IMenuManager)contextMenu);
                    contextMenu.add((IContributionItem)new Separator());
                    contextMenu.add((IContributionItem)new GroupMarker("additions"));
                    if (MapEditorWithPalette.this.getMap().getEditManager().getEditFeature() != null) {
                        contextMenu.add(ProjectUIPlugin.getDefault().getFeatureEditProcessor().getEditFeatureAction(MapEditorWithPalette.this.getSite().getSelectionProvider().getSelection()));
                        contextMenu.add(ProjectUIPlugin.getDefault().getFeatureEditProcessor().getEditWithFeatureMenu(MapEditorWithPalette.this.getSite().getSelectionProvider().getSelection()));
                    }
                    contextMenu.add((IContributionItem)ApplicationGIS.getToolManager().createOperationsContextMenu(MapEditorWithPalette.this.replaceableSelectionProvider.getSelection()));
                    contextMenu.add((IContributionItem)new Separator());
                    contextMenu.add((IAction)ActionFactory.EXPORT.create(MapEditorWithPalette.this.getSite().getWorkbenchWindow()));
                    contextMenu.add((IContributionItem)new Separator());
                    contextMenu.add(MapEditorWithPalette.this.getPropertiesAction());
                }
            });
            menu = contextMenu.createContextMenu((Control)this.composite);
            this.viewer.setMenu(menu);
            this.getSite().registerContextMenu(contextMenu, this.getSite().getSelectionProvider());
        }
    }

    protected IAction getPropertiesAction() {
        if (this.propertiesAction == null) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            final PropertyDialogAction tmp = new PropertyDialogAction((IShellProvider)new SameShellProvider((Control)shell), new ISelectionProvider(){

                public void addSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public ISelection getSelection() {
                    return new StructuredSelection((Object)MapEditorWithPalette.this.getMap());
                }

                public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                }

                public void setSelection(ISelection selection) {
                }
            });
            this.propertiesAction = new Action(){

                public void runWithEvent(Event event) {
                    tmp.createDialog().open();
                }
            };
            this.propertiesAction.setText(tmp.getText());
            this.propertiesAction.setActionDefinitionId(tmp.getActionDefinitionId());
            this.propertiesAction.setDescription(tmp.getDescription());
            this.propertiesAction.setHoverImageDescriptor(tmp.getHoverImageDescriptor());
            this.propertiesAction.setImageDescriptor(tmp.getImageDescriptor());
            this.propertiesAction.setToolTipText(tmp.getToolTipText());
        }
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.propertiesAction);
        return this.propertiesAction;
    }

    public void setFocus() {
        this.composite.setFocus();
        this.updateCRS();
        this.updateScaleLabel();
    }

    @Override
    public Map getMap() {
        UDIGEditorInput editorInput = (UDIGEditorInput)this.getEditorInput();
        if (editorInput != null) {
            return (Map)editorInput.getProjectElement();
        }
        return null;
    }

    public SubActionBars2 getActionbar() {
        return (SubActionBars2)this.getEditorSite().getActionBars();
    }

    @Override
    public void openContextMenu() {
        this.viewer.openContextMenu();
    }

    @Override
    public UDIGDropHandler getDropHandler() {
        return ((UDIGControlDropListener)this.dropTarget.listener).getHandler();
    }

    public Object getTarget(DropTargetEvent event) {
        return this;
    }

    @Override
    public void setDragging(boolean enable) {
        if (this.draggingEnabled == enable) {
            return;
        }
        if (enable) {
            this.dragSource = UDIGDragDropUtilities.addDragSupport((Control)this.viewer.getViewport().getControl(), (ISelectionProvider)this.getSite().getSelectionProvider());
        } else {
            this.dragSource.source.dispose();
        }
        this.draggingEnabled = enable;
    }

    @Override
    public boolean isDragging() {
        return this.draggingEnabled;
    }

    public String toString() {
        return this.getTitle();
    }

    @Override
    public void setSelectionProvider(IMapEditorSelectionProvider selectionProvider) {
        if (selectionProvider == null) {
            throw new NullPointerException("selection provider must not be null!");
        }
        selectionProvider.setActiveMap((IMap)this.getMap(), this);
        if (selectionProvider != this.replaceableSelectionProvider.getSelectionProvider()) {
            this.replaceableSelectionProvider.setProvider(selectionProvider);
        }
        this.createContextMenu();
    }

    @Override
    public MapEditorSite getMapEditorSite() {
        return this.mapEditorSite;
    }

    public boolean isVisible() {
        return this.visible;
    }

    RenderManager getRenderManager() {
        return this.viewer.getRenderManager();
    }

    @Override
    public IStatusLineManager getStatusLineManager() {
        return this.statusLineManager;
    }

    public MapEditDomain getEditDomain() {
        return this.editDomain;
    }

    @Override
    public boolean isTesting() {
        return this.isTesting;
    }

    @Override
    public void setTesting(boolean testing) {
        this.isTesting = testing;
    }

    private class FlashFeatureListener
    implements ISelectionListener {
        private FlashFeatureListener() {
        }

        public void selectionChanged(IWorkbenchPart part, final ISelection selection) {
            if (part == MapEditorWithPalette.this || MapEditorWithPalette.this.getSite().getPage().getActivePart() != part || selection instanceof IBlockingSelection) {
                return;
            }
            ISafeRunnable sendAnimation = new ISafeRunnable(){

                public void run() {
                    if (selection instanceof IStructuredSelection) {
                        IAnimation anim;
                        IStructuredSelection s = (IStructuredSelection)selection;
                        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
                        for (Object element : s) {
                            IAdaptable adaptable;
                            Object featureObj;
                            if (element instanceof SimpleFeature) {
                                SimpleFeature feature = (SimpleFeature)element;
                                features.add(feature);
                                continue;
                            }
                            if (!(element instanceof IAdaptable) || (featureObj = (adaptable = (IAdaptable)element).getAdapter(SimpleFeature.class)) == null || !(featureObj instanceof SimpleFeature)) continue;
                            SimpleFeature feature = (SimpleFeature)featureObj;
                            features.add(feature);
                        }
                        if (features.size() == 0) {
                            return;
                        }
                        if (!MapEditorWithPalette.this.getRenderManager().isDisposed() && (anim = FlashFeatureListener.this.createAnimation(features)) != null) {
                            AnimationUpdater.runTimer(MapEditorWithPalette.this.getMap().getRenderManager().getMapDisplay(), anim);
                        }
                    }
                }

                public void handleException(Throwable exception) {
                    ProjectUIPlugin.log("Exception preparing animation", exception);
                }
            };
            try {
                sendAnimation.run();
            }
            catch (Exception e) {
                ProjectUIPlugin.log("", e);
            }
        }

        private IAnimation createAnimation(List<SimpleFeature> current) {
            Rectangle rect;
            ArrayList<DrawFeatureCommand> commands = new ArrayList<DrawFeatureCommand>();
            for (SimpleFeature feature : current) {
                Layer layer;
                if (feature == null || feature.getFeatureType().getGeometryDescriptor() == null) continue;
                DrawFeatureCommand command = null;
                if (feature instanceof IAdaptable && (layer = (Layer)((IAdaptable)feature).getAdapter(Layer.class)) != null) {
                    try {
                        command = new DrawFeatureCommand(feature, (ILayer)layer);
                    }
                    catch (IOException iOException) {}
                }
                if (command == null) {
                    command = new DrawFeatureCommand(feature);
                }
                command.setMap((IMap)MapEditorWithPalette.this.getMap());
                command.preRender();
                commands.add(command);
            }
            Rectangle validArea = rect = new Rectangle();
            return new FeatureAnimation(commands, validArea);
        }
    }

    class StatusBarButton
    extends ContributionItem {
        static final String CRS_ITEM_ID = "CRS Display";
        static final String BOUNDS_ITEM_ID = "Bounds Display";
        static final int MAX_LENGTH = 12;
        private Button button;
        private String value;
        private String full;
        Label textLabel;
        Shell popup;

        public StatusBarButton(String id, String initialValue) {
            super(id);
            this.setText(initialValue);
        }

        public void setText(String text) {
            this.full = this.value = text;
            if (this.value.length() > 12) {
                int start2 = this.value.length() - 6;
                this.value = String.valueOf(this.value.substring(0, 6)) + "..." + this.value.substring(start2, this.value.length());
                System.out.println(this.value.length());
            }
            if (this.button != null && !this.button.isDisposed()) {
                this.button.setText(this.value);
            }
        }

        public boolean isDynamic() {
            return true;
        }

        public void dispose() {
            if (this.button != null) {
                this.button.dispose();
            }
            if (this.popup != null) {
                this.popup.dispose();
            }
        }

        public void fill(Composite c) {
            Label separator = new Label(c, 2);
            StatusLineLayoutData data = new StatusLineLayoutData();
            separator.setLayoutData((Object)data);
            data.widthHint = 1;
            data.heightHint = ScaleRatioLabel.STATUS_LINE_HEIGHT;
            this.button = new Button(c, 0x800008);
            MapEditorWithPalette.this.setFont((Control)this.button);
            data = new StatusLineLayoutData();
            this.button.setLayoutData((Object)data);
            this.button.setText(this.value);
            this.button.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    StatusBarButton.this.promptForCRS();
                }
            });
            this.button.addListener(6, new Listener(){

                public void handleEvent(Event event) {
                    StatusBarButton.this.showFullText();
                }
            });
            data.widthHint = 132;
            data.heightHint = ScaleRatioLabel.STATUS_LINE_HEIGHT;
        }

        private void promptForCRS() {
            CoordinateReferenceSystem result;
            CoordinateReferenceSystem crs = MapEditorWithPalette.this.getMap().getViewportModel().getCRS();
            CRSChooserDialog dialog = new CRSChooserDialog(MapEditorWithPalette.this.getSite().getShell(), crs);
            int code = dialog.open();
            if (code == 0 && !(result = dialog.getResult()).equals(crs)) {
                MapEditorWithPalette.this.getMap().sendCommandSync((MapCommand)new ChangeCRSCommand(result));
                MapEditorWithPalette.this.updateCRS();
            }
        }

        void showFullText() {
            final Display display = this.button.getDisplay();
            if (this.popup == null) {
                this.popup = new Shell(display.getActiveShell(), 540672);
                this.popup.setForeground(display.getSystemColor(28));
                this.popup.setBackground(display.getSystemColor(29));
                this.popup.setLayout((Layout)new RowLayout());
                Composite composite = new Composite((Composite)this.popup, 0);
                composite.setForeground(display.getSystemColor(28));
                composite.setBackground(display.getSystemColor(29));
                composite.setLayout((Layout)new RowLayout());
                this.textLabel = new Label((Composite)this.popup, 0);
                this.textLabel.setForeground(display.getSystemColor(28));
                this.textLabel.setBackground(display.getSystemColor(29));
                this.textLabel.setFont(this.button.getFont());
            }
            Point location = MapEditorWithPalette.this.statusLineManager.getControl().toDisplay(this.button.getLocation());
            location.y -= ScaleRatioLabel.STATUS_LINE_HEIGHT;
            if (this.popup.isDisposed()) {
                return;
            }
            this.popup.setLocation(location);
            this.textLabel.setText(this.full);
            this.popup.setVisible(true);
            this.popup.pack(true);
            display.timerExec(500, new Runnable(){

                @Override
                public void run() {
                    StatusBarButton.this.checkforMouseOver(display);
                }
            });
        }

        private void checkforMouseOver(final Display display) {
            if (display.getCursorControl() == this.button) {
                display.timerExec(500, new Runnable(){

                    @Override
                    public void run() {
                        if (display.getCursorControl() == StatusBarButton.this.button) {
                            StatusBarButton.this.checkforMouseOver(display);
                        } else {
                            StatusBarButton.this.popup.setVisible(false);
                        }
                    }
                });
            } else {
                this.popup.setVisible(false);
            }
        }

        public String getText() {
            return this.full;
        }
    }
}

