/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import com.vividsolutions.jts.geom.Envelope;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IProjectElement;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.project.ui.UDIGEditorInput;
import net.refractions.udig.project.ui.internal.Messages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPersistableElement;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MapEditorInput
extends UDIGEditorInput {
    public MapEditorInput() {
    }

    public MapEditorInput(IMap map) {
        this.setProjectElement((IProjectElement)map);
    }

    public Envelope getExtent() {
        IViewportModel model = this.getProjectElement().getViewportModel();
        ReferencedEnvelope bounds = model.getBounds();
        CoordinateReferenceSystem crs = model.getCRS();
        ReferencedEnvelope extent = new ReferencedEnvelope((Envelope)bounds, crs);
        try {
            return extent.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
        }
        catch (Exception exception) {
            return new Envelope(-180.0, 180.0, -90.0, 90.0);
        }
    }

    public IMap getProjectElement() {
        return (IMap)super.getProjectElement();
    }

    @Override
    public boolean exists() {
        return true;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Override
    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.getName();
    }

    @Override
    public Object getAdapter(Class adapter) {
        return null;
    }

    public String getName() {
        return Messages.MapEditorInput_name;
    }
}

