/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IRepository;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ILegendItem;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.Interaction;
import net.refractions.udig.project.internal.Folder;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerLegendItem;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;

public final class LegendViewUtils {
    private static final String MAP_GRAPHIC_PROTOCOL = "mapgraphic";
    private static final String GRID_ID_STR = "grid";
    private static final String GRID_URL = "mapgraphic:/localhost/mapgraphic#grid";
    private static final ID GRID_ID = new ID("mapgraphic:/localhost/mapgraphic#grid", null);

    public static boolean isBackgroundLayer(ILayer layer) {
        return layer.getInteraction(Interaction.BACKGROUND);
    }

    public static boolean isMapGraphicLayer(ILayer layer) {
        return layer != null && layer.getID() != null && MAP_GRAPHIC_PROTOCOL.equals(layer.getID().getProtocol());
    }

    public static boolean isGridLayer(ILayer layer) {
        return layer != null && layer.getID() != null && LegendViewUtils.isMapGraphicLayer(layer) && GRID_ID_STR.equals(layer.getID().getRef());
    }

    public static Layer findGridLayer(IMap map) {
        if (map != null) {
            for (ILayer layer : map.getMapLayers()) {
                if (!LegendViewUtils.isGridLayer(layer)) continue;
                return (Layer)layer;
            }
        }
        return null;
    }

    public static IGeoResource getGridMapGraphic() {
        IRepository local = CatalogPlugin.getDefault().getLocal();
        IGeoResource gridResource = (IGeoResource)local.getById(IGeoResource.class, GRID_ID, (IProgressMonitor)new NullProgressMonitor());
        if (gridResource == null) {
            System.out.println("[LegendViewUtils] Grid resource not found. Either service is not up or it does not hold the resource.");
        }
        return gridResource;
    }

    public static boolean isFolderSelected(ISelection selection) {
        IStructuredSelection strucSelection;
        return selection instanceof IStructuredSelection && (strucSelection = (IStructuredSelection)selection).size() == 1 && strucSelection.getFirstElement() instanceof Folder;
    }

    public static List<Layer> getLayers(List<ILegendItem> items, boolean isOrdered) {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (ILegendItem item : items) {
            layers.addAll(LegendViewUtils.getLayers(item));
        }
        if (isOrdered) {
            Collections.sort(layers);
        }
        return layers;
    }

    private static List<Layer> getLayers(ILegendItem item) {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        if (item instanceof Folder) {
            layers.addAll(LegendViewUtils.getLayers((Folder)item));
        } else if (item instanceof LayerLegendItem) {
            LayerLegendItem layerItem = (LayerLegendItem)item;
            layers.add(layerItem.getLayer());
        }
        return layers;
    }

    private static List<Layer> getLayers(Folder folder) {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (ILegendItem item : folder.getItems()) {
            if (item instanceof Folder) {
                layers.addAll(LegendViewUtils.getLayers((Folder)item));
                continue;
            }
            if (!(item instanceof LayerLegendItem)) continue;
            LayerLegendItem layerItem = (LayerLegendItem)item;
            layers.add(layerItem.getLayer());
        }
        return layers;
    }

    public static List<Layer> getGridLayers(List<ILegendItem> legendItems) {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (ILegendItem item : legendItems) {
            LayerLegendItem layerItem;
            Layer layer;
            if (item instanceof Folder) {
                Folder folder = (Folder)item;
                for (ILegendItem folderItem : folder.getItems()) {
                    LayerLegendItem layerItem2;
                    Layer layer2;
                    if (!(folderItem instanceof LayerLegendItem) || !LegendViewUtils.isGridLayer((ILayer)(layer2 = (layerItem2 = (LayerLegendItem)folderItem).getLayer()))) continue;
                    layers.add(layer2);
                }
                continue;
            }
            if (!(item instanceof LayerLegendItem) || !LegendViewUtils.isGridLayer((ILayer)(layer = (layerItem = (LayerLegendItem)item).getLayer()))) continue;
            layers.add(layer);
        }
        return layers;
    }
}

