/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ILayerListener;
import net.refractions.udig.project.LayerEvent;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerLegendItem;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.commands.AddLayersCommand;
import net.refractions.udig.project.ui.internal.LegendViewUtils;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.action.Action;

public class LegendViewGridHandler
implements ILayerListener {
    private Map map;
    private List<Layer> gridLayers;
    private Action gridAction;
    private boolean isLegendViewAddingGrid = false;

    public void setMap(Map map) {
        this.cleanHandler();
        this.initMap(map);
        this.initGridLayers(map);
        this.setGridActionState();
    }

    public void disposeHandler() {
        this.cleanHandler();
        if (this.gridAction != null) {
            this.gridAction = null;
        }
    }

    private void cleanHandler() {
        if (this.gridLayers != null) {
            for (Layer gridLayer : this.gridLayers) {
                gridLayer.removeListener((ILayerListener)this);
            }
            int i = 0;
            while (i < this.gridLayers.size()) {
                this.gridLayers.remove(i);
                ++i;
            }
            this.gridLayers = null;
        }
        if (this.map != null) {
            this.map = null;
        }
    }

    private void initMap(Map map) {
        this.map = map;
    }

    private void initGridLayers(Map map) {
        if (map != null) {
            this.gridLayers = new ArrayList<Layer>();
            for (ILayer iLayer : LegendViewUtils.getLayers(map.getLegend(), false)) {
                if (!LegendViewUtils.isGridLayer(iLayer)) continue;
                this.addGridLayer((Layer)iLayer);
            }
            if (this.gridLayers.size() == 0) {
                this.isLegendViewAddingGrid = true;
                this.map.sendCommandASync((MapCommand)new AddLayersCommand(Collections.singletonList(LegendViewUtils.getGridMapGraphic())));
            }
        }
    }

    private void addGridLayer(Layer layer) {
        if (layer != null) {
            layer.addListener((ILayerListener)this);
            this.gridLayers.add(layer);
        }
    }

    private void removeGridLayer(Layer layer) {
        if (layer != null) {
            layer.removeListener((ILayerListener)this);
            this.gridLayers.remove(layer);
        }
    }

    public Action getGridAction() {
        this.gridAction = new Action(null, 2){

            public void run() {
                LegendViewGridHandler.this.toggleGrid(LegendViewGridHandler.this.gridAction.isChecked());
            }
        };
        this.gridAction.setImageDescriptor(ProjectUIPlugin.getDefault().getImageDescriptor("elcl16/toggle_grid_co.gif"));
        this.gridAction.setToolTipText(Messages.LegendView_show_grid_tooltip);
        this.setGridActionState();
        return this.gridAction;
    }

    private void toggleGrid(boolean isChecked) {
        for (Layer gridLayer : this.gridLayers) {
            gridLayer.setVisible(isChecked);
        }
    }

    public void testToggleGrid(boolean isChecked) {
        this.toggleGrid(isChecked);
    }

    public void refresh(LayerEvent event) {
        this.setGridActionState();
    }

    public void refresh(Notification msg) {
        int eventType = msg.getEventType();
        Object obj = null;
        if (3 == eventType) {
            obj = msg.getNewValue();
        } else if (4 == eventType) {
            obj = msg.getOldValue();
        }
        if (obj != null && obj instanceof LayerLegendItem) {
            LayerLegendItem layerItem = (LayerLegendItem)obj;
            Layer layer = layerItem.getLayer();
            if (3 == eventType) {
                if (LegendViewUtils.isGridLayer((ILayer)layer)) {
                    if (this.isLegendViewAddingGrid) {
                        layer.setVisible(false);
                        this.isLegendViewAddingGrid = false;
                    }
                    this.addGridLayer(layer);
                }
            } else if (4 == eventType && LegendViewUtils.isGridLayer((ILayer)layer)) {
                this.removeGridLayer(layer);
            }
            this.setGridActionState();
        }
    }

    private void setGridActionState() {
        if (this.gridAction != null) {
            if (this.gridLayers == null) {
                this.gridAction.setEnabled(false);
            } else if (this.gridLayers.size() > 0) {
                this.gridAction.setEnabled(true);
                this.setGridActionCheckedState(this.gridLayers);
            } else {
                this.gridAction.setEnabled(false);
            }
        }
    }

    private void setGridActionCheckedState(List<Layer> gridLayers) {
        boolean isAtLeastOneVisible = false;
        for (Layer gridLayer : gridLayers) {
            if (!gridLayer.isVisible()) continue;
            isAtLeastOneVisible = true;
            break;
        }
        this.gridAction.setChecked(isAtLeastOneVisible);
    }
}

