/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.ArrayList;
import net.refractions.udig.internal.ui.IDropTargetProvider;
import net.refractions.udig.project.BlackboardEvent;
import net.refractions.udig.project.EditManagerEvent;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.IBlackboardListener;
import net.refractions.udig.project.IEditManager;
import net.refractions.udig.project.IEditManagerListener;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ILegendItem;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.map.LayerMoveBackCommand;
import net.refractions.udig.project.command.map.LayerMoveDownCommand;
import net.refractions.udig.project.command.map.LayerMoveFrontCommand;
import net.refractions.udig.project.command.map.LayerMoveUpCommand;
import net.refractions.udig.project.internal.Folder;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerLegendItem;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.ProjectFactory;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.commands.AddFolderItemCommand;
import net.refractions.udig.project.render.IViewportModelListener;
import net.refractions.udig.project.render.ViewportModelEvent;
import net.refractions.udig.project.ui.AdapterFactoryLabelProviderDecorator;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.LegendViewCheckboxUtils;
import net.refractions.udig.project.ui.internal.LegendViewContentProvider;
import net.refractions.udig.project.ui.internal.LegendViewFiltersHandler;
import net.refractions.udig.project.ui.internal.LegendViewGridHandler;
import net.refractions.udig.project.ui.internal.LegendViewRenameFolderAction;
import net.refractions.udig.project.ui.internal.LegendViewUtils;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectExplorer;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.actions.Delete;
import net.refractions.udig.project.ui.tool.IToolManager;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.UDIGDragDropUtilities;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class LegendView
extends ViewPart
implements IDropTargetProvider,
ISelectionChangedListener {
    public static final String ID = "net.refractions.udig.project.ui.legendManager";
    private Map currentMap;
    private LegendViewGridHandler gridHandler = new LegendViewGridHandler();
    private LegendViewFiltersHandler filtersHandler = new LegendViewFiltersHandler(this);
    private LayerAction downAction;
    private LayerAction upAction;
    private LayerAction frontAction;
    private LayerAction backAction;
    private IAction newFolderAction;
    private LegendViewRenameFolderAction renameFolderAction;
    private CheckboxTreeViewer viewer;
    private LegendViewContentProvider contentProvider;
    private AdapterFactoryLabelProviderDecorator labelProvider;
    private ILabelProviderListener labelProviderListener = new LabelProviderListerner();
    private CheckStateListener checkStateListener = new CheckStateListener();
    private CollapseExpandListener collapeExpandListener = new CollapseExpandListener();
    private IAction deleteAction;
    private MapEditorListener partServiceListener = new MapEditorListener();
    private EditManagerListener editManagerListener;
    private IBlackboardListener mylarListener = new BlackboardListener();
    private Adapter mapDeepListener = new MapDeepListener();
    private ZoomListener zoomListener = new ZoomListener();

    public LegendViewGridHandler getGridHandler() {
        return this.gridHandler;
    }

    public LegendViewFiltersHandler getFiltersHandler() {
        return this.filtersHandler;
    }

    public LayerAction getFrontAction() {
        return this.frontAction;
    }

    public LayerAction getBackAction() {
        return this.backAction;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public CheckboxTreeViewer getViewer() {
        return this.viewer;
    }

    public void createPartControl(Composite parent) {
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener)this.partServiceListener);
        this.initViewer(parent);
        this.initContextMenu((Viewer)this.viewer);
        this.initToobarActions();
        this.setGlobalActions();
        UDIGDragDropUtilities.addDragDropSupport((StructuredViewer)this.viewer, (IDropTargetProvider)this);
    }

    protected void disposeInternal() {
        if (PlatformUI.getWorkbench().isClosing()) {
            ProjectPlugin.getPlugin().turnOffEvents();
        }
        this.removeViewerListeners();
        this.removeCurrentMapListeners();
        this.gridHandler.disposeHandler();
        this.filtersHandler.disposeHandler();
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener)this.partServiceListener);
    }

    private void initViewer(Composite parent) {
        this.viewer = new CheckboxTreeViewer(parent, 4);
        this.contentProvider = new LegendViewContentProvider(this);
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.labelProvider = new AdapterFactoryLabelProviderDecorator(ProjectExplorer.getProjectExplorer().getAdapterFactory(), (StructuredViewer)this.viewer);
        if (this.labelProviderListener == null) {
            this.labelProviderListener = new LabelProviderListerner();
        }
        this.labelProvider.addListener(this.labelProviderListener);
        this.viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        if (this.checkStateListener == null) {
            this.checkStateListener = new CheckStateListener();
        }
        this.viewer.addCheckStateListener((ICheckStateListener)this.checkStateListener);
        if (this.collapeExpandListener == null) {
            this.collapeExpandListener = new CollapseExpandListener();
        }
        this.viewer.addTreeListener((ITreeViewerListener)this.collapeExpandListener);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.viewer.setFilters(this.filtersHandler.getFilters());
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.initMapFromEditor();
    }

    private void removeViewerListeners() {
        this.labelProvider.removeListener(this.labelProviderListener);
        this.labelProviderListener = null;
        this.labelProvider.dispose();
        this.labelProvider = null;
        this.viewer.removeCheckStateListener((ICheckStateListener)this.checkStateListener);
        this.checkStateListener = null;
        this.viewer.removeTreeListener((ITreeViewerListener)this.collapeExpandListener);
        this.collapeExpandListener = null;
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void initMapFromEditor() {
        Object mapObj;
        IEditorPart activeEditor = this.getSite().getPage().getActiveEditor();
        if (activeEditor != null && activeEditor instanceof IAdaptable && (mapObj = activeEditor.getAdapter(Map.class)) != null) {
            this.setCurrentMap((Map)mapObj);
        }
    }

    private void initContextMenu(Viewer targetViewer) {
        final MenuManager contextMenu = new MenuManager();
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                if (LegendView.this.canAddFolder()) {
                    contextMenu.add(LegendView.this.newFolderAction());
                }
                if (LegendViewUtils.isFolderSelected(LegendView.this.viewer.getSelection())) {
                    contextMenu.add(LegendView.this.renameFolderAction());
                }
                if (LegendView.this.canDelete()) {
                    contextMenu.add((IContributionItem)new Separator());
                    contextMenu.add(LegendView.this.getDeleteAction());
                }
            }
        });
        Control control = targetViewer.getControl();
        Menu menu = contextMenu.createContextMenu(control);
        control.setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)targetViewer);
    }

    private boolean canAddFolder() {
        return this.newFolderAction.isEnabled();
    }

    private boolean canDelete() {
        StructuredSelection structSelection;
        Object selectedObj;
        ISelection selection = this.viewer.getSelection();
        return !selection.isEmpty() && selection instanceof StructuredSelection && (selectedObj = (structSelection = (StructuredSelection)selection).getFirstElement()) instanceof LayerLegendItem;
    }

    private ISelection getDeleteSelection() {
        ISelection selection = this.viewer.getSelection();
        StructuredSelection strucSelection = (StructuredSelection)selection;
        ArrayList adaptedObjs = new ArrayList();
        for (Object obj : strucSelection.toList()) {
            if (obj instanceof Folder) {
                adaptedObjs.add(obj);
                continue;
            }
            if (!(obj instanceof LayerLegendItem)) continue;
            LayerLegendItem layerItem = (LayerLegendItem)obj;
            adaptedObjs.add(layerItem.getLayer());
        }
        StructuredSelection adaptedSelection = new StructuredSelection(adaptedObjs);
        return adaptedSelection;
    }

    private IAction getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = new Action(){

                public void run() {
                    ISelection selection = LegendView.this.getDeleteSelection();
                    if (!selection.isEmpty()) {
                        Delete delete = new Delete(false);
                        delete.selectionChanged((IAction)this, selection);
                        delete.run((IAction)this);
                    }
                }
            };
            this.deleteAction.setActionDefinitionId("org.eclipse.ui.edit.delete");
            ActionFactory.IWorkbenchAction actionTemplate = ActionFactory.DELETE.create(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
            this.deleteAction.setText(actionTemplate.getText());
            this.deleteAction.setToolTipText(actionTemplate.getToolTipText());
            this.deleteAction.setImageDescriptor(actionTemplate.getImageDescriptor());
            this.deleteAction.setDescription(actionTemplate.getDescription());
            this.deleteAction.setDisabledImageDescriptor(actionTemplate.getDisabledImageDescriptor());
        }
        return this.deleteAction;
    }

    private void initToobarActions() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        mgr.add(this.newFolderAction());
        this.renameFolderAction();
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.moveFrontAction());
        mgr.add((IAction)this.upAction());
        mgr.add((IAction)this.downAction());
        mgr.add((IAction)this.moveBackAction());
        mgr.add((IContributionItem)new Separator());
        mgr.add((IAction)this.filtersHandler.getToggleMgAction());
        mgr.add((IAction)this.filtersHandler.getToggleBgAction());
        mgr.add((IAction)this.gridHandler.getGridAction());
        this.filtersHandler.setToggleLayersActionState();
    }

    private LayerAction downAction() {
        this.downAction = new LayerAction(){

            public void run() {
                LegendView.this.getCurrentMap().sendCommandASync((MapCommand)new LayerMoveDownCommand(this.structSelection));
            }
        };
        this.downAction.setEnabled(false);
        this.downAction.setToolTipText(Messages.LegendView_down_tooltip);
        this.downAction.setImageDescriptor(ProjectUIPlugin.getDefault().getImageDescriptor("elcl16/down_co.gif"));
        return this.downAction;
    }

    private LayerAction upAction() {
        this.upAction = new LayerAction(){

            public void run() {
                LegendView.this.getCurrentMap().sendCommandASync((MapCommand)new LayerMoveUpCommand(this.structSelection));
            }
        };
        this.upAction.setEnabled(false);
        this.upAction.setToolTipText(Messages.LegendView_up_tooltip);
        this.upAction.setImageDescriptor(ProjectUIPlugin.getDefault().getImageDescriptor("elcl16/up_co.gif"));
        return this.upAction;
    }

    private LayerAction moveFrontAction() {
        this.frontAction = new LayerAction(){

            public void run() {
                LegendView.this.getCurrentMap().sendCommandASync((MapCommand)new LayerMoveFrontCommand(LegendView.this.currentMap, this.structSelection));
            }
        };
        this.frontAction.setEnabled(false);
        this.frontAction.setToolTipText(Messages.LegendView_front_tooltip);
        this.frontAction.setImageDescriptor(ProjectUIPlugin.getDefault().getImageDescriptor("elcl16/front_co.gif"));
        return this.frontAction;
    }

    private LayerAction moveBackAction() {
        this.backAction = new LayerAction(){

            public void run() {
                LegendView.this.getCurrentMap().sendCommandASync((MapCommand)new LayerMoveBackCommand(LegendView.this.currentMap, this.structSelection));
            }
        };
        this.backAction.setEnabled(false);
        this.backAction.setToolTipText(Messages.LegendView_back_tooltip);
        this.backAction.setImageDescriptor(ProjectUIPlugin.getDefault().getImageDescriptor("elcl16/back_co.gif"));
        return this.backAction;
    }

    private IAction newFolderAction() {
        if (this.newFolderAction == null) {
            this.newFolderAction = new Action(){

                public void run() {
                    LegendView.this.doNewFolderAction();
                }
            };
            this.newFolderAction.setText(Messages.LegendView_new_folder_action_lbl);
            this.newFolderAction.setToolTipText(Messages.LegendView_new_folder_tooltip);
            this.newFolderAction.setImageDescriptor(ProjectUIPlugin.getDefault().getImageDescriptor("elcl16/newfolder_co.gif"));
            this.setNewFolderActionState();
        }
        return this.newFolderAction;
    }

    private void doNewFolderAction() {
        Folder folder = ProjectFactory.eINSTANCE.createFolder();
        folder.setName(Messages.LegendView_new_folder_default_lbl);
        this.currentMap.sendCommandSync((MapCommand)new AddFolderItemCommand(folder));
        this.viewer.refresh();
    }

    private void setNewFolderActionState() {
        if (this.newFolderAction != null) {
            if (this.currentMap == null) {
                this.newFolderAction.setEnabled(false);
            } else {
                this.newFolderAction.setEnabled(true);
            }
        }
    }

    private IAction renameFolderAction() {
        if (this.renameFolderAction == null) {
            this.renameFolderAction = new LegendViewRenameFolderAction((Viewer)this.viewer);
        }
        return this.renameFolderAction;
    }

    public void dispose() {
        this.disposeInternal();
        super.dispose();
    }

    public synchronized Map getCurrentMap() {
        return this.currentMap;
    }

    public synchronized void setCurrentMap(Map map) {
        this.removeCurrentMapListeners();
        this.currentMap = map;
        if (this.viewer != null) {
            this.viewer.setInput((Object)this.currentMap);
            this.gridHandler.setMap(this.currentMap);
            this.filtersHandler.setMap(this.currentMap);
            this.setNewFolderActionState();
        }
        if (this.currentMap != null) {
            this.addCurrentMapListeners();
            ILayer selectedLayer = this.currentMap.getEditManager().getSelectedLayer();
            if (selectedLayer != null && this.viewer != null) {
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)selectedLayer));
            }
            LegendViewCheckboxUtils.updateCheckboxesAsync(this);
        }
    }

    private void addCurrentMapListeners() {
        if (this.currentMap != null) {
            if (this.editManagerListener == null) {
                this.editManagerListener = new EditManagerListener();
            }
            this.editManagerListener.setCurrentMap(this.currentMap);
            if (!this.currentMap.getEditManager().containsListener((IEditManagerListener)this.editManagerListener)) {
                this.currentMap.getEditManager().addListener((IEditManagerListener)this.editManagerListener);
            }
            if (this.mapDeepListener == null) {
                this.mapDeepListener = new MapDeepListener();
            }
            this.currentMap.addDeepAdapter(this.mapDeepListener);
            this.addLegendListListener();
            if (this.mylarListener == null) {
                this.mylarListener = new BlackboardListener();
            }
            this.currentMap.getBlackboard().addListener(this.mylarListener);
            if (this.zoomListener == null) {
                this.zoomListener = new ZoomListener();
            }
            this.currentMap.getViewportModel().addViewportModelListener((IViewportModelListener)this.zoomListener);
        }
    }

    private void addLegendListListener() {
        if (this.mapDeepListener != null) {
            EObjectContainmentEList legendEObject = (EObjectContainmentEList)this.currentMap.getLegend();
            legendEObject.getEObject().eAdapters().add((Object)this.mapDeepListener);
        }
    }

    private void removeCurrentMapListeners() {
        if (this.currentMap != null) {
            IEditManager editManager = this.currentMap.getEditManager();
            if (editManager.containsListener((IEditManagerListener)this.editManagerListener)) {
                editManager.removeListener((IEditManagerListener)this.editManagerListener);
                this.editManagerListener = null;
            }
            this.currentMap.removeDeepAdapter(this.mapDeepListener);
            this.removeLegendListListener();
            this.mapDeepListener = null;
            this.currentMap.getBlackboard().removeListener(this.mylarListener);
            this.mylarListener = null;
            this.currentMap.getViewportModel().removeViewportModelListener((IViewportModelListener)this.zoomListener);
            this.zoomListener = null;
        }
    }

    private void removeLegendListListener() {
        if (this.mapDeepListener != null) {
            EObjectContainmentEList legendEObject = (EObjectContainmentEList)this.currentMap.getLegend();
            legendEObject.getEObject().eAdapters().remove((Object)this.mapDeepListener);
        }
    }

    private void setGlobalActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolManager toolManager = ApplicationGIS.getToolManager();
        toolManager.contributeGlobalActions((IWorkbenchPart)this, actionBars);
        toolManager.registerActionsWithPart((IWorkbenchPart)this);
        IKeyBindingService keyBindings = this.getSite().getKeyBindingService();
        IAction delAction = this.getDeleteAction();
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), delAction);
        keyBindings.registerAction(delAction);
    }

    public Object getAdapter(Class key) {
        if (key.equals(IPropertySheetPage.class)) {
            return ProjectUIPlugin.getDefault().getPropertySheetPage();
        }
        if (key.isAssignableFrom(IMap.class)) {
            return this.getCurrentMap();
        }
        return super.getAdapter(key);
    }

    public Object getTarget(DropTargetEvent event) {
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection structSelection = (IStructuredSelection)selection;
            Object obj = structSelection.getFirstElement();
            IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
            if (obj instanceof LayerLegendItem) {
                LayerLegendItem layerItem = (LayerLegendItem)obj;
                Layer layer = layerItem.getLayer();
                if (layer.getStatus() == 2) {
                    statusLineManager.setErrorMessage(layer.getStatusMessage());
                } else {
                    statusLineManager.setErrorMessage(null);
                    statusLineManager.setMessage(layer.getStatusMessage());
                }
            } else {
                statusLineManager.setMessage(null);
                statusLineManager.setErrorMessage(null);
            }
        }
    }

    private class BlackboardListener
    implements IBlackboardListener {
        private BlackboardListener() {
        }

        public void blackBoardChanged(BlackboardEvent event) {
            if (event.getKey() == "MYLAR" && event.getOldValue() != event.getNewValue()) {
                this.updateViewer();
            }
        }

        public void blackBoardCleared(IBlackboard source) {
            this.updateViewer();
        }

        private void updateViewer() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    LegendView.this.viewer.refresh();
                }
            };
            if (Display.getCurrent() == null) {
                Display.getDefault().asyncExec(runnable);
            } else {
                runnable.run();
            }
        }
    }

    private class CheckStateListener
    implements ICheckStateListener {
        private CheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            Object eventObj = event.getElement();
            if (eventObj instanceof ILegendItem) {
                ILegendItem item = (ILegendItem)eventObj;
                boolean isChecked = event.getChecked();
                this.setVisibilityState(item, isChecked);
                LegendViewCheckboxUtils.updateCheckboxes(LegendView.this);
            }
        }

        private void setVisibilityState(ILegendItem item, boolean isChecked) {
            if (item instanceof Folder) {
                Folder folder = (Folder)item;
                this.setVisibilityState(folder, isChecked);
            } else if (item instanceof LayerLegendItem) {
                LayerLegendItem layerItem = (LayerLegendItem)item;
                this.setVisibilityState(layerItem, isChecked);
            }
        }

        private void setVisibilityState(Folder folder, boolean isChecked) {
            for (ILegendItem item : folder.getItems()) {
                this.setVisibilityState(item, isChecked);
            }
            LegendView.this.viewer.setGrayed((Object)folder, false);
            LegendView.this.viewer.setChecked((Object)folder, isChecked);
        }

        private void setVisibilityState(LayerLegendItem layerItem, boolean isChecked) {
            Layer layer = layerItem.getLayer();
            if (layer.isVisible() != isChecked) {
                layer.setVisible(isChecked);
            }
        }
    }

    private class CollapseExpandListener
    implements ITreeViewerListener {
        private CollapseExpandListener() {
        }

        public void treeCollapsed(TreeExpansionEvent event) {
        }

        public void treeExpanded(TreeExpansionEvent event) {
            LegendViewCheckboxUtils.updateCheckboxesAsync(LegendView.this);
        }
    }

    private class EditManagerListener
    implements IEditManagerListener {
        private Map map;

        private EditManagerListener() {
        }

        private synchronized void setCurrentMap(Map currentMap) {
            this.map = currentMap;
        }

        public void changed(final EditManagerEvent event) {
            if (LegendView.this.getCurrentMap() != this.map) {
                this.map.getEditManager().removeListener((IEditManagerListener)this);
                return;
            }
            if (event.getType() == 5) {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        Object eventObj = event.getNewValue();
                        Object selection = ((IStructuredSelection)LegendView.this.viewer.getSelection()).getFirstElement();
                        if (selection != eventObj) {
                            StructuredSelection structSelection = new StructuredSelection(eventObj);
                            LegendView.this.getSite().getSelectionProvider().setSelection((ISelection)structSelection);
                        }
                        if (this.mylarOn()) {
                            LegendView.this.viewer.refresh();
                        }
                    }

                    private boolean mylarOn() {
                        Object mylarValue = EditManagerListener.this.map.getBlackboard().get("MYLAR");
                        if (mylarValue instanceof Boolean) {
                            return (Boolean)mylarValue;
                        }
                        return false;
                    }
                };
                if (Display.getCurrent() == null) {
                    Display.getDefault().asyncExec(runnable);
                } else {
                    runnable.run();
                }
            }
        }
    }

    private class LabelProviderListerner
    implements ILabelProviderListener {
        private LabelProviderListerner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void labelProviderChanged(LabelProviderChangedEvent event) {
            Map currentMap;
            LabelProviderListerner labelProviderListerner = this;
            synchronized (labelProviderListerner) {
                currentMap = LegendView.this.currentMap;
            }
            if (currentMap != null) {
                PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!PlatformUI.getWorkbench().isClosing() && LegendView.this.viewer != null) {
                            LegendView.this.viewer.refresh(true);
                        }
                    }
                });
            }
        }
    }

    private abstract class LayerAction
    extends Action
    implements ISelectionChangedListener {
        protected IStructuredSelection structSelection;

        public LayerAction() {
            LegendView.this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection selection = event.getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                this.structSelection = (IStructuredSelection)selection;
                this.setEnabled(this.isValidSelection(this.structSelection));
            }
        }

        private boolean isValidSelection(IStructuredSelection selection) {
            return selection.size() == 1 && selection.getFirstElement() instanceof LayerLegendItem;
        }
    }

    private class MapDeepListener
    extends AdapterImpl {
        private MapDeepListener() {
        }

        public void notifyChanged(Notification msg) {
            if (PlatformUI.getWorkbench().isClosing()) {
                return;
            }
            Object notifier = msg.getNotifier();
            if (notifier instanceof Map) {
                if (13 == msg.getFeatureID(Map.class)) {
                    switch (msg.getEventType()) {
                        case 3: {
                            this.addListeners(msg);
                            this.refreshOnAddAndRemove(msg);
                            break;
                        }
                        case 4: {
                            this.removeListeners(msg);
                            this.refreshOnAddAndRemove(msg);
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (notifier instanceof Folder) {
                if (3 == msg.getFeatureID(Folder.class)) {
                    switch (msg.getEventType()) {
                        case 3: {
                            this.addListeners(msg);
                            this.refreshOnAddAndRemove(msg);
                            break;
                        }
                        case 4: {
                            this.removeListeners(msg);
                            this.refreshOnAddAndRemove(msg);
                        }
                        default: {
                            break;
                        }
                    }
                }
            } else if (notifier instanceof Layer) {
                if (msg.getFeatureID(Layer.class) == 8) {
                    if (msg.getOldBooleanValue() != msg.getNewBooleanValue()) {
                        LegendViewCheckboxUtils.updateCheckboxesAsync(LegendView.this);
                    }
                } else if (msg.getFeatureID(Layer.class) == 18) {
                    this.refreshViewer();
                }
            }
        }

        private void addListeners(Notification msg) {
            if (msg.getNewValue() instanceof Folder) {
                Folder folder = (Folder)msg.getNewValue();
                folder.eAdapters().add((Object)LegendView.this.mapDeepListener);
            }
        }

        private void removeListeners(Notification msg) {
            if (msg.getOldValue() instanceof Folder) {
                Folder folder = (Folder)msg.getOldValue();
                folder.eAdapters().remove((Object)LegendView.this.mapDeepListener);
            }
        }

        private void refreshOnAddAndRemove(Notification msg) {
            LegendView.this.filtersHandler.refresh();
            LegendView.this.gridHandler.refresh(msg);
            Object notifier = msg.getNotifier();
            if (notifier instanceof Folder) {
                Folder folder = (Folder)msg.getNotifier();
                this.refreshViewer(folder);
            } else if (notifier instanceof Map) {
                this.refreshViewer();
            }
        }

        private void refreshViewer() {
            this.refreshViewer(null);
        }

        private void refreshViewer(Folder folder) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    LegendView.this.viewer.refresh();
                    LegendViewCheckboxUtils.updateCheckboxes(LegendView.this);
                }
            };
            if (Display.getCurrent() == null) {
                Display.getDefault().asyncExec(run);
            } else {
                run.run();
            }
        }
    }

    private class MapEditorListener
    implements IPartListener {
        private IWorkbenchPart currentPart;

        private MapEditorListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            IWorkbenchPart adaptable;
            Object obj;
            if (part != this.currentPart && part instanceof IAdaptable && (obj = (adaptable = part).getAdapter(Map.class)) instanceof Map) {
                this.currentPart = part;
                LegendView.this.setCurrentMap((Map)obj);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
            this.partActivated(part);
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == this) {
                LegendView.this.disposeInternal();
                return;
            }
            if (part == this.currentPart) {
                this.currentPart = null;
                LegendView.this.setCurrentMap(null);
                LegendView.this.viewer.refresh(true);
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    private class ZoomListener
    implements IViewportModelListener {
        private ZoomListener() {
        }

        public void changed(ViewportModelEvent event) {
            LegendView.this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    LegendView.this.viewer.refresh();
                }
            });
        }
    }
}

