/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

public class LayerStatusDecorator
implements ILightweightLabelDecorator {
    private final Map<ILayer, Integer> currentlyDisplayedStatus = Collections.synchronizedMap(new WeakHashMap());
    private final Set<ILabelProviderListener> listeners = new CopyOnWriteArraySet<ILabelProviderListener>();
    private Adapter hack = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            if (msg.getNotifier() instanceof Layer) {
                Layer layer = (Layer)msg.getNotifier();
                if (LayerStatusDecorator.this.hack == null) {
                    layer.eAdapters().remove((Object)this);
                    return;
                }
                if (msg.getFeatureID(Layer.class) != 4) {
                    return;
                }
                Integer integer = (Integer)LayerStatusDecorator.this.currentlyDisplayedStatus.get(layer);
                if (integer != null && msg.getNewIntValue() == integer.intValue()) {
                    return;
                }
                LayerStatusDecorator.this.refresh(layer);
            }
        }
    };

    void refresh(Layer layer) {
        if (this.listeners.isEmpty()) {
            return;
        }
        LabelProviderChangedEvent event = new LabelProviderChangedEvent((IBaseLabelProvider)this, (Object)layer);
        for (ILabelProviderListener listener : this.listeners) {
            listener.labelProviderChanged(event);
        }
    }

    public synchronized void decorate(Object element, IDecoration decoration) {
        Layer layer = (Layer)element;
        ImageDescriptor ovr = this.statusIcon(layer);
        if (ovr != null) {
            decoration.addOverlay(ovr, 2);
        }
        if (!layer.eAdapters().contains((Object)this.hack)) {
            layer.eAdapters().add((Object)this.hack);
        }
    }

    private ImageDescriptor statusIcon(Layer layer) {
        this.currentlyDisplayedStatus.put((ILayer)layer, layer.getStatus());
        switch (layer.getStatus()) {
            case 4: {
                return ProjectUIPlugin.getDefault().getImageDescriptor("ovr16/warning_ovr.gif");
            }
            case 2: {
                return ProjectUIPlugin.getDefault().getImageDescriptor("ovr16/error_ovr.gif");
            }
            case -1: {
                return ProjectUIPlugin.getDefault().getImageDescriptor("ovr16/huh_ovr.gif");
            }
            case -2: {
                return ProjectUIPlugin.getDefault().getImageDescriptor("ovr16/unconfigured_ovr.gif");
            }
            case 1: {
                return ProjectUIPlugin.getDefault().getImageDescriptor("ovr16/wait_ovr.gif");
            }
            case 5: {
                return ProjectUIPlugin.getDefault().getImageDescriptor("ovr16/clock0_ovr.gif");
            }
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
        this.listeners.clear();
        this.hack = null;
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }
}

