/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.project.ui.IUDIGDialogPage;
import net.refractions.udig.project.ui.IUDIGView;
import net.refractions.udig.project.ui.internal.FeatureEditorExtensionProcessor;
import net.refractions.udig.project.ui.internal.FeatureTypeMatch;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.tool.ToolContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.opengis.feature.simple.SimpleFeature;

public class FeatureEditorLoader {
    final FeatureEditorExtensionProcessor processor;
    private String dialogPage;
    String viewId;
    private String name;
    String id;
    ImageDescriptor icon;
    IAction contribution;
    private IConfigurationElement definition;
    private FeatureTypeMatch featureTypeMatcher;

    FeatureEditorLoader(FeatureEditorExtensionProcessor processor, IConfigurationElement definition) {
        this.processor = processor;
        String iconID = definition.getAttribute("icon");
        if (iconID != null) {
            this.icon = AbstractUIPlugin.imageDescriptorFromPlugin((String)definition.getNamespaceIdentifier(), (String)iconID);
        }
        this.id = definition.getAttribute("id");
        this.name = definition.getAttribute("name");
        this.viewId = definition.getAttribute("viewId");
        this.dialogPage = definition.getAttribute("dialogPage");
        this.definition = definition;
        IConfigurationElement[] featureTypeDef = definition.getChildren("featureType");
        this.featureTypeMatcher = featureTypeDef.length == 1 ? new FeatureTypeMatch(featureTypeDef[0]) : FeatureTypeMatch.ALL;
    }

    IAction getAction(final ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (!this.processor.sameFeatureTypes(structuredSelection)) {
            return null;
        }
        final SimpleFeature feature = (SimpleFeature)structuredSelection.getFirstElement();
        if (this.featureTypeMatcher.matches(feature) == -1) {
            return null;
        }
        this.contribution = new Action(this.name, 8){

            public void runWithEvent(Event event) {
                if (FeatureEditorLoader.this.contribution.isChecked()) {
                    FeatureEditorLoader.this.processor.createEditAction(FeatureEditorLoader.this, selection, feature);
                    FeatureEditorLoader.this.open(event.display, selection);
                }
            }
        };
        this.contribution.setId(this.id);
        this.contribution.setImageDescriptor(this.icon);
        FeatureEditorExtensionProcessor.EditActionContribution selected = this.processor.selectedEditors.get(feature.getFeatureType());
        if (selected == null) {
            selected = this.processor.createEditAction(this.processor.getClosestMatch(selection), selection, feature);
        } else {
            selected.setSelection(selection);
        }
        if (selected != null && selected.getId().equals(this.id)) {
            this.contribution.setChecked(true);
        } else {
            this.contribution.setChecked(false);
        }
        return this.contribution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(Display display, ISelection selection) {
        SimpleFeature feature = (SimpleFeature)((IStructuredSelection)selection).getFirstElement();
        if (this.viewId != null) {
            try {
                IUDIGView view = (IUDIGView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(this.viewId, null, 2);
                try {
                    view.editFeatureChanged(feature);
                }
                catch (Throwable e) {
                    UiPlugin.log((String)(view + " threw an exception"), (Throwable)e);
                }
            }
            catch (PartInitException e) {
                ProjectUIPlugin.log(null, e);
            }
        } else if (this.dialogPage != null) {
            try {
                ToolContext toolContext;
                IUDIGDialogPage page = (IUDIGDialogPage)this.definition.createExecutableExtension("dialogPage");
                FeatureEditorExtensionProcessor.FeatureEditorViewpartListener featureEditorViewpartListener = this.processor.partListener;
                synchronized (featureEditorViewpartListener) {
                    toolContext = this.processor.partListener.currentContext;
                }
                page.setContext(toolContext);
                FeatureEditorExtensionProcessor.EditorDialog dialog = new FeatureEditorExtensionProcessor.EditorDialog(new Shell(display.getActiveShell(), 32784), page);
                dialog.setBlockOnOpen(false);
                page.setFeature(feature);
                dialog.open();
                PlatformUI.getPreferenceStore().putValue("FeatureEditorCurrentLoader", this.id);
            }
            catch (CoreException e) {
                ProjectUIPlugin.log(null, e);
            }
        }
    }

    public int match(ISelection selection) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (!this.processor.sameFeatureTypes(structuredSelection)) {
            return -1;
        }
        SimpleFeature feature = (SimpleFeature)structuredSelection.getFirstElement();
        return this.featureTypeMatcher.matches(feature);
    }

    public String getDialogPage() {
        return this.dialogPage;
    }

    public String getName() {
        return this.name;
    }

    public String getViewId() {
        return this.viewId;
    }

    public String getId() {
        return this.id;
    }
}

