/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.command.navigation.SetViewportBBoxCommand;
import net.refractions.udig.project.internal.commands.ChangeCRSCommand;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.commands.SetLayerCRSCommand;
import net.refractions.udig.ui.CRSChooser;
import net.refractions.udig.ui.Controller;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CRSPropertyPage
extends PropertyPage {
    CRSChooser chooser = new CRSChooser(new Controller(){

        public void handleClose() {
            CRSPropertyPage.this.getControl().getShell().close();
        }

        public void handleOk() {
            CRSPropertyPage.this.performOk();
        }
    });
    private ApplyCRSStrategy strategy;

    public CRSPropertyPage() {
        this.setTitle(Messages.CRSPropertyPage_coordinateSystems_title);
    }

    public void setStrategy(ApplyCRSStrategy strategy) {
        this.strategy = strategy;
    }

    public boolean performOk() {
        CoordinateReferenceSystem crs = this.chooser.getCRS();
        if (crs == null) {
            return false;
        }
        if (crs.equals(this.strategy.getCurrentCoordinateReferenceSystem())) {
            return true;
        }
        this.strategy.applyCoordinateReferenceSystem(crs);
        return super.performOk();
    }

    protected void performDefaults() {
        this.chooser.clearSearch();
        this.chooser.gotoCRS(this.strategy.getCurrentCoordinateReferenceSystem());
    }

    public IPreferenceStore getPreferenceStore() {
        return ProjectPlugin.getPlugin().getPreferenceStore();
    }

    protected Control createContents(Composite parent) {
        CoordinateReferenceSystem crs = null;
        crs = this.strategy.getCurrentCoordinateReferenceSystem();
        Control control = crs == null ? this.chooser.createControl(parent) : this.chooser.createControl(parent, crs);
        this.chooser.setFocus();
        return control;
    }

    protected Point doComputeSize() {
        return new Point(200, 300);
    }

    public void init(IWorkbench workbench) {
    }

    public static interface ApplyCRSStrategy {
        public void applyCoordinateReferenceSystem(CoordinateReferenceSystem var1);

        public CoordinateReferenceSystem getCurrentCoordinateReferenceSystem();
    }

    public static class LayerStrategy
    implements ApplyCRSStrategy {
        private static final String SHOW_DIALOG_KEY = "SHOW_DIALOG_WHEN_UPDATE_LAYER_CRS_KEY";
        private static final String UPDATE_MAP_CRS_KEY = "UPDATE_MAP_CRS_WHEN_UNKOWN_IS_CHANGED";
        Layer layer;

        public LayerStrategy(Layer layer) {
            this.layer = layer;
        }

        @Override
        public void applyCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
            UndoableComposite commands = new UndoableComposite();
            List commandList = commands.getCommands();
            commandList.add(new SetLayerCRSCommand((ILayer)this.layer, crs));
            if (this.layer.getCRS() == ILayer.UNKNOWN_CRS && this.layer.getMap().getViewportModel().getCRS().equals(ILayer.UNKNOWN_CRS)) {
                boolean updateMapCRS;
                IPreferenceStore store = ProjectUIPlugin.getDefault().getPreferenceStore();
                store.setDefault(SHOW_DIALOG_KEY, true);
                boolean openDialog = store.getBoolean(SHOW_DIALOG_KEY);
                if (openDialog) {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)Messages.CRSPropertyPage_title, (String)Messages.CRSPropertyPage_message, (String)Messages.CRSPropertyPage_toggle_message, (boolean)false, (IPreferenceStore)store, (String)SHOW_DIALOG_KEY);
                    int returnCode = dialog.getReturnCode();
                    updateMapCRS = returnCode == 2;
                    store.setValue(UPDATE_MAP_CRS_KEY, updateMapCRS);
                } else {
                    updateMapCRS = store.getBoolean(UPDATE_MAP_CRS_KEY);
                }
                if (updateMapCRS) {
                    commandList.add(new ChangeCRSCommand(crs));
                    commandList.add(new SetViewportBBoxCommand(this.layer.getBounds((IProgressMonitor)new NullProgressMonitor(), crs)));
                }
            }
            this.layer.getMap().sendCommandASync((MapCommand)commands);
        }

        @Override
        public CoordinateReferenceSystem getCurrentCoordinateReferenceSystem() {
            return this.layer.getCRS();
        }
    }

    public static class MapStrategy
    implements ApplyCRSStrategy {
        Map map;

        public MapStrategy(Map map) {
            this.map = map;
        }

        @Override
        public void applyCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
            this.map.sendCommandASync((MapCommand)new ChangeCRSCommand(crs));
        }

        @Override
        public CoordinateReferenceSystem getCurrentCoordinateReferenceSystem() {
            return this.map.getViewportModel().getCRS();
        }
    }
}

