/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.UDIGEditorInput;
import net.refractions.udig.project.ui.internal.FeatureEditorLoader;
import net.refractions.udig.project.ui.internal.MapEditorPart;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.tool.ToolContext;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.opengis.feature.simple.SimpleFeature;

public class ApplicationGISInternal {
    public static ToolContext createContext(IMap map) {
        return (ToolContext)ApplicationGIS.createContext(map);
    }

    public static Project getActiveProject() {
        return (Project)ApplicationGIS.getActiveProject();
    }

    public static List<? extends Project> getProjects() {
        return Collections.unmodifiableList(ProjectPlugin.getPlugin().getProjectRegistry().getProjects());
    }

    public static Map getActiveMap() {
        return (Map)ApplicationGIS.getActiveMap();
    }

    public static Collection<? extends Map> getOpenMaps() {
        return ApplicationGIS.getOpenMaps();
    }

    public static FeatureEditorLoader getFeatureEditorLoader(SimpleFeature feature) {
        if (feature == null) {
            return null;
        }
        return ProjectUIPlugin.getDefault().getFeatureEditProcessor().getClosestMatch((ISelection)new StructuredSelection((Object)feature));
    }

    public static MapEditorPart getActiveEditor() {
        try {
            final ArrayList editor = new ArrayList();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        IEditorReference[] refs = window.getActivePage().getEditorReferences();
                        IMap map = ApplicationGIS.getActiveMap();
                        IEditorReference[] iEditorReferenceArray = refs;
                        int n = refs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            UDIGEditorInput in;
                            IEditorReference ref = iEditorReferenceArray[n2];
                            IEditorInput input = ref.getEditorInput();
                            if (input instanceof UDIGEditorInput && (in = (UDIGEditorInput)input).getProjectElement() == map) {
                                editor.add(ref.getEditor(false));
                                break;
                            }
                            ++n2;
                        }
                    }
                    catch (Throwable throwable) {}
                }
            };
            PlatformGIS.syncInDisplayThread((Runnable)runnable);
            if (!editor.isEmpty() && editor.get(0) instanceof MapEditorPart) {
                return (MapEditorPart)editor.get(0);
            }
        }
        catch (Exception exception) {
            return null;
        }
        return null;
    }

    public static MapEditorPart findMapEditor(final IMap map) {
        if (map == null) {
            throw new NullPointerException("Map cannot be null");
        }
        final MapEditorPart[] result = new MapEditorPart[1];
        PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                IEditorReference[] refs;
                IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (win == null) {
                    return;
                }
                IWorkbenchPage page = win.getActivePage();
                if (page == null) {
                    return;
                }
                IEditorReference[] iEditorReferenceArray = refs = page.getEditorReferences();
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    MapEditorPart me;
                    IEditorReference reference = iEditorReferenceArray[n2];
                    IEditorPart e = reference.getEditor(false);
                    if (e instanceof MapEditorPart && map.equals((me = (MapEditorPart)e).getMap())) {
                        result[0] = me;
                        return;
                    }
                    ++n2;
                }
            }
        });
        return result[0];
    }
}

