/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.MapPart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ActiveMapTracker
implements IPartListener2,
IWindowListener,
IPageListener {
    private List<MapPart> activeParts = new CopyOnWriteArrayList<MapPart>();
    private Set<MapPart> visibleMaps = new CopyOnWriteArraySet<MapPart>();
    private Set<MapPart> openMaps = new CopyOnWriteArraySet<MapPart>();

    public Collection<? extends IMap> getVisibleMaps() {
        HashSet<Map> maps = new HashSet<Map>();
        for (MapPart part : this.visibleMaps) {
            maps.add(part.getMap());
        }
        return Collections.unmodifiableCollection(maps);
    }

    public Map getActiveMap() {
        MapPart part;
        if (Display.getCurrent() != null && (part = this.getActivePart()) != null && !this.activeParts.isEmpty() && part != this.activeParts.get(0)) {
            this.addActivePart(part);
            return part.getMap();
        }
        MapPart mapPart = null;
        if (!this.activeParts.isEmpty()) {
            mapPart = this.activeParts.get(0);
        }
        if (mapPart == null) {
            for (MapPart part2 : this.openMaps) {
                if (!this.visibleMaps.contains(part2)) continue;
                mapPart = part2;
                break;
            }
        }
        if (mapPart == null) {
            return ApplicationGIS.NO_MAP;
        }
        return mapPart.getMap();
    }

    private MapPart getActivePart() {
        IWorkbenchPart part;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        if (page != null && (part = page.getActivePart()) instanceof MapPart) {
            return (MapPart)part;
        }
        return null;
    }

    public Collection<? extends IMap> getOpenMaps() {
        HashSet<Map> maps = new HashSet<Map>();
        for (MapPart part : this.openMaps) {
            maps.add(part.getMap());
        }
        return Collections.unmodifiableCollection(maps);
    }

    public void startup() {
        IWorkbenchWindow[] windows;
        ApplicationGIS.setActiveMapTracker(this);
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.addWindowListener((IWindowListener)this);
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = workbench.getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
            this.windowOpened(workbenchWindow);
            ++n2;
        }
    }

    private void addActivePart(MapPart part) {
        while (this.activeParts.remove(part)) {
        }
        this.activeParts.add(0, part);
    }

    private void removePart(IWorkbenchPart part) {
        while (this.activeParts.remove(part)) {
        }
        this.visibleMaps.remove(part);
        this.openMaps.remove(part);
    }

    private boolean addOpenMap(IWorkbenchPart part) {
        return this.openMaps.add((MapPart)part);
    }

    public void windowClosed(IWorkbenchWindow window) {
        IWorkbenchPage[] pages;
        IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage workbenchPage = iWorkbenchPageArray[n2];
            workbenchPage.removePartListener((IPartListener2)this);
            ++n2;
        }
        window.removePageListener((IPageListener)this);
    }

    public void windowOpened(IWorkbenchWindow window) {
        IWorkbenchPage[] pages;
        IWorkbenchPage[] iWorkbenchPageArray = pages = window.getPages();
        int n = pages.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPage workbenchPage = iWorkbenchPageArray[n2];
            this.pageOpened(workbenchPage);
            ++n2;
        }
        window.addPageListener((IPageListener)this);
    }

    public void pageClosed(IWorkbenchPage page) {
        page.removePartListener((IPartListener2)this);
    }

    public void pageOpened(IWorkbenchPage page) {
        IViewReference[] views;
        IEditorReference[] editors;
        page.addPartListener((IPartListener2)this);
        IEditorReference[] iEditorReferenceArray = editors = page.getEditorReferences();
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference reference = iEditorReferenceArray[n2];
            IWorkbenchPart workpart = reference.getPart(false);
            if (reference.getPart(false) instanceof MapPart) {
                MapPart part = (MapPart)reference.getPart(false);
                this.openMaps.add(part);
                if (page.isPartVisible(workpart)) {
                    this.visibleMaps.add(part);
                }
            }
            ++n2;
        }
        IViewReference[] iViewReferenceArray = views = page.getViewReferences();
        int n3 = views.length;
        n = 0;
        while (n < n3) {
            IViewReference reference = iViewReferenceArray[n];
            IWorkbenchPart workpart = reference.getPart(false);
            if (workpart instanceof MapPart) {
                MapPart part = (MapPart)reference.getPart(false);
                this.openMaps.add(part);
                if (page.isPartVisible(workpart)) {
                    this.visibleMaps.add(part);
                }
            }
            ++n;
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof MapPart) {
            this.addActivePart((MapPart)part);
        }
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        this.removePart(part);
    }

    public void partVisible(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof MapPart) {
            this.visibleMaps.add((MapPart)part);
            if (this.activeParts.isEmpty()) {
                this.activeParts.add((MapPart)part);
            }
        }
    }

    public void partHidden(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof MapPart) {
            this.visibleMaps.remove(part);
        }
    }

    public void partOpened(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part instanceof MapPart) {
            this.addOpenMap(part);
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void pageActivated(IWorkbenchPage page) {
    }
}

