/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.feature;

import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.ui.IFeaturePanel;
import net.refractions.udig.project.ui.IFeaturePanelCheck;
import net.refractions.udig.project.ui.IFeatureSite;
import net.refractions.udig.project.ui.internal.FeatureTypeMatch;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;

public class FeaturePanelEntry {
    private final String PLUGIN_ID;
    private String EXTENSION_ID;
    private String id;
    private String name;
    private String title;
    private String description;
    private String afterPanel;
    private IConfigurationElement definition;
    private boolean indented;
    private FeatureTypeMatch matcher;
    private String category;
    private IFeaturePanelCheck check;
    private ILabelProvider labelProvider;

    public FeaturePanelEntry(IExtension extension, IConfigurationElement definition) {
        this.PLUGIN_ID = definition.getDeclaringExtension().getNamespaceIdentifier();
        this.EXTENSION_ID = extension.getUniqueIdentifier() == null ? "" : "(" + extension.getUniqueIdentifier() + ")";
        this.definition = definition;
        this.id = definition.getAttribute("id");
        this.name = definition.getAttribute("name");
        this.title = definition.getAttribute("title");
        this.description = definition.getAttribute("description");
        this.definition = definition;
        IConfigurationElement[] featureTypeDefinition = definition.getChildren("featureType");
        this.matcher = featureTypeDefinition.length == 1 ? new FeatureTypeMatch(featureTypeDefinition[0]) : FeatureTypeMatch.ALL;
        if (definition.getAttribute("labelProvider") != null) {
            try {
                this.labelProvider = (ILabelProvider)definition.createExecutableExtension("labelProvider");
            }
            catch (CoreException e) {
                String target = definition.getAttribute("panel");
                this.log("Could not create feature label provider" + target, e);
            }
        }
        this.indented = false;
        this.category = null;
    }

    public boolean isChecked(IFeatureSite site) {
        if (site == null) {
            return false;
        }
        if (this.check == null) {
            if (this.definition.getAttribute("check") == null) {
                this.check = IFeaturePanelCheck.NONE;
            } else {
                try {
                    this.check = (IFeaturePanelCheck)this.definition.createExecutableExtension("check");
                }
                catch (CoreException coreException) {
                    this.check = IFeaturePanelCheck.NONE;
                }
            }
        }
        return this.check.check(site);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTitle() {
        if (this.title == null || this.title.length() == 0) {
            return this.getName();
        }
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAfterPanel() {
        return this.afterPanel;
    }

    public boolean isMatch(Object element) {
        return this.matcher.isMatch(element);
    }

    public boolean isIndented() {
        return this.indented;
    }

    public String getCategory() {
        return this.category;
    }

    public IFeaturePanel createFeaturePanel() {
        try {
            return (IFeaturePanel)this.definition.createExecutableExtension("panel");
        }
        catch (CoreException e) {
            String target = this.definition.getAttribute("panel");
            this.log("Could not create feature " + target, e);
            return null;
        }
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public void log(String message, Throwable t) {
        Status error = new Status(4, this.PLUGIN_ID, String.valueOf(message) + this.EXTENSION_ID, t);
        ProjectPlugin.getPlugin().getLog().log((IStatus)error);
    }

    public Image getImage() {
        return null;
    }
}

