/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.feature;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.refractions.udig.project.IEditManager;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.internal.commands.edit.SetAttributeCommand;
import net.refractions.udig.project.internal.commands.edit.SetAttributesCommand;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.geotools.feature.DecoratingFeature;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.IllegalAttributeException;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;

public class EditFeature
extends DecoratingFeature
implements IAdaptable,
SimpleFeature {
    private IEditManager manager;
    private Set<String> dirty = new LinkedHashSet<String>();
    private boolean batch;

    public EditFeature(IEditManager manager) {
        super(manager.getEditFeature());
        this.manager = manager;
    }

    public EditFeature(IEditManager manager, SimpleFeature feature) {
        super(feature);
        this.manager = manager;
    }

    public Object getAdapter(Class adapter) {
        if (IEditManager.class.isAssignableFrom(adapter) && this.manager != null) {
            return this.manager;
        }
        if (ILayer.class.isAssignableFrom(adapter) && this.manager != null) {
            return this.manager.getEditLayer();
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public void setAttribute(int index, Object value) {
        SimpleFeatureType schema = this.getFeatureType();
        AttributeDescriptor attribute = (AttributeDescriptor)schema.getAttributeDescriptors().get(index);
        String name = attribute.getLocalName();
        SetAttributeCommand sync = new SetAttributeCommand(name, value);
        this.dirty.add(name);
        this.manager.getMap().sendCommandASync((MapCommand)sync);
    }

    public void setAttribute(Name name, Object value) {
        SetAttributeCommand sync = new SetAttributeCommand(name.getLocalPart(), value);
        this.dirty.add(name.getLocalPart());
        this.manager.getMap().sendCommandASync((MapCommand)sync);
    }

    public void setAttribute(String path, Object value) {
        SetAttributeCommand sync = new SetAttributeCommand(path, value);
        this.dirty.add(path);
        this.manager.getMap().sendCommandASync((MapCommand)sync);
    }

    public void setAttributes(List<Object> values) {
        ArrayList<String> xpathlist = new ArrayList<String>();
        SimpleFeatureType schema = this.getFeatureType();
        for (PropertyDescriptor x : schema.getDescriptors()) {
            xpathlist.add(x.getName().getLocalPart());
            this.dirty.add(x.getName().getLocalPart());
        }
        String[] xpath = xpathlist.toArray(new String[xpathlist.size()]);
        Object[] value = values.toArray();
        SetAttributesCommand sync = new SetAttributesCommand(xpath, value);
        this.manager.getMap().sendCommandASync((MapCommand)sync);
    }

    public void setAttributes(Object[] values) {
        ArrayList<String> xpathlist = new ArrayList<String>();
        SimpleFeatureType schema = this.getFeatureType();
        for (PropertyDescriptor x : schema.getDescriptors()) {
            xpathlist.add(x.getName().getLocalPart());
        }
        this.dirty.addAll(xpathlist);
        String[] xpath = xpathlist.toArray(new String[xpathlist.size()]);
        SetAttributesCommand sync = new SetAttributesCommand(xpath, values);
        this.manager.getMap().sendCommandASync((MapCommand)sync);
    }

    public void setDefaultGeometry(Object geometry) {
        GeometryDescriptor geometryDescriptor = this.getFeatureType().getGeometryDescriptor();
        this.setAttribute(geometryDescriptor.getName(), geometry);
    }

    public void setDefaultGeometryProperty(GeometryAttribute geometryAttribute) {
        if (geometryAttribute != null) {
            this.setDefaultGeometry(geometryAttribute.getValue());
        } else {
            this.setDefaultGeometry(null);
        }
    }

    public void setValue(Collection<Property> values) {
        throw new UnsupportedOperationException();
    }

    public void setValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public void setDefaultGeometry(Geometry geometry) throws IllegalAttributeException {
        GeometryDescriptor geometryDescriptor = this.getFeatureType().getGeometryDescriptor();
        this.setAttribute(geometryDescriptor.getName(), (Object)geometry);
    }

    public void setBatch(boolean batch) {
        this.batch = batch;
    }
}

