/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.controls;

import java.text.NumberFormat;
import java.util.Iterator;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.internal.commands.SetScaleCommand;
import net.refractions.udig.project.render.IViewportModel;
import net.refractions.udig.project.render.IViewportModelListener;
import net.refractions.udig.project.render.ViewportModelEvent;
import net.refractions.udig.project.ui.internal.MapEditorPart;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.ui.ZoomingDialog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ScaleRatioLabel
extends ContributionItem
implements KeyListener,
FocusListener {
    public static final int STATUS_LINE_HEIGHT = Platform.getWS().equals("win32") ? 24 : 32;
    private final MapEditorPart mapPart;
    public static final String SCALE_ITEM_ID = "Current scale";
    NumberFormat nf = NumberFormat.getIntegerInstance();
    Combo combo;
    IViewportModel viewportModel;
    IViewportModelListener listener = new IViewportModelListener(){

        public void changed(ViewportModelEvent event) {
            if (event.getType() == ViewportModelEvent.EventType.CRS || event.getType() == ViewportModelEvent.EventType.BOUNDS) {
                Display display = PlatformUI.getWorkbench().getDisplay();
                if (display == null) {
                    display = Display.getDefault();
                }
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ScaleRatioLabel.this.updateScale();
                    }
                });
            }
        }
    };

    public ScaleRatioLabel(MapEditorPart editor) {
        super(SCALE_ITEM_ID);
        this.mapPart = editor;
    }

    public void setViewportModel(IViewportModel newViewportModel) {
        if (newViewportModel != this.viewportModel) {
            if (this.viewportModel != null) {
                this.viewportModel.removeViewportModelListener(this.listener);
            }
            this.viewportModel = newViewportModel;
            this.viewportModel.addViewportModelListener(this.listener);
            this.updateScale();
        }
    }

    public boolean isDynamic() {
        return true;
    }

    public void dispose() {
        if (this.combo != null) {
            this.combo.dispose();
        }
        if (this.viewportModel != null) {
            this.viewportModel.removeViewportModelListener(this.listener);
            this.viewportModel = null;
        }
    }

    public void fill(Composite c) {
        Label separator = new Label(c, 2);
        StatusLineLayoutData data = new StatusLineLayoutData();
        separator.setLayoutData((Object)data);
        data.widthHint = 1;
        data.heightHint = STATUS_LINE_HEIGHT;
        this.combo = new Combo(c, 0x1000800);
        this.combo.addKeyListener((KeyListener)this);
        this.combo.addFocusListener((FocusListener)this);
        this.combo.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                if (ScaleRatioLabel.this.combo.getText().contains(":")) {
                    ScaleRatioLabel.this.formatForEditing();
                }
            }
        });
        this.combo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ScaleRatioLabel.this.combo.getText().contains(":")) {
                    ScaleRatioLabel.this.formatForEditing();
                }
                ScaleRatioLabel.this.go();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        data = new StatusLineLayoutData();
        this.combo.setLayoutData((Object)data);
        this.updateScale();
        data.widthHint = 80;
        data.heightHint = STATUS_LINE_HEIGHT;
        this.mapPart.setFont((Control)this.combo);
    }

    public void keyPressed(KeyEvent e) {
        if (this.combo.getText().contains(":")) {
            this.formatForEditing();
        }
        if (!this.isLegalKey(e)) {
            e.doit = false;
        }
    }

    public boolean isLegalKey(KeyEvent e) {
        char c = e.character;
        if (c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9' || c == '\u007f' || c == '\b') {
            return true;
        }
        return e.keyCode == 0x1000003 || e.keyCode == 0x1000004 || e.keyCode == 0x1000007 || e.keyCode == 0x1000008 || e.keyCode == 32;
    }

    public void keyReleased(KeyEvent e) {
        if (e.character == '\r') {
            this.go();
        } else if (e.character == '\u001b') {
            this.updateScale();
        }
    }

    private void go() {
        String newScale = this.combo.getText().trim();
        try {
            double d = this.nf.parse(newScale.replace(" ", "")).doubleValue();
            SetScaleCommand command = new SetScaleCommand(d);
            this.mapPart.getMap().sendCommandASync((MapCommand)command);
        }
        catch (Exception exception) {
            Rectangle start = ZoomingDialog.calculateBounds((Control)this.combo);
            ZoomingDialog.openErrorMessage((Rectangle)start, (Shell)this.mapPart.getMapEditorSite().getShell(), (String)Messages.MapEditor_illegalScaleTitle, (String)Messages.MapEditor_illegalScaleMessage);
        }
    }

    public void focusGained(FocusEvent e) {
        this.formatForEditing();
    }

    private void formatForEditing() {
        String text = this.combo.getText();
        if (text.contains(":")) {
            text = text.substring(2);
        }
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c != ',') {
                builder.append(c);
            }
            ++i;
        }
        this.combo.setText(builder.toString());
        int end = this.combo.getText().length();
        this.combo.setSelection(new Point(0, end));
    }

    public void focusLost(FocusEvent e) {
        this.updateScale();
    }

    String toLabel(double scaleDenominator) {
        return "1:" + this.nf.format(scaleDenominator);
    }

    private void updateScale() {
        if (this.combo == null || this.combo.isDisposed()) {
            return;
        }
        if (this.viewportModel != null) {
            this.combo.removeAll();
            Iterator iterator = this.viewportModel.getPreferredScaleDenominators().iterator();
            while (iterator.hasNext()) {
                double scaleDenominator = (Double)iterator.next();
                String item = this.toLabel(scaleDenominator);
                this.combo.add(item);
            }
            this.combo.setText(this.toLabel(this.viewportModel.getScaleDenominator()));
            this.combo.setToolTipText(this.combo.getText());
        } else {
            this.combo.setText("");
        }
    }
}

