/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.controls;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.part.PageBook;
import org.geotools.data.DataUtilities;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.SchemaException;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class FeatureTableControl {
    private int pageSize = 10;
    private FeatureIterator<SimpleFeature> fReader;
    SimpleFeatureType fType;
    private List<SimpleFeature> features;
    private TableViewer tableViewer;
    private Table table;
    private FeatureCollection<SimpleFeatureType, SimpleFeature> results;
    private PageBook control;

    public FeatureTableControl() {
        this.clear();
    }

    public FeatureTableControl(DefaultFeatureCollection features) {
        this.setFeatures((FeatureCollection<SimpleFeatureType, SimpleFeature>)features);
    }

    public FeatureTableControl(FeatureIterator<SimpleFeature> fReader) {
        this(fReader, 10);
    }

    public FeatureTableControl(FeatureIterator<SimpleFeature> fReader, int resPerPage) {
        this.fType = null;
        this.fReader = fReader;
        this.pageSize = resPerPage;
        this.features = new ArrayList<SimpleFeature>();
        this.next();
    }

    public void setPageSize(int resPerPage) {
        this.pageSize = resPerPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public Control getControl() {
        return this.control;
    }

    public void createTableControl(Composite parent) {
        this.control = new PageBook(parent, 0);
        this.createTableViewer((Composite)this.control);
    }

    public void next() {
        if (this.fReader != null) {
            this.nextInternal();
        }
    }

    protected void nextInternal() {
        this.features.clear();
        try {
            int i = 0;
            while (i < this.pageSize && this.fReader.hasNext()) {
                this.features.add((SimpleFeature)this.fReader.next());
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update() {
        this.updateTable();
        this.tableViewer.setInput(this.features);
    }

    protected void updateTable() {
        this.table = this.tableViewer.getTable();
        TableColumn tableColumn = this.table.getColumnCount() > 0 ? this.table.getColumn(0) : new TableColumn(this.table, 0x1000800);
        tableColumn.setText("FID");
        tableColumn.setWidth(100);
        if (this.fType != null) {
            int i = 0;
            while (i < this.fType.getAttributeCount()) {
                AttributeDescriptor aType = this.fType.getDescriptor(i);
                tableColumn = this.table.getColumnCount() > i + 1 ? this.table.getColumn(i + 1) : new TableColumn(this.table, 0x1000800);
                tableColumn.setText(aType.getLocalName());
                tableColumn.setWidth(100);
                ++i;
            }
            i = this.fType.getAttributeCount() + 1;
            while (i < this.table.getColumnCount()) {
                tableColumn = this.table.getColumn(i);
                tableColumn.dispose();
                ++i;
            }
        }
    }

    protected void createTableViewer(Composite parent) {
        int style = 2;
        this.table = new Table(parent, style);
        this.table.setHeaderVisible(true);
        FeatureTableProvider ftp = new FeatureTableProvider();
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)ftp);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)ftp);
        this.tableViewer.setInput(this.features);
        this.control.showPage(this.tableViewer.getControl());
        this.updateTable();
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void setFocus() {
    }

    public List<SimpleFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(FeatureIterator<SimpleFeature> reader) {
        this.fReader = reader;
        this.fType = null;
        this.features = new ArrayList<SimpleFeature>();
        this.next();
        this.update();
    }

    public void setFeatures(List<SimpleFeature> features) {
        this.features = features;
        this.fType = features.size() != 0 ? features.get(0).getFeatureType() : null;
        this.fReader = null;
        this.update();
    }

    public void setFeatures(FeatureCollection<SimpleFeatureType, SimpleFeature> results) {
        this.results = results;
        this.reset();
        this.update();
    }

    public void reset() {
        int count = this.pageSize + 1;
        count = this.results.size();
        if (count < this.pageSize) {
            List list = DataUtilities.list(this.results);
            this.setFeatures(list);
        } else {
            this.setFeatures((FeatureIterator<SimpleFeature>)this.results.features());
        }
    }

    public void clear() {
        this.features = new ArrayList<SimpleFeature>();
        try {
            this.fType = DataUtilities.createType((String)"empty", (String)"message:String");
        }
        catch (SchemaException schemaException) {}
        this.fReader = null;
        this.results = null;
    }

    class FeatureTableProvider
    extends LabelProvider
    implements ITableLabelProvider,
    IStructuredContentProvider {
        FeatureTableProvider() {
        }

        public Object[] getElements(Object inputElement) throws ClassCastException {
            List features = (List)inputElement;
            return features.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            ((TableViewer)viewer).getTable().layout();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) throws ClassCastException {
            SimpleFeature f = (SimpleFeature)element;
            if (f == null) {
                ProjectUIPlugin.trace(((Object)((Object)this)).getClass(), "SimpleFeature was null in FeatureTableControl", null);
                return null;
            }
            if (columnIndex == 0) {
                return f.getID();
            }
            if (columnIndex >= FeatureTableControl.this.fType.getAttributeCount()) {
                return null;
            }
            AttributeDescriptor at = FeatureTableControl.this.fType.getDescriptor(columnIndex - 1);
            if (at == null) {
                return null;
            }
            if (at instanceof GeometryDescriptor) {
                String s = f.getAttribute(columnIndex - 1).getClass().getName();
                return s.substring(s.lastIndexOf(46) + 1);
            }
            if (f.getAttribute(columnIndex - 1) == null) {
                return null;
            }
            return f.getAttribute(columnIndex - 1).toString();
        }
    }
}

