/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui.commands;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.ui.commands.AbstractDrawCommand;
import net.refractions.udig.project.ui.commands.IDrawCommand;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class SelectionBoxCommand
extends AbstractDrawCommand
implements IDrawCommand {
    private Shape shape;

    @Override
    public Rectangle getValidArea() {
        return this.shape.getBounds();
    }

    public void run(IProgressMonitor monitor) throws Exception {
        if (this.shape != null) {
            this.graphics.setColor(this.getSelectionColor(75));
            this.graphics.fill(this.shape);
            this.graphics.setColor(this.getSelectionColor2(75));
            this.graphics.setStroke(1, 3);
            this.graphics.draw(this.shape);
            this.graphics.setStroke(1, 1);
            this.graphics.setColor(this.getSelectionColor(255));
            this.graphics.draw(this.shape);
        }
    }

    private Color getSelectionColor(int alpha) {
        ScopedPreferenceStore store = ProjectPlugin.getPlugin().getPreferenceStore();
        String name = "P_SELECTION_COLOR";
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)name);
        return new Color(rgb.red, rgb.green, rgb.blue, alpha);
    }

    private Color getSelectionColor2(int alpha) {
        ScopedPreferenceStore store = ProjectPlugin.getPlugin().getPreferenceStore();
        String name = "P_SELECTION2_COLOR";
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)name);
        return new Color(rgb.red, rgb.green, rgb.blue, alpha);
    }

    public void setShape(Shape shape) {
        this.shape = shape;
    }

    public Shape getShape() {
        return this.shape;
    }
}

