/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.render.SelectionLayer;
import org.opengis.filter.Filter;

public class SelectionStyle {
    public static final SelectionStyle IGNORE = new SelectionStyle(Style.IGNORE);
    public static final SelectionStyle OVERLAY = new SelectionStyle(Style.OVERLAY);
    public static final SelectionStyle EXCLUSIVE = new SelectionStyle(Style.EXCLUSIVE);
    public static final SelectionStyle EXCLUSIVE_SELECTION = new SelectionStyle(Style.EXCLUSIVE_SELECTION);
    public static final SelectionStyle EXCLUSIVE_ALL = new SelectionStyle(Style.EXCLUSIVE_ALL);
    public static final SelectionStyle EXCLUSIVE_ALL_SELECTION = new SelectionStyle(Style.EXCLUSIVE_ALL_SELECTION);
    private Style style;
    private boolean showLabels;

    protected SelectionStyle() {
    }

    public SelectionStyle(Style style) {
        this.style = style;
        this.showLabels = false;
    }

    protected List<Layer> handleSelection(List<Layer> layersInternal) {
        ArrayList<Layer> toRender = new ArrayList<Layer>(layersInternal);
        for (Layer layer : layersInternal) {
            Filter selectionFilter = layer.getFilter();
            switch (this.style) {
                case EXCLUSIVE: {
                    if (selectionFilter != Filter.EXCLUDE) {
                        layer.getStyleBlackboard().put("net.refractions.udig.project.view", (Object)selectionFilter);
                        break;
                    }
                    toRender.remove(layer);
                    break;
                }
                case EXCLUSIVE_ALL: {
                    if (selectionFilter == Filter.EXCLUDE) break;
                    layer.getStyleBlackboard().put("net.refractions.udig.project.view", (Object)selectionFilter);
                    break;
                }
                case EXCLUSIVE_SELECTION: {
                    SelectionLayer selectionLayer;
                    if (selectionFilter != Filter.EXCLUDE) {
                        selectionLayer = new SelectionLayer(layer);
                        selectionLayer.getStyleBlackboard().put("net.refractions.udig.project.view", (Object)selectionFilter);
                        toRender.set(toRender.indexOf(layer), (Layer)selectionLayer);
                        break;
                    }
                    toRender.remove(layer);
                    break;
                }
                case EXCLUSIVE_ALL_SELECTION: {
                    if (selectionFilter == Filter.EXCLUDE) break;
                    SelectionLayer selectionLayer = new SelectionLayer(layer);
                    selectionLayer.getStyleBlackboard().put("net.refractions.udig.project.view", (Object)selectionFilter);
                    toRender.set(toRender.indexOf(layer), (Layer)selectionLayer);
                    break;
                }
                case OVERLAY: {
                    if (selectionFilter == Filter.EXCLUDE) break;
                    toRender.add(0, (Layer)new SelectionLayer(layer));
                    break;
                }
            }
        }
        return toRender;
    }

    public String name() {
        return this.style.name();
    }

    public void setShowLabels(boolean b) {
        this.showLabels = b;
    }

    public boolean getShowLabels() {
        return this.showLabels;
    }

    public static SelectionStyle valueOf(String name) {
        Style style2 = Style.valueOf(name);
        if (style2 != null) {
            return new SelectionStyle(style2);
        }
        return null;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.style == null ? 0 : this.style.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SelectionStyle other = (SelectionStyle)obj;
        return !(this.style == null ? other.style != null : !this.style.equals((Object)other.style));
    }

    private static enum Style {
        IGNORE,
        OVERLAY,
        EXCLUSIVE,
        EXCLUSIVE_SELECTION,
        EXCLUSIVE_ALL,
        EXCLUSIVE_ALL_SELECTION;

    }
}

