/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IProject;
import net.refractions.udig.project.IProjectElement;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.internal.MapEditorPart;
import net.refractions.udig.project.ui.internal.MapFactory;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class PlatformGIS {
    private static Runner runner = new Runner();

    public static IProject getActiveProject() {
        Project project = ProjectPlugin.getPlugin().getProjectRegistry().getCurrentProject();
        if (project != null) {
            return project;
        }
        return ProjectPlugin.getPlugin().getProjectRegistry().getCurrentProject();
    }

    public static IMap getActiveMap() {
        final ArrayList l = new ArrayList();
        net.refractions.udig.ui.PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
                    if (editor instanceof MapEditorPart) {
                        l.add(((MapEditorPart)editor).getMap());
                    }
                }
                catch (NullPointerException nullPointerException) {}
            }
        });
        if (!l.isEmpty()) {
            return (IMap)l.get(0);
        }
        return null;
    }

    public static List<IMap> getMaps() {
        ArrayList<IMap> maps;
        block7: {
            try {
                IWorkbenchWindow[] wWindows = PlatformUI.getWorkbench().getWorkbenchWindows();
                maps = new ArrayList<IMap>();
                IWorkbenchWindow[] iWorkbenchWindowArray = wWindows;
                int n = wWindows.length;
                int n2 = 0;
                while (n2 < n) {
                    IWorkbenchPage[] wPages;
                    IWorkbenchWindow wWindow = iWorkbenchWindowArray[n2];
                    IWorkbenchPage[] iWorkbenchPageArray = wPages = wWindow.getPages();
                    int n3 = wPages.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IEditorReference[] editors;
                        IWorkbenchPage wPage = iWorkbenchPageArray[n4];
                        IEditorReference[] iEditorReferenceArray = editors = wPage.getEditorReferences();
                        int n5 = editors.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IEditorReference editor = iEditorReferenceArray[n6];
                            if (editor.getEditor(false) instanceof MapEditorPart) {
                                maps.add((IMap)((MapEditorPart)editor.getEditor(false)).getMap());
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    ++n2;
                }
                if (maps.size() != 0) break block7;
                return null;
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
        }
        return maps;
    }

    public static void openMap(IMap map) {
        ApplicationGIS.openProjectElement((IProjectElement)map, false);
    }

    public static void createAndOpenMap(List<IGeoResource> resources) {
        MapFactory.instance().process(null, resources, true);
    }

    public static void createAndOpenMap(List<IGeoResource> resources, IProject owner) {
        MapFactory.instance().process((Project)owner, resources, true);
    }

    public static void addLayersToActiveMap(List<IGeoResource> resources) throws IllegalStateException {
        if (PlatformGIS.getActiveMap() == null) {
            throw new IllegalStateException("No active map exists");
        }
        MapFactory.instance().process(null, resources, false);
    }

    public static IViewPart getView(boolean show, String id) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] view = page.getViewReferences();
        IViewReference infoRef = null;
        IViewReference[] iViewReferenceArray = view;
        int n = view.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference reference = iViewReferenceArray[n2];
            if (reference.getId().equals(id)) {
                infoRef = reference;
                break;
            }
            ++n2;
        }
        IViewPart infoView = null;
        if (infoRef == null) {
            try {
                infoView = page.showView(id);
            }
            catch (PartInitException partInitException) {
                return null;
            }
            if (infoView == null) {
                return null;
            }
        }
        if (infoRef != null) {
            return (IViewPart)infoRef.getPart(show);
        }
        return null;
    }

    public static void run(ISafeRunnable request) {
        runner.addRequest(request);
    }

    private static class Runner
    extends Job {
        List<ISafeRunnable> requests = new LinkedList<ISafeRunnable>();
        IProgressMonitor current;

        public Runner() {
            super("");
            this.setPriority(30);
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.current = monitor;
            while (this.requests.size() > 0) {
                ISafeRunnable runnable = this.requests.get(0);
                this.requests.remove(0);
                this.run(runnable);
            }
            return Status.OK_STATUS;
        }

        public void addRequest(ISafeRunnable runnable) {
            if (this.getThread() == Thread.currentThread()) {
                if (this.current.isCanceled()) {
                    return;
                }
                this.run(runnable);
            } else {
                this.requests.add(runnable);
                this.schedule();
            }
        }

        private void run(ISafeRunnable runnable) {
            try {
                runnable.run();
            }
            catch (Throwable e) {
                try {
                    runnable.handleException(e);
                }
                catch (Throwable throwable) {
                    ProjectUIPlugin.log("", e);
                }
            }
        }
    }
}

