/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui;

import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.project.geoselection.IGeoSelectionChangedListener;
import net.refractions.udig.project.geoselection.IGeoSelectionManager;
import net.refractions.udig.project.geoselection.IGeoSelectionService;
import net.refractions.udig.project.ui.PlatformGeoSelectionManager;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;

public final class GeoSelectionService
implements IGeoSelectionService {
    public static Logger LOGGER = Logger.getLogger("net.refractions.udig.project.geoselection");
    public static final String EXTENSION_POINT_ID = "net.refractions.udig.project.geoselection";
    private static GeoSelectionService instance;
    private IGeoSelectionManager platformSelectionManager = null;
    private HashMap<String, IGeoSelectionManager> registeredManagers = new HashMap();

    private GeoSelectionService() {
        this.platformSelectionManager = new PlatformGeoSelectionManager();
        this.registerSelectionManager("net.refractions.udig.project.ui.platformGeoSelectionManager", this.platformSelectionManager);
        try {
            this.processExtensionPoint();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public IGeoSelectionManager getPlatformSelectionManager() {
        return this.platformSelectionManager;
    }

    public static GeoSelectionService getDefault() {
        if (instance == null) {
            instance = new GeoSelectionService();
        }
        return instance;
    }

    public void registerSelectionManager(String id, IGeoSelectionManager selectionManager) {
        if (this.registeredManagers.containsKey(id)) {
            throw new IllegalArgumentException("The IGeoSelectionManager instance with id= " + id + " is already registered");
        }
        this.registeredManagers.put(id, selectionManager);
    }

    public void unregisterSelectionManager(String id) {
        this.registeredManagers.remove(id);
    }

    public IGeoSelectionManager getSelectionManager(String id) {
        return this.registeredManagers.get(id);
    }

    private void processExtensionPoint() {
        List extensionList = ExtensionPointList.getExtensionPointList((String)EXTENSION_POINT_ID);
        for (IConfigurationElement element : extensionList) {
            String type = element.getName();
            if (!type.equals("geoSelectionListener")) continue;
            try {
                element.getAttribute("id");
                String managerId = element.getAttribute("managerId");
                Object listenerObj = element.createExecutableExtension("class");
                IGeoSelectionChangedListener listener = (IGeoSelectionChangedListener)listenerObj;
                IGeoSelectionManager manager = this.getSelectionManager(managerId);
                if (manager == null) continue;
                manager.addListener(listener);
            }
            catch (InvalidRegistryObjectException e) {
                e.printStackTrace();
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }
}

