/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.ui;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.internal.ui.UiPlugin;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.IProject;
import net.refractions.udig.project.IProjectElement;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.element.ElementFactory;
import net.refractions.udig.project.element.IGenericProjectElement;
import net.refractions.udig.project.element.ProjectElementAdapter;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectElement;
import net.refractions.udig.project.internal.ProjectFactory;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.internal.commands.AddLayersCommand;
import net.refractions.udig.project.internal.commands.CreateMapCommand;
import net.refractions.udig.project.internal.impl.ProjectRegistryImpl;
import net.refractions.udig.project.internal.render.CompositeRenderContext;
import net.refractions.udig.project.internal.render.RenderContext;
import net.refractions.udig.project.internal.render.RenderFactory;
import net.refractions.udig.project.internal.render.RenderManager;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.internal.render.RendererCreator;
import net.refractions.udig.project.internal.render.SelectionLayer;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.internal.render.impl.RenderContextImpl;
import net.refractions.udig.project.internal.render.impl.RendererCreatorImpl;
import net.refractions.udig.project.render.ILabelPainter;
import net.refractions.udig.project.render.RenderException;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.render.displayAdapter.MapDisplayEvent;
import net.refractions.udig.project.ui.BoundsStrategy;
import net.refractions.udig.project.ui.ProjectUtil;
import net.refractions.udig.project.ui.SelectionStyle;
import net.refractions.udig.project.ui.UDIGEditorInput;
import net.refractions.udig.project.ui.commands.OpenProjectElementCommand;
import net.refractions.udig.project.ui.internal.ActiveMapTracker;
import net.refractions.udig.project.ui.internal.ApplicationGISInternal;
import net.refractions.udig.project.ui.internal.Messages;
import net.refractions.udig.project.ui.internal.ProjectUIPlugin;
import net.refractions.udig.project.ui.internal.UDIGEditorInputDescriptor;
import net.refractions.udig.project.ui.internal.tool.display.ToolManager;
import net.refractions.udig.project.ui.internal.tool.impl.ToolContextImpl;
import net.refractions.udig.project.ui.tool.IToolContext;
import net.refractions.udig.project.ui.tool.IToolManager;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.coverage.grid.GridCoverage;

public class ApplicationGIS {
    private static IToolManager toolManager;
    private static ActiveMapTracker activeMapTracker;
    public static final Map NO_MAP;

    static {
        NO_MAP = ProjectFactory.eINSTANCE.createMap();
    }

    public static IProject getActiveProject() {
        Project project = ProjectPlugin.getPlugin().getProjectRegistry().getCurrentProject();
        if (project != null) {
            return project;
        }
        return ProjectPlugin.getPlugin().getProjectRegistry().getDefaultProject();
    }

    public static List<? extends IProject> getProjects() {
        return Collections.unmodifiableList(ProjectPlugin.getPlugin().getProjectRegistry().getProjects());
    }

    public static IMap getActiveMap() {
        return activeMapTracker.getActiveMap();
    }

    public static Collection<? extends IMap> getOpenMaps() {
        return activeMapTracker.getOpenMaps();
    }

    public static Collection<? extends IMap> getVisibleMaps() {
        return activeMapTracker.getVisibleMaps();
    }

    public static void openMap(IMap map) {
        ApplicationGIS.openMap(map, false);
    }

    public static void openMap(IMap map, boolean wait) {
        ApplicationGIS.openProjectElement((IProjectElement)map, wait);
    }

    public static void createAndOpenMap(List<IGeoResource> resources) {
        CreateMapCommand command = new CreateMapCommand(null, resources, null);
        ApplicationGIS.getActiveProject().sendSync((Command)command);
        ApplicationGIS.openMap(command.getCreatedMap());
    }

    public static void createAndOpenMap(List<IGeoResource> resources, IProject owner) {
        CreateMapCommand command = new CreateMapCommand(null, resources, owner);
        ApplicationGIS.getActiveProject().sendSync((Command)command);
        ApplicationGIS.openMap(command.getCreatedMap());
    }

    public static void createAndOpenMap(List<IGeoResource> resources, IProject owner, boolean wait) {
        CreateMapCommand command = new CreateMapCommand(null, resources, owner);
        ApplicationGIS.getActiveProject().sendSync((Command)command);
        ApplicationGIS.openMap(command.getCreatedMap(), wait);
    }

    public static IViewPart getView(boolean show, String id) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] view = page.getViewReferences();
        IViewReference infoRef = null;
        IViewReference[] iViewReferenceArray = view;
        int n = view.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference reference = iViewReferenceArray[n2];
            if (reference.getId().equals(id)) {
                infoRef = reference;
                break;
            }
            ++n2;
        }
        IViewPart infoView = null;
        if (infoRef == null) {
            try {
                infoView = page.showView(id);
            }
            catch (PartInitException partInitException) {
                return null;
            }
            if (infoView == null) {
                return null;
            }
        }
        if (infoRef != null) {
            return (IViewPart)infoRef.getPart(show);
        }
        return null;
    }

    public static void run(ISafeRunnable request) {
        PlatformGIS.run((ISafeRunnable)request);
    }

    public static List<UDIGEditorInputDescriptor> getEditorInputs(IProjectElement projectElement) {
        ArrayList<UDIGEditorInputDescriptor> newInputs = new ArrayList<UDIGEditorInputDescriptor>();
        List extensions = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.project.ui.editorInputs");
        Class<?> toMatch = projectElement instanceof ProjectElementAdapter ? ((ProjectElementAdapter)projectElement).getBackingObject().getClass() : projectElement.getClass();
        for (IConfigurationElement element : extensions) {
            String projectElementClassName = element.getAttribute("projectElement");
            Class match = ApplicationGIS.match(toMatch, projectElementClassName);
            if (match == null) continue;
            UDIGEditorInputDescriptor input = new UDIGEditorInputDescriptor();
            input.setEditorID(element.getAttribute("editorPartID"));
            input.setName(element.getAttribute("name"));
            input.setExtensionElement(element);
            input.setType(match);
            newInputs.add(input);
        }
        return newInputs;
    }

    private static Class match(Class toMatch, String projectElementClassName) {
        Class<?>[] interfaces;
        Class result;
        if (toMatch.getName().equals(projectElementClassName) || toMatch.getCanonicalName().equals(projectElementClassName)) {
            return toMatch;
        }
        Class superClass = toMatch.getSuperclass();
        if (superClass != Object.class && superClass != null && (result = ApplicationGIS.match(superClass, projectElementClassName)) != null) {
            return result;
        }
        Class<?>[] classArray = interfaces = toMatch.getInterfaces();
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> iFace = classArray[n2];
            Class result2 = ApplicationGIS.match(iFace, projectElementClassName);
            if (result2 != null) {
                return result2;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IToolManager getToolManager() {
        Class<ToolManager> clazz = ToolManager.class;
        synchronized (ToolManager.class) {
            if (toolManager == null) {
                String prefConstant = "toolManager";
                String xpid = "net.refractions.udig.project.ui.toolManagers";
                String idField = "id";
                String classField = "class";
                IToolManager result = (IToolManager)UiPlugin.lookupConfigurationObject(IToolManager.class, (IPreferenceStore)ProjectUIPlugin.getDefault().getPreferenceStore(), (String)"net.refractions.udig.project.ui", (String)prefConstant, (String)xpid, (String)idField, (String)classField);
                toolManager = result != null ? result : new ToolManager();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return toolManager;
        }
    }

    public static UDIGEditorInput getInput(IProjectElement element) {
        List<UDIGEditorInputDescriptor> descriptors = ApplicationGIS.getEditorInputs(element);
        for (UDIGEditorInputDescriptor descriptor : descriptors) {
            UDIGEditorInput input = descriptor.createInput(element);
            if (input == null) continue;
            return input;
        }
        return null;
    }

    public static IToolContext createContext(IMap map) {
        if (map instanceof Map) {
            ToolContextImpl context = new ToolContextImpl();
            context.setMapInternal((Map)map);
            return context;
        }
        return null;
    }

    public static List<? extends ILayer> addLayersToMap(IMap map, List<IGeoResource> resourceList, int startPosition) {
        return ApplicationGIS.addLayersToMap(map, resourceList, startPosition, null, false);
    }

    public static List<? extends ILayer> addLayersToMap(IProject project, List<IGeoResource> resourceList) {
        return ApplicationGIS.addLayersToMap(null, resourceList, 0, project, false);
    }

    public static List<? extends ILayer> addLayersToMap(IMap map, List<IGeoResource> resourceList, int startPosition, Project project) {
        return ApplicationGIS.addLayersToMap(map, resourceList, startPosition, (IProject)project, false);
    }

    public static List<? extends ILayer> addLayersToMap(IMap map2, List<IGeoResource> resourceList, int startPosition2, IProject project2, boolean wait) {
        List layers;
        Object project;
        IMap map = map2;
        if (map == null && project2 == null) {
            map = ApplicationGIS.getActiveMap();
        }
        if (map == NO_MAP) {
            map = null;
        }
        if ((project = project2) == null) {
            project = map == null ? ProjectPlugin.getPlugin().getProjectRegistry().getCurrentProject() : map.getProject();
        }
        List<IGeoResource> cleanedGeoResources = ProjectPlugin.getPlugin().getPluginPreferences().getBoolean("P_CHECK_DUPLICATE_LAYERS") ? ProjectUtil.cleanDuplicateGeoResources(resourceList, map) : resourceList;
        if (map == null) {
            CreateMapCommand cmCommand = new CreateMapCommand(null, cleanedGeoResources, project);
            project.sendSync((Command)cmCommand);
            map = cmCommand.getCreatedMap();
            layers = map.getMapLayers();
        } else {
            AddLayersCommand alCommand = new AddLayersCommand(cleanedGeoResources, startPosition2);
            map.sendCommandSync((MapCommand)alCommand);
            layers = alCommand.getLayers();
        }
        if (!ApplicationGISInternal.getOpenMaps().contains(map)) {
            ApplicationGIS.openMap(map, wait);
        }
        return layers;
    }

    public static IProjectElement loadProjectElement(URL url, IProject project) throws IOException, IllegalArgumentException {
        Object obj;
        Resource mapResource;
        URI uri = URI.createURI((String)url.toString());
        try {
            mapResource = ProjectRegistryImpl.getProjectRegistry().eResource().getResourceSet().getResource(uri, true);
        }
        catch (Exception exception) {
            throw new IOException(String.valueOf(Messages.ApplicationGIS_loadError) + uri);
        }
        try {
            obj = mapResource.getContents().get(0);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(String.valueOf(Messages.ApplicationGIS_illegalArgumentPart1) + uri + Messages.ApplicationGIS_illegalArgumentPart2);
        }
        if (!(obj instanceof ProjectElement)) {
            throw new IllegalArgumentException(String.valueOf(Messages.ApplicationGIS_noProjectElement) + obj.getClass().getSimpleName());
        }
        ProjectElement elem = (ProjectElement)obj;
        ((Project)project).getElementsInternal().add(elem);
        return elem;
    }

    public static void openProjectElement(IProjectElement obj, boolean wait) {
        OpenProjectElementCommand command = new OpenProjectElementCommand(obj);
        if (wait) {
            ApplicationGIS.getActiveProject().sendSync((Command)command);
        } else {
            ApplicationGIS.getActiveProject().sendASync((Command)command);
        }
    }

    public static IMap drawMap(final DrawMapParameter drawMapParams) throws RenderException {
        final DrawMapParameter params = new DrawMapParameter(drawMapParams);
        IProgressMonitor monitor = params.monitor;
        final Map map = (Map)EcoreUtil.copy((EObject)((EObject)params.toDraw));
        map.getBlackboard().addAll(drawMapParams.toDraw.getBlackboard());
        int i = 0;
        while (i < map.getMapLayers().size()) {
            ILayer source = (ILayer)params.toDraw.getMapLayers().get(i);
            Layer dest = (Layer)map.getLayersInternal().get(i);
            dest.setFilter(source.getFilter());
            dest.getBlackboard().addAll(source.getBlackboard());
            ++i;
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                List layers = drawMapParams.toDraw.getMapLayers();
                for (ILayer layer : layers) {
                    layer.getGeoResources();
                }
                Color background = (Color)map.getBlackboard().get("mapBackgroundColor");
                params.graphics.setBackground(background);
                if (!drawMapParams.transparent) {
                    params.graphics.clearRect(0, 0, params.destinationSize.width, params.destinationSize.height);
                }
                List<Layer> layersToRender = params.selectionStyle.handleSelection(map.getLayersInternal());
                ProjectUIPlugin.trace(ApplicationGIS.class, "ApplicationGIS.drawMap() beginning rendering of map '" + map.getName() + "'", null);
                ReferencedEnvelope bounds = params.toDraw.getViewportModel().getBounds();
                ReferencedEnvelope boundsCopy = new ReferencedEnvelope(bounds);
                RenderContext tools = ApplicationGIS.configureMapForRendering(map, params.destinationSize, params.dpi, params.boundsStrategy, boundsCopy);
                RendererCreatorImpl decisive = new RendererCreatorImpl();
                decisive.setContext(tools);
                decisive.getLayers().addAll(layersToRender);
                TreeSet<RenderContext> sortedContexts = new TreeSet<RenderContext>(decisive.getConfiguration());
                this.render(params, monitor, (RendererCreator)decisive, sortedContexts);
            }

            private void render(DrawMapParameter params2, IProgressMonitor monitor, RendererCreator decisive, SortedSet<RenderContext> sortedContexts) throws InvocationTargetException {
                monitor.beginTask("Rendering map", sortedContexts.size());
                RenderContext mainContext = decisive.getContext();
                ILabelPainter labelPainter = mainContext.getLabelPainter();
                labelPainter.clear();
                labelPainter.start();
                Dimension displaySize = params2.destinationSize;
                for (RenderContext context : sortedContexts) {
                    ILayer layer = context.getLayer();
                    boolean isLayerFromGrid = layer.getGeoResource().canResolve(GridCoverage.class);
                    String layerId = this.getLayerId(layer);
                    if (!(layer instanceof SelectionLayer) || layer instanceof SelectionLayer && params2.selectionStyle.getShowLabels()) {
                        labelPainter.startLayer(layerId);
                    }
                    try {
                        if (context instanceof CompositeRenderContext) {
                            CompositeRenderContext compositeContext = (CompositeRenderContext)context;
                            List layers = compositeContext.getLayers();
                            boolean visible = false;
                            for (ILayer tmpLayer : layers) {
                                boolean bl = visible = visible || tmpLayer.isVisible();
                            }
                            if (!visible) {
                                continue;
                            }
                        } else if (!layer.isVisible()) continue;
                        Renderer renderer = decisive.getRenderer(context);
                        ProjectUIPlugin.trace(ApplicationGIS.class, "Issuing render call to " + renderer.getName(), null);
                        try {
                            Graphics2D graphics = (Graphics2D)params2.graphics.create();
                            if (params2.doBufferedImageForGrids && isLayerFromGrid) {
                                Rectangle clipBounds = graphics.getClipBounds();
                                BufferedImage bi = new BufferedImage(clipBounds.width, clipBounds.height, 2);
                                Graphics2D biG2D = (Graphics2D)bi.getGraphics();
                                renderer.render(biG2D, monitor);
                                graphics.drawImage(bi, null, 0, 0);
                                biG2D.dispose();
                                continue;
                            }
                            renderer.render(graphics, monitor);
                        }
                        catch (RenderException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        labelPainter.endLayer(layerId, params2.graphics, new Rectangle(displaySize));
                    }
                }
                labelPainter.end(params2.graphics, new Rectangle(displaySize));
                labelPainter.clear();
            }

            private String getLayerId(ILayer layer) {
                String layerId = layer.getID().toString();
                if (layer instanceof SelectionLayer) {
                    layerId = String.valueOf(layerId) + "-Selection";
                }
                return layerId;
            }
        };
        try {
            PlatformGIS.runBlockingOperation((IRunnableWithProgress)runnable, (IProgressMonitor)monitor);
        }
        catch (InvocationTargetException e) {
            throw (RenderException)e.getCause();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public static RenderContext configureMapForRendering(Map map, final Dimension destinationSize, final int dpi, BoundsStrategy boundsStrategy, ReferencedEnvelope baseMapBounds) {
        RenderManager manager = RenderFactory.eINSTANCE.createRenderManagerViewer();
        map.setRenderManagerInternal(manager);
        RenderContextImpl tools = new RenderContextImpl();
        tools.setMapInternal(map);
        tools.setRenderManagerInternal(manager);
        ProjectUIPlugin.trace(ApplicationGIS.class, "Firing size changed event. Changing to size: " + destinationSize.width + " by " + destinationSize.height, null);
        manager.setMapInternal(map);
        manager.setMapDisplay(new IMapDisplay(){

            public Dimension getDisplaySize() {
                return new Dimension(destinationSize.width, destinationSize.height);
            }

            public int getWidth() {
                return destinationSize.width;
            }

            public int getHeight() {
                return destinationSize.height;
            }

            public int getDPI() {
                return dpi;
            }
        });
        ViewportModel model = map.getViewportModelInternal();
        manager.setViewportModelInternal(model);
        model.setCRS(map.getViewportModel().getCRS());
        model.zoomToBox((Envelope)map.getViewportModel().getBounds());
        ProjectUIPlugin.trace(ApplicationGIS.class, "Using bounds: " + map.getViewportModel().getBounds(), null);
        model.setMapInternal(map);
        model.sizeChanged(new MapDisplayEvent(null, new Dimension(0, 0), new Dimension(destinationSize.width, destinationSize.height)));
        boundsStrategy.setBounds(model, baseMapBounds);
        return tools;
    }

    public static void setActiveMapTracker(ActiveMapTracker activeMapTrackerToSet) {
        if (activeMapTracker != null) {
            throw new Error("This method has already been called! It is an error for non-uDig code to call this method");
        }
        activeMapTracker = activeMapTrackerToSet;
    }

    public static IMap copyMap(IMap mapToCopy) {
        List layers = mapToCopy.getMapLayers();
        for (ILayer layer : layers) {
            layer.getGeoResources();
        }
        Map copy = (Map)EcoreUtil.copy((EObject)((EObject)mapToCopy));
        copy.getBlackboard().addAll(mapToCopy.getBlackboard());
        int i = 0;
        while (i < copy.getMapLayers().size()) {
            ILayer source = (ILayer)mapToCopy.getMapLayers().get(i);
            Layer dest = (Layer)copy.getLayersInternal().get(i);
            dest.setFilter(source.getFilter());
            dest.getBlackboard().addAll(source.getBlackboard());
            dest.setStyleBlackboard((StyleBlackboard)dest.getStyleBlackboard().clone());
            ++i;
        }
        return copy;
    }

    public static ProjectElementAdapter createGeneralProjectElement(IProject project, Class<? extends IGenericProjectElement> typeToCreate, String extensionId) throws IllegalArgumentException {
        return ElementFactory.eINSTANCE.createProjectElementAdapter(project, typeToCreate, extensionId);
    }

    public static ProjectElementAdapter createGeneralProjectElement(IProject project, String elementName, Class<? extends IGenericProjectElement> typeToCreate, String extensionId) throws IllegalArgumentException {
        return ElementFactory.eINSTANCE.createProjectElementAdapter(project, elementName, typeToCreate, extensionId);
    }

    public static class DrawMapParameter {
        final BoundsStrategy boundsStrategy;
        final Graphics2D graphics;
        final Dimension destinationSize;
        final IMap toDraw;
        final IProgressMonitor monitor;
        final SelectionStyle selectionStyle;
        final int dpi;
        final boolean transparent;
        final boolean doBufferedImageForGrids;

        public DrawMapParameter(Graphics2D graphics, Dimension destinationSize, IMap toDraw, BoundsStrategy boundsStrategy, int dpi, SelectionStyle selectionStyle, IProgressMonitor monitor, boolean transparent, boolean doBufferedImageForGrids) {
            this.graphics = graphics;
            this.destinationSize = destinationSize;
            this.toDraw = toDraw;
            this.dpi = dpi;
            this.doBufferedImageForGrids = doBufferedImageForGrids;
            this.boundsStrategy = boundsStrategy == null ? new BoundsStrategy(toDraw.getViewportModel().getScaleDenominator()) : boundsStrategy;
            this.monitor = monitor;
            this.selectionStyle = selectionStyle;
            this.transparent = transparent;
        }

        public DrawMapParameter(Graphics2D graphics, Dimension destinationSize, IMap toDraw, BoundsStrategy boundsStrategy, int dpi, SelectionStyle selectionStyle, IProgressMonitor monitor) {
            this(graphics, destinationSize, toDraw, boundsStrategy, dpi, selectionStyle, monitor, false, false);
        }

        public DrawMapParameter(Graphics2D graphics, Dimension destinationSize, IMap toDraw, IProgressMonitor monitor) {
            this(graphics, destinationSize, toDraw, new BoundsStrategy(toDraw.getViewportModel().getScaleDenominator()), 90, SelectionStyle.OVERLAY, monitor);
        }

        public DrawMapParameter(Graphics2D graphics, Dimension destinationSize, IMap toDraw, int dpi, IProgressMonitor monitor) {
            this(graphics, destinationSize, toDraw, new BoundsStrategy(toDraw.getViewportModel().getScaleDenominator()), dpi, SelectionStyle.OVERLAY, monitor);
        }

        public DrawMapParameter(Graphics2D graphics, Dimension destinationSize, IMap toDraw, IProgressMonitor monitor, boolean transparent) {
            this(graphics, destinationSize, toDraw, new BoundsStrategy(toDraw.getViewportModel().getScaleDenominator()), 90, SelectionStyle.OVERLAY, monitor, transparent, false);
        }

        public DrawMapParameter(DrawMapParameter params2) {
            this((Graphics2D)params2.graphics.create(), new Dimension(params2.destinationSize), params2.toDraw, params2.boundsStrategy, params2.dpi, params2.selectionStyle, params2.monitor, params2.transparent, params2.doBufferedImageForGrids);
        }
    }
}

