/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.sld.v1_1.bindings;

import org.geotools.data.DataStore;
import org.geotools.data.memory.MemoryDataStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.sld.bindings.SLDUserLayerBinding;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.UserLayer;
import org.geotools.xml.ElementInstance;
import org.geotools.xml.Node;
import org.opengis.feature.simple.SimpleFeatureType;

public class UserLayerBinding
extends SLDUserLayerBinding {
    public UserLayerBinding(StyleFactory styleFactory) {
        super(styleFactory);
    }

    @Override
    public Object parse(ElementInstance instance, Node node, Object value) throws Exception {
        UserLayer layer = (UserLayer)super.parse(instance, node, value);
        if (node.hasChild("InlineFeature")) {
            SimpleFeatureCollection features = (SimpleFeatureCollection)node.getChildValue("InlineFeature");
            SimpleFeatureType type = (SimpleFeatureType)features.getSchema();
            layer.setInlineFeatureType(type);
            layer.setInlineFeatureDatastore(this.toDataStore(features));
        }
        return layer;
    }

    DataStore toDataStore(FeatureCollection features) {
        return new MemoryDataStore(features);
    }
}

