/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.provider;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import net.refractions.udig.project.edit.internal.Messages;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerDecorator;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.ProjectFactory;
import net.refractions.udig.project.internal.ProjectPackage;
import net.refractions.udig.project.internal.impl.SynchronizedEList;
import net.refractions.udig.project.internal.provider.AbstractLazyLoadingItemProvider;
import net.refractions.udig.project.internal.provider.ChildFetcher;
import net.refractions.udig.project.internal.provider.ContextModelItemProvider;
import net.refractions.udig.project.internal.provider.LoadingPlaceHolder;
import net.refractions.udig.project.internal.provider.ProjectEditPlugin;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.internal.render.provider.ViewportModelItemProvider;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class MapItemProvider
extends AbstractLazyLoadingItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    public static final String copyright = "uDig - User Friendly Desktop Internet GIS client\nhttp://udig.refractions.net\n(C) 2004-2012, Refractions Research Inc.\n\n\nAll rights reserved. This program and the accompanying materials\nare made available under the terms of the Eclipse Public License v1.0\n(http://www.eclipse.org/legal/epl-v10.html), and the Refractions BSD\nLicense v1.0 (http://udig.refractions.net/files/bsd3-v10.html).\n";
    ViewportModelItemProvider modelProvider;
    public static final LayerLoadingPlaceHolder LOADING_LAYER = new LayerLoadingPlaceHolder(ProjectFactory.eINSTANCE.createLayer());

    static {
        LOADING_LAYER.setName(Messages.ProjectItemProvider_loading);
        Bundle bundle = ProjectEditPlugin.getPlugin().getBundle();
        Path path = new Path("icons/full/obj16/Layer.gif");
        ImageDescriptor image = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)bundle, (IPath)path, null));
        LOADING_LAYER.setIcon(image);
        LOADING_LAYER.setVisible(true);
    }

    public MapItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.modelProvider = new ViewportModelItemProvider(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addAbstractPropertyDescriptor(object);
            this.addNamePropertyDescriptor(object);
            this.addViewportModelDescriptors((Map)object);
        }
        return this.itemPropertyDescriptors;
    }

    private void addViewportModelDescriptors(Map map) {
        for (ItemPropertyDescriptor element : this.modelProvider.getPropertyDescriptors(map.getViewportModel())) {
            this.itemPropertyDescriptors.add(new ViewportModelDescriptor(element));
        }
    }

    protected void addAbstractPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Map_abstract_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Map_abstract_feature", "_UI_Map_type"), (EStructuralFeature)ProjectPackage.eINSTANCE.getMap_Abstract(), true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addNamePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ProjectElement_name_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ProjectElement_name_feature", "_UI_ProjectElement_type"), (EStructuralFeature)ProjectPackage.eINSTANCE.getProjectElement_Name(), true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addNavCommandStackPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Map_navCommandStack_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Map_navCommandStack_feature", "_UI_Map_type"), (EStructuralFeature)ProjectPackage.eINSTANCE.getMap_NavCommandStack(), false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addCommandStackPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Map_commandStack_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Map_commandStack_feature", "_UI_Map_type"), (EStructuralFeature)ProjectPackage.eINSTANCE.getMap_CommandStack(), false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addColorPalettePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Map_colorPalette_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Map_colorPalette_feature", "_UI_Map_type"), (EStructuralFeature)ProjectPackage.eINSTANCE.getMap_ColorPalette(), true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addRenderManagerInternalPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Map_renderManagerInternal_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Map_renderManagerInternal_feature", "_UI_Map_type"), (EStructuralFeature)ProjectPackage.eINSTANCE.getMap_RenderManagerInternal(), true, null, null, null));
    }

    protected void addColourSchemePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Map_colourScheme_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Map_colourScheme_feature", "_UI_Map_type"), (EStructuralFeature)ProjectPackage.eINSTANCE.getMap_ColourScheme(), true, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    protected void addBlackBoardInternalPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), "blackboard", "blackboard ", (EStructuralFeature)ProjectPackage.eINSTANCE.getMap_BlackBoardInternal(), true, null, null, null));
    }

    public Collection getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ProjectPackage.eINSTANCE.getMap_ContextModel());
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.getResourceLocator().getImage("full/obj16/Map");
    }

    @Override
    protected LoadingPlaceHolder getLoadingItem() {
        return LOADING_LAYER;
    }

    @Override
    protected ChildFetcher createChildFetcher() {
        return new ChildFetcher(this){

            @Override
            protected void notifyChanged() {
                MapItemProvider.this.notifyChanged((Notification)new ENotificationImpl((InternalEObject)this.parent, 1, 2, (Object)LOADING_LAYER, null));
            }

            @Override
            protected IStatus run(IProgressMonitor monitor) {
                if (this.parent instanceof Map) {
                    Map map = (Map)this.parent;
                    boolean found = false;
                    SynchronizedEList adapters = (SynchronizedEList)map.getContextModel().eAdapters();
                    adapters.lock();
                    try {
                        for (Adapter next : adapters) {
                            if (!(next instanceof ContextModelItemProvider) || ((ContextModelItemProvider)next).getAdapterFactory() != MapItemProvider.this.getAdapterFactory()) continue;
                            found = true;
                        }
                    }
                    finally {
                        adapters.unlock();
                    }
                    if (!found) {
                        ContextModelItemProvider provider = new ContextModelItemProvider(MapItemProvider.this.getAdapterFactory());
                        adapters.add((Object)provider);
                    }
                }
                IStatus result = super.run(monitor);
                return result;
            }
        };
    }

    @Override
    protected Collection<? extends Object> getConcreteChildren(Object object) {
        if (object instanceof Map) {
            return ((Map)object).getMapLayers();
        }
        throw new IllegalArgumentException("Object must be a Map.  Was: " + object);
    }

    @Override
    public Object getChild(Object object, int childIndex) {
        Map map = (Map)object;
        if (childIndex >= map.getMapLayers().size()) {
            return null;
        }
        return map.getMapLayers().get(childIndex);
    }

    public boolean hasChildren(Object object) {
        return true;
    }

    public String getText(Object object) {
        Resource resource;
        Map map = (Map)object;
        String label = map.getName();
        if (label == null && (resource = map.eResource()) != null) {
            String toString = resource.toString();
            int lastSlash = toString.lastIndexOf(File.pathSeparator);
            if (lastSlash == -1) {
                lastSlash = 0;
            }
            label = toString.substring(lastSlash);
        }
        return label == null || label.length() == 0 ? "Unable to load map" : label;
    }

    public void notifyChanged(Notification notification) {
        if (notification.getNewValue() == notification.getOldValue() || notification.getNewValue() != null && notification.getNewValue().equals(notification.getOldValue()) || notification.getOldValue() != null && notification.getOldValue().equals(notification.getNewValue())) {
            return;
        }
        switch (notification.getFeatureID(Map.class)) {
            case 0: 
            case 3: 
            case 8: 
            case 11: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 2: 
            case 6: 
            case 7: 
            case 9: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public ResourceLocator getResourceLocator() {
        return ProjectEditPlugin.INSTANCE;
    }

    public static class LayerLoadingPlaceHolder
    extends LayerDecorator
    implements LoadingPlaceHolder {
        public LayerLoadingPlaceHolder(Layer layer) {
            super(layer);
        }

        @Override
        public Image getImage() {
            return this.getIcon().createImage();
        }

        @Override
        public String getText() {
            return this.getName();
        }

        public int getZorder() {
            return Integer.MAX_VALUE;
        }
    }

    private static class ViewportModelDescriptor
    implements IItemPropertyDescriptor {
        private ItemPropertyDescriptor element;

        public ViewportModelDescriptor(ItemPropertyDescriptor element) {
            this.element = element;
        }

        ViewportModel getModel(Object obj) {
            return ((Map)obj).getViewportModelInternal();
        }

        public Object getPropertyValue(Object object) {
            return this.element.getPropertyValue((Object)this.getModel(object));
        }

        public boolean isPropertySet(Object object) {
            return this.element.isPropertySet((Object)this.getModel(object));
        }

        public boolean canSetProperty(Object object) {
            return this.element.canSetProperty((Object)this.getModel(object));
        }

        public void resetPropertyValue(Object object) {
            this.element.resetPropertyValue((Object)this.getModel(object));
        }

        public void setPropertyValue(Object object, Object value) {
            this.element.setPropertyValue((Object)this.getModel(object), value);
        }

        public String getCategory(Object object) {
            return this.element.getCategory((Object)this.getModel(object));
        }

        public String getDescription(Object object) {
            return this.element.getDescription((Object)this.getModel(object));
        }

        public String getDisplayName(Object object) {
            return this.element.getDisplayName((Object)this.getModel(object));
        }

        public String[] getFilterFlags(Object object) {
            return this.element.getFilterFlags((Object)this.getModel(object));
        }

        public Object getHelpContextIds(Object object) {
            return this.element.getHelpContextIds((Object)this.getModel(object));
        }

        public String getId(Object object) {
            return this.element.getId((Object)this.getModel(object));
        }

        public IItemLabelProvider getLabelProvider(Object object) {
            return this.element.getLabelProvider((Object)this.getModel(object));
        }

        public boolean isCompatibleWith(Object object, Object anotherObject, IItemPropertyDescriptor anotherPropertyDescriptor) {
            return this.element.isCompatibleWith((Object)this.getModel(object), anotherObject, anotherPropertyDescriptor);
        }

        public Object getFeature(Object object) {
            return this.element.getFeature((Object)this.getModel(object));
        }

        public Collection getChoiceOfValues(Object object) {
            return this.element.getChoiceOfValues((Object)this.getModel(object));
        }

        public boolean isMany(Object arg0) {
            return this.element.isMany(arg0);
        }

        public boolean isMultiLine(Object arg0) {
            return this.element.isMultiLine(arg0);
        }

        public boolean isSortChoices(Object arg0) {
            return this.element.isSortChoices(arg0);
        }
    }
}

