/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.provider;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.net.URL;
import java.util.List;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.provider.ProjectEditPlugin;
import net.refractions.udig.ui.Drawing;
import net.refractions.udig.ui.graphics.ViewportGraphics;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.geotools.data.FeatureSource;
import org.geotools.data.wms.WebMapServer;
import org.geotools.data.wms.request.GetLegendGraphicRequest;
import org.geotools.feature.FeatureIterator;
import org.geotools.styling.Style;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.BoundingBox;

public class GlyphBuilder {
    public static final int TRANSPARENT = 0x222222;

    public static ImageDescriptor createImageDescriptor(final RenderedImage image) {
        return new ImageDescriptor(){

            public ImageData getImageData() {
                return GlyphBuilder.createImageData(image);
            }
        };
    }

    public static BufferedImage createBufferedImage(int w, int h) {
        return new BufferedImage(w, h, 7);
    }

    public static Image createSWTImage(RenderedImage image) {
        ImageData data = GlyphBuilder.createImageData(image);
        return new Image((Device)Display.getDefault(), data);
    }

    public static ImageData createImageData(RenderedImage image) {
        ImageData swtdata = null;
        int width = image.getWidth();
        int height = image.getHeight();
        int depth = 24;
        PaletteData palette = new PaletteData(0xFF0000, 65280, 255);
        swtdata = new ImageData(width, height, depth, palette);
        swtdata.transparentPixel = 0x222222;
        int blueT = 34;
        int greenT = 34;
        int redT = 34;
        Raster raster = image.getData();
        int[] awtdata = raster.getPixels(0, 0, width, height, new int[width * height * 3]);
        int step = swtdata.depth / 8;
        byte[] data = swtdata.data;
        int baseindex = 0;
        int y = 0;
        while (y < height) {
            int idx = (0 + y) * swtdata.bytesPerLine + 0 * step;
            int x = 0;
            while (x < width) {
                baseindex = (x + y * width) * 4;
                if (awtdata[baseindex + 3] == 0) {
                    data[idx++] = blueT;
                    data[idx++] = greenT;
                    data[idx++] = redT;
                } else {
                    data[idx++] = (byte)awtdata[baseindex];
                    data[idx++] = (byte)awtdata[baseindex + 1];
                    data[idx++] = (byte)awtdata[baseindex + 2];
                }
                ++x;
            }
            ++y;
        }
        return swtdata;
    }

    public ImageDescriptor createWMSGylph(Layer target) {
        block6: {
            String desiredFormat;
            GetLegendGraphicRequest request;
            block7: {
                if (target.isType(WebMapServer.class)) {
                    return null;
                }
                try {
                    WebMapServer wms = (WebMapServer)target.getResource(WebMapServer.class, null);
                    org.geotools.data.ows.Layer layer = (org.geotools.data.ows.Layer)target.getResource(org.geotools.data.ows.Layer.class, null);
                    if (wms.getCapabilities().getRequest().getGetLegendGraphic() == null) break block6;
                    request = wms.createGetLegendGraphicRequest();
                    request.setLayer(layer.getName());
                    desiredFormat = null;
                    List formats = wms.getCapabilities().getRequest().getGetLegendGraphic().getFormats();
                    if (formats.contains("image/png")) {
                        desiredFormat = "image/png";
                    }
                    if (desiredFormat == null && formats.contains("image/gif")) {
                        desiredFormat = "image/gif";
                    }
                    if (desiredFormat != null) break block7;
                    return null;
                }
                catch (Exception exception) {}
            }
            request.setFormat(desiredFormat);
            return ImageDescriptor.createFromURL((URL)request.getFinalURL());
        }
        return null;
    }

    private SimpleFeature sampleFeature(Layer layer) {
        FeatureIterator reader = null;
        try {
            reader = ((FeatureSource)layer.getResource(FeatureSource.class, null)).getFeatures().features();
        }
        catch (Throwable throwable) {
            return null;
        }
        try {
            SimpleFeature simpleFeature = (SimpleFeature)reader.next();
            return simpleFeature;
        }
        catch (Throwable throwable) {
            return null;
        }
        finally {
            reader.close();
        }
    }

    public Image createGlyph(Layer layer, Style styleObject) {
        int width = 16;
        int height = 16;
        Image image = new Image((Device)Display.getDefault(), width, height);
        SimpleFeature feature = this.sampleFeature(layer);
        ViewportGraphics graphics = Drawing.createGraphics((GC)new GC((Drawable)image), (Display)Display.getDefault(), (Dimension)new Dimension(width - 1, width - 1));
        graphics.clearRect(0, 0, width, height);
        AffineTransform transform = Drawing.worldToScreenTransform((BoundingBox)feature.getBounds(), (Rectangle)new Rectangle(1, 0, width - 1, width - 1));
        Drawing.create().drawFeature(graphics, feature, transform, styleObject);
        return image;
    }

    public Object createGlyph(Layer layer) {
        try {
            ImageDescriptor glyph;
            if (layer.isType(WebMapServer.class) && (glyph = this.createWMSGylph(layer)) != null) {
                return glyph;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return ProjectEditPlugin.INSTANCE.getImage("full/obj16/Layer");
    }
}

