/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.provider;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.refractions.udig.project.internal.provider.AbstractLazyLoadingItemProvider;
import net.refractions.udig.project.internal.provider.ChildFetcherScheduleRule;
import net.refractions.udig.project.internal.provider.ProjectEditPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

class ChildFetcher
extends Job {
    private AbstractLazyLoadingItemProvider provider;
    int childIndex;
    Object next;
    private volatile List<Object> childrenInternal;
    Object parent;
    protected volatile boolean dataReady;

    private ChildFetcher() {
        super("Fetcher");
        this.setSystem(true);
        this.setPriority(50);
    }

    public ChildFetcher(AbstractLazyLoadingItemProvider provider) {
        this();
        this.provider = provider;
        this.setRule(new ChildFetcherScheduleRule());
        this.reset();
    }

    protected Object next() {
        Object tmp = this.next;
        this.next = null;
        return tmp;
    }

    protected boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        try {
            this.next = this.provider.getChild(this.parent, this.childIndex);
        }
        catch (Throwable e) {
            ProjectEditPlugin.log("Error obtaining next child...", e);
        }
        ++this.childIndex;
        return this.next != null;
    }

    protected IStatus run(IProgressMonitor monitor) {
        long start = System.currentTimeMillis();
        while (this.hasNext()) {
            try {
                Object child = this.next();
                if (this.childrenInternal.contains(child)) continue;
                this.childrenInternal.add(this.childrenInternal.size() - 1, child);
                if (System.currentTimeMillis() - start <= 1000L) continue;
                start = System.currentTimeMillis();
                this.dataReady = true;
                this.notifyChanged();
            }
            catch (Exception exception) {
                return Status.OK_STATUS;
            }
        }
        this.childrenInternal = null;
        this.dataReady = true;
        this.notifyChanged();
        return Status.OK_STATUS;
    }

    protected void notifyChanged() {
        this.provider.notifyChanged((Notification)new ENotificationImpl((InternalEObject)this.parent, 1, 1, null, null));
    }

    public void reset() {
        this.childIndex = 0;
        this.next = null;
        this.dataReady = false;
        this.childrenInternal = new CopyOnWriteArrayList<Object>();
        this.childrenInternal.add(this.provider.getLoadingItem());
    }

    public Collection getChildren() {
        if (this.childrenInternal == null) {
            return this.provider.getConcreteChildren(this.parent);
        }
        return this.childrenInternal;
    }
}

