/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.catalog.kml.core;

import com.vividsolutions.jts.geom.Geometry;
import eu.udig.catalog.kml.internal.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.kml.KML;
import org.geotools.kml.KMLConfiguration;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.geotools.xml.StreamingParser;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class KmlUtils {
    public static final String[] IGNORED_ATTR = new String[]{"LookAt", "Style", "Region"};
    public static final String KML_FILE_EXTENSION = "kml";
    public static final String KMZ_FILE_EXTENSION = "kmz";
    public static final String[] SUPPORTED_FILE_EXTENSIONS = new String[]{KmlUtils.toFilterExtension("kml"), KmlUtils.toFilterExtension("kmz")};

    public static FeatureCollection<SimpleFeatureType, SimpleFeature> kmlFile2FeatureCollection(File kml) throws Exception {
        SimpleFeature f;
        InputStream inputStream = null;
        if (kml.getName().toLowerCase().endsWith(KMZ_FILE_EXTENSION)) {
            ZipInputStream zis = new ZipInputStream(new FileInputStream(kml));
            ZipEntry entry = zis.getNextEntry();
            while (entry != null && !entry.getName().endsWith(KML_FILE_EXTENSION)) {
                entry = zis.getNextEntry();
            }
            if (entry == null) {
                throw new Exception(Messages.getString("KmlUtils.Error.NoKMLfileInKMZPackage"));
            }
            inputStream = zis;
        } else {
            inputStream = new FileInputStream(kml);
        }
        StreamingParser parser = new StreamingParser((Configuration)new KMLConfiguration(), inputStream, KML.Placemark);
        SimpleFeatureCollection newCollection = FeatureCollections.newCollection();
        int index = 0;
        DefaultGeographicCRS crs = DefaultGeographicCRS.WGS84;
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName(kml.getName());
        b.setCRS((CoordinateReferenceSystem)crs);
        b.add("name", String.class);
        b.add("the_geom", Geometry.class);
        SimpleFeatureType type = b.buildFeatureType();
        SimpleFeatureBuilder builder = new SimpleFeatureBuilder(type);
        while ((f = (SimpleFeature)parser.parse()) != null) {
            Geometry geometry = (Geometry)f.getDefaultGeometry();
            Object nameAttribute = null;
            try {
                nameAttribute = f.getAttribute("name");
            }
            catch (Exception exception) {}
            builder.addAll(new Object[]{nameAttribute, geometry});
            SimpleFeature feature = builder.buildFeature(String.valueOf(type.getTypeName()) + "." + index++);
            newCollection.add((Feature)feature);
        }
        return newCollection;
    }

    public static void writeKml(File kmlFile, FeatureCollection<SimpleFeatureType, SimpleFeature> featureCollection) throws Exception {
        DefaultGeographicCRS epsg4326 = DefaultGeographicCRS.WGS84;
        CoordinateReferenceSystem crs = ((SimpleFeatureType)featureCollection.getSchema()).getCoordinateReferenceSystem();
        MathTransform mtrans = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)epsg4326, (boolean)true);
        SimpleFeatureCollection newCollection = FeatureCollections.newCollection();
        FeatureIterator featuresIterator = featureCollection.features();
        while (featuresIterator.hasNext()) {
            SimpleFeature f = (SimpleFeature)featuresIterator.next();
            Geometry g = (Geometry)f.getDefaultGeometry();
            if (!mtrans.isIdentity()) {
                g = JTS.transform((Geometry)g, (MathTransform)mtrans);
            }
            f.setDefaultGeometry((Object)g);
            newCollection.add((Feature)f);
        }
        OutputStream fos = null;
        try {
            if (kmlFile.getName().toLowerCase().endsWith(KMZ_FILE_EXTENSION)) {
                String fileName = kmlFile.getName();
                String entryName = fileName.replace(KMZ_FILE_EXTENSION, KML_FILE_EXTENSION);
                ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(kmlFile));
                zos.putNextEntry(new ZipEntry(entryName));
                fos = zos;
            } else {
                fos = new FileOutputStream(kmlFile);
            }
            Encoder encoder = new Encoder((Configuration)new KMLConfiguration());
            encoder.setIndenting(true);
            encoder.encode((Object)newCollection, KML.kml, fos);
        }
        finally {
            if (fos != null) {
                fos.close();
                fos = null;
            }
        }
    }

    private static String toFilterExtension(String fileExtension) {
        return "*." + fileExtension;
    }
}

