/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.internal.feature.shapefile;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.refractions.udig.core.MinMaxScaleCalculator;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.render.AbstractRenderMetrics;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.IRenderMetricsFactory;
import net.refractions.udig.render.internal.feature.shapefile.ShapefileFeatureMetricsFactory;
import net.refractions.udig.render.internal.feature.shapefile.ShapefileFeatureRenderer;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.geotools.styling.Style;
import org.geotools.util.Range;

public class ShapefileFeatureMetrics
extends AbstractRenderMetrics {
    protected static List<String> EXPECTED = Collections.unmodifiableList(Arrays.asList("net.refractions.udig.project.view", "net.refractions.udig.style.sld"));

    public ShapefileFeatureMetrics(IRenderContext context2, ShapefileFeatureMetricsFactory factory) {
        super(context2, (IRenderMetricsFactory)factory, EXPECTED);
        ScopedPreferenceStore store = ProjectPlugin.getPlugin().getPreferenceStore();
        boolean antiAliasing = store.getBoolean("antiAliasingPreference");
        this.resolutionMetric = antiAliasing ? 0.5 : 1.0;
        this.latencyMetric = 200L;
        this.timeToDrawMetric = 500L;
    }

    public Renderer createRenderer() {
        ShapefileFeatureRenderer renderer = new ShapefileFeatureRenderer();
        renderer.setContext(this.context);
        renderer.setName(this.context.getLayer().getName());
        return renderer;
    }

    public boolean canStyle(String styleID, Object value) {
        return value != null && value instanceof Style;
    }

    public Set<Range<Double>> getValidScaleRanges() {
        Style style = (Style)this.context.getLayer().getStyleBlackboard().get("net.refractions.udig.style.sld");
        return MinMaxScaleCalculator.getValidScaleRanges((Style)style);
    }
}

