/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.internal.feature.shapefile;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.geotools.renderer.shape.ShapefileRenderer;
import org.osgi.framework.BundleContext;

public class RendererPlugin
extends Plugin {
    private static RendererPlugin plugin;
    public static final String ID = "net.refractions.udig.render.feature.shapefile";

    public RendererPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ShapefileRenderer.class.getClassLoader());
            Logger logger = Logger.getLogger("org.geotools.renderer.shape");
            if (RendererPlugin.isDebugging("net.refractions.udig.render.feature.shapefile/finest")) {
                logger.setLevel(Level.FINEST);
                logger.addHandler(new Handler(){

                    @Override
                    public void publish(LogRecord record) {
                        System.err.println(record.getMessage());
                    }

                    @Override
                    public void flush() {
                        System.err.flush();
                    }

                    @Override
                    public void close() throws SecurityException {
                    }
                });
            } else {
                logger.setLevel(Level.SEVERE);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    public static Plugin getDefault() {
        return plugin;
    }

    public static void log(String message, Throwable e) {
        RendererPlugin.getDefault().getLog().log((IStatus)new Status(1, ID, 0, message, e));
    }

    public static void trace(String message, Throwable e) {
        if (RendererPlugin.getDefault().isDebugging()) {
            if (message != null) {
                System.out.println(message);
            }
            if (e != null) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isDebugging(String trace) {
        return RendererPlugin.getDefault().isDebugging() && "true".equalsIgnoreCase(Platform.getDebugOption((String)trace));
    }
}

