/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageCache {
    public static final String ADD = "icons/add.gif";
    public static final String ADDGROUP = "icons/addgroup.gif";
    public static final String APPLY = "icons/apply.gif";
    public static final String DELETE = "icons/delete.gif";
    public static final String DELETEALL = "icons/deleteall.gif";
    public static final String DOWN = "icons/down.gif";
    public static final String IMPORT = "icons/import.gif";
    public static final String OPEN = "icons/open.gif";
    public static final String UP = "icons/up.gif";
    public static final String SAVE = "icons/save.gif";
    public static final String SAVEALL = "icons/saveall.gif";
    public static final String ONECLICKEXPORT = "icons/export.gif";
    private static ImageCache imageCache;
    private HashMap<String, Image> imageMap = new HashMap();

    private ImageCache() {
    }

    public static ImageCache getInstance() {
        if (imageCache == null) {
            imageCache = new ImageCache();
        }
        return imageCache;
    }

    public Image getImage(String key) {
        Image image = this.imageMap.get(key);
        if (image == null) {
            image = this.createImage(key);
            this.imageMap.put(key, image);
        }
        return image;
    }

    private Image createImage(String key) {
        ImageDescriptor id = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.style.advanced", (String)key);
        Image image = id.createImage();
        return image;
    }

    public void dispose() {
        Set<Map.Entry<String, Image>> entrySet = this.imageMap.entrySet();
        for (Map.Entry<String, Image> entry : entrySet) {
            entry.getValue().dispose();
        }
        this.imageMap.clear();
    }
}

