/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.utils;

public enum Alignments {
    TOP("top"),
    MIDDLE("middle"),
    BOTTOM("bottom"),
    LEFT("left"),
    CENTER("center"),
    RIGHT("right");

    private String defString = null;

    private Alignments(String defString) {
        this.defString = defString;
    }

    public static Alignments toAlignment(String defString) {
        Alignments[] values;
        Alignments[] alignmentsArray = values = Alignments.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Alignments vendorOptions = alignmentsArray[n2];
            if (defString.equals(vendorOptions.toString())) {
                return vendorOptions;
            }
            ++n2;
        }
        return null;
    }

    public static Alignments verticalAlignmentfromDouble(String alignment) {
        if (alignment == null) {
            return TOP;
        }
        double align = Double.parseDouble(alignment);
        if (align == 0.0) {
            return TOP;
        }
        if (Math.abs(align - 0.5) < 1.0E-5) {
            return MIDDLE;
        }
        if (align == 1.0) {
            return BOTTOM;
        }
        return TOP;
    }

    public static Alignments horizontalAlignmentfromDouble(String alignment) {
        if (alignment == null) {
            return RIGHT;
        }
        double align = Double.parseDouble(alignment);
        if (align == 0.0) {
            return RIGHT;
        }
        if (Math.abs(align - 0.5) < 1.0E-5) {
            return CENTER;
        }
        if (align == 1.0) {
            return LEFT;
        }
        return RIGHT;
    }

    public double toDouble() {
        switch (this) {
            case TOP: {
                return 0.0;
            }
            case MIDDLE: {
                return 0.5;
            }
            case BOTTOM: {
                return 1.0;
            }
            case LEFT: {
                return 1.0;
            }
            case CENTER: {
                return 0.5;
            }
            case RIGHT: {
                return 0.0;
            }
        }
        return 0.5;
    }

    public int toIndex() {
        switch (this) {
            case TOP: {
                return 0;
            }
            case MIDDLE: {
                return 1;
            }
            case BOTTOM: {
                return 2;
            }
            case RIGHT: {
                return 0;
            }
            case CENTER: {
                return 1;
            }
            case LEFT: {
                return 2;
            }
        }
        return 1;
    }

    public String toString() {
        return this.defString;
    }

    public static String[] toVerticalStrings() {
        String[] valuesArray = new String[]{TOP.toString(), MIDDLE.toString(), BOTTOM.toString()};
        return valuesArray;
    }

    public static String[] toHorizontalStrings() {
        String[] valuesArray = new String[]{RIGHT.toString(), CENTER.toString(), LEFT.toString()};
        return valuesArray;
    }
}

