/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.raster;

import eu.udig.style.advanced.raster.RuleValues;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class PredefinedColorRules {
    private static HashMap<String, String[][]> colorRules = new HashMap();
    public static final String[][] rainbow = new String[][]{{"255", "255", "0"}, {"0", "255", "0"}, {"0", "255", "255"}, {"0", "0", "255"}, {"255", "0", "255"}, {"255", "0", "0"}};

    public static HashMap<String, String[][]> getColorsFolder(boolean doReset) {
        int size = colorRules.size();
        if (!doReset && size > 0) {
            return colorRules;
        }
        try {
            int n;
            colorRules.put("rainbow", rainbow);
            File colorTablesFolder = null;
            Bundle bundle = Platform.getBundle((String)"eu.udig.style.advanced");
            if (bundle != null) {
                URL queriesUrl = bundle.getResource("colortables");
                String colorTablesFolderPath = FileLocator.toFileURL((URL)queriesUrl).getPath();
                colorTablesFolder = new File(colorTablesFolderPath);
            } else {
                File[] listFiles;
                File baseFolder = new File("..");
                File[] fileArray = listFiles = baseFolder.listFiles();
                int n2 = listFiles.length;
                n = 0;
                while (n < n2) {
                    File folder = fileArray[n];
                    String name = folder.getName().toLowerCase();
                    if (name.startsWith("eu.hydrologis.jgrass.libs") && !name.contains("external") && !name.contains("scripting")) {
                        colorTablesFolder = new File(folder, "colortables");
                    }
                    ++n;
                }
            }
            if (colorTablesFolder != null && colorTablesFolder.exists()) {
                File[] files;
                File[] fileArray = files = colorTablesFolder.listFiles();
                n = files.length;
                int n3 = 0;
                while (n3 < n) {
                    File file = fileArray[n3];
                    String name = file.getName();
                    if (name.toLowerCase().endsWith(".clr")) {
                        BufferedReader bR = new BufferedReader(new FileReader(file));
                        ArrayList<String[]> lines = new ArrayList<String[]>();
                        String line = null;
                        int cols = 0;
                        while ((line = bR.readLine()) != null) {
                            if (line.startsWith("#")) continue;
                            String[] lineSplit = line.trim().split("\\s+");
                            cols = lineSplit.length;
                            lines.add(lineSplit);
                        }
                        bR.close();
                        String[][] linesArray = (String[][])lines.toArray((T[])new String[lines.size()][cols]);
                        String ruleName = FilenameUtils.getBaseName((String)file.getName());
                        ruleName = ruleName.replaceAll("\\_", " ");
                        colorRules.put(ruleName, linesArray);
                    }
                    ++n3;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return colorRules;
    }

    public static List<RuleValues> getRulesValuesList(String[][] colorRules, double[] dataRange) throws IOException {
        ArrayList<RuleValues> list = new ArrayList<RuleValues>();
        if (colorRules[0].length == 3) {
            if (dataRange == null) {
                dataRange = new double[]{-100.0, 5000.0};
            }
            float rinc = (float)(dataRange[1] - dataRange[0]) / (float)(colorRules.length - 1);
            int i = 0;
            while (i < colorRules.length - 1) {
                try {
                    double from = dataRange[0] + (double)((float)i * rinc);
                    Color fromColor = new Color(Integer.parseInt(colorRules[i][0]), Integer.parseInt(colorRules[i][1]), Integer.parseInt(colorRules[i][2]));
                    double to = dataRange[0] + (double)((float)(i + 1) * rinc);
                    Color toColor = new Color(Integer.parseInt(colorRules[i + 1][0]), Integer.parseInt(colorRules[i + 1][1]), Integer.parseInt(colorRules[i + 1][2]));
                    RuleValues rV = new RuleValues();
                    rV.fromValue = from;
                    rV.toValue = to;
                    rV.fromColor = fromColor;
                    rV.toColor = toColor;
                    list.add(rV);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        } else {
            if (colorRules[0].length != 8) {
                throw new IOException("The colortable can have records of 3 or 8 columns. Check your colortables.");
            }
            int i = 0;
            while (i < colorRules.length) {
                try {
                    double from = Double.parseDouble(colorRules[i][0]);
                    Color fromColor = new Color(Integer.parseInt(colorRules[i][1]), Integer.parseInt(colorRules[i][2]), Integer.parseInt(colorRules[i][3]));
                    double to = Double.parseDouble(colorRules[i][4]);
                    Color toColor = new Color(Integer.parseInt(colorRules[i][5]), Integer.parseInt(colorRules[i][6]), Integer.parseInt(colorRules[i][7]));
                    RuleValues rV = new RuleValues();
                    rV.fromValue = from;
                    rV.toValue = to;
                    rV.fromColor = fromColor;
                    rV.toColor = toColor;
                    list.add(rV);
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        return list;
    }
}

