/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.polygons.widgets;

import eu.udig.style.advanced.common.IStyleChangesListener;
import eu.udig.style.advanced.common.ParameterComposite;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.TextSymbolizerWrapper;
import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.utils.FontEditor;
import eu.udig.style.advanced.utils.StolenColorEditor;
import eu.udig.style.advanced.utils.Utilities;
import eu.udig.style.advanced.utils.VendorOptions;
import java.awt.Color;
import net.refractions.udig.style.sld.SLD;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.opengis.filter.expression.Literal;

public class PolygonLabelsParametersComposite
extends ParameterComposite {
    private final Composite parent;
    private final String[] numericAttributesArrays;
    private Composite mainComposite;
    private Button labelEnableButton;
    private Spinner labelOpacitySpinner;
    private Combo labelOpacityAttributecombo;
    private Button haloColorButton;
    private StolenColorEditor haloColorEditor;
    private Spinner haloRadiusSpinner;
    private Spinner rotationSpinner;
    private Combo rotationAttributecombo;
    private Text maxDisplacementText;
    private Text autoWrapText;
    private Text spaceAroundText;
    private FontEditor fontEditor;
    private Button fontButton;
    private StolenColorEditor fontColorEditor;
    private Button fontColorButton;
    private String[] allAttributesArrays;
    private Text labelNameText;
    private Combo labelNameAttributecombo;

    public PolygonLabelsParametersComposite(Composite parent, String[] numericAttributesArrays, String[] allAttributesArrays) {
        this.parent = parent;
        this.numericAttributesArrays = numericAttributesArrays;
        this.allAttributesArrays = allAttributesArrays;
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    public void init(RuleWrapper ruleWrapper) {
        int index;
        int index2;
        TextSymbolizerWrapper textSymbolizerWrapper = ruleWrapper.getTextSymbolizersWrapper();
        boolean widgetEnabled = true;
        if (textSymbolizerWrapper == null) {
            widgetEnabled = false;
            TextSymbolizer newSymbolizer = Utilities.createDefaultTextSymbolizer(SLD.POLYGON);
            textSymbolizerWrapper = new TextSymbolizerWrapper((Symbolizer)newSymbolizer, null, SLD.POLYGON);
        }
        this.mainComposite = new Composite(this.parent, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainComposite.setLayout((Layout)new GridLayout(3, true));
        this.labelEnableButton = new Button(this.mainComposite, 32);
        GridData labelEnableButtonGD = new GridData(1, 0x1000000, false, false);
        labelEnableButtonGD.horizontalSpan = 3;
        this.labelEnableButton.setLayoutData((Object)labelEnableButtonGD);
        this.labelEnableButton.setText(Messages.PolygonLabelsParametersComposite_0);
        this.labelEnableButton.setSelection(widgetEnabled);
        this.labelEnableButton.addSelectionListener((SelectionListener)this);
        Label labelNameLabel = new Label(this.mainComposite, 0);
        labelNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        labelNameLabel.setText(Messages.PolygonLabelsParametersComposite_1);
        this.labelNameText = new Text(this.mainComposite, 18436);
        GridData labelNameTextGD = new GridData(4, 0x1000000, true, false);
        this.labelNameText.setLayoutData((Object)labelNameTextGD);
        this.labelNameText.addFocusListener((FocusListener)this);
        this.labelNameAttributecombo = new Combo(this.mainComposite, 12);
        GridData labelNameAttributecomboGD = new GridData(4, 0x1000000, true, false);
        this.labelNameAttributecombo.setLayoutData((Object)labelNameAttributecomboGD);
        this.labelNameAttributecombo.setItems(this.allAttributesArrays);
        this.labelNameAttributecombo.addSelectionListener((SelectionListener)this);
        this.labelNameAttributecombo.select(0);
        String labelName = textSymbolizerWrapper.getLabelName();
        if (labelName != null) {
            int index3 = this.getAttributeIndex(labelName, this.allAttributesArrays);
            if (index3 != -1) {
                this.labelNameAttributecombo.select(index3);
            } else {
                this.labelNameText.setText(labelName);
            }
        } else {
            this.labelNameText.setText("");
        }
        Label labelOpactityLabel = new Label(this.mainComposite, 0);
        labelOpactityLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        labelOpactityLabel.setText(Messages.PolygonLabelsParametersComposite_3);
        this.labelOpacitySpinner = new Spinner(this.mainComposite, 2048);
        this.labelOpacitySpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.labelOpacitySpinner.setMaximum(100);
        this.labelOpacitySpinner.setMinimum(0);
        this.labelOpacitySpinner.setIncrement(10);
        String opacity = textSymbolizerWrapper.getOpacity();
        Double tmpOpacity = this.isDouble(opacity);
        int tmp = 100;
        if (tmpOpacity != null) {
            tmp = (int)(tmpOpacity * 100.0);
        }
        this.labelOpacitySpinner.setSelection(tmp);
        this.labelOpacitySpinner.addSelectionListener((SelectionListener)this);
        this.labelOpacityAttributecombo = new Combo(this.mainComposite, 12);
        this.labelOpacityAttributecombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.labelOpacityAttributecombo.setItems(this.numericAttributesArrays);
        this.labelOpacityAttributecombo.addSelectionListener((SelectionListener)this);
        this.labelOpacityAttributecombo.select(0);
        if (tmpOpacity == null && (index2 = this.getAttributeIndex(opacity, this.numericAttributesArrays)) != -1) {
            this.labelOpacityAttributecombo.select(index2);
        }
        Label rotationLabel = new Label(this.mainComposite, 0);
        rotationLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        rotationLabel.setText(Messages.PolygonLabelsParametersComposite_4);
        this.rotationSpinner = new Spinner(this.mainComposite, 2048);
        this.rotationSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.rotationSpinner.setMaximum(360);
        this.rotationSpinner.setMinimum(-360);
        this.rotationSpinner.setIncrement(45);
        String rotationStr = textSymbolizerWrapper.getRotation();
        Double tmpRotation = this.isDouble(rotationStr);
        tmp = 0;
        if (tmpRotation != null) {
            tmp = tmpRotation.intValue();
        }
        this.rotationSpinner.setSelection(tmp);
        this.rotationSpinner.addSelectionListener((SelectionListener)this);
        this.rotationAttributecombo = new Combo(this.mainComposite, 12);
        this.rotationAttributecombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.rotationAttributecombo.setItems(this.numericAttributesArrays);
        this.rotationAttributecombo.addSelectionListener((SelectionListener)this);
        this.rotationAttributecombo.select(0);
        if (tmpRotation == null && (index = this.getAttributeIndex(rotationStr, this.numericAttributesArrays)) != -1) {
            this.rotationAttributecombo.select(index);
        }
        Label fontLabel = new Label(this.mainComposite, 0);
        fontLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        fontLabel.setText(Messages.PolygonLabelsParametersComposite_5);
        this.fontEditor = new FontEditor(this.mainComposite);
        GridData fontButtonGD = new GridData(4, 4, true, false);
        fontButtonGD.horizontalSpan = 2;
        this.fontButton = this.fontEditor.getButton();
        this.fontButton.setLayoutData((Object)fontButtonGD);
        this.fontEditor.setListener((SelectionListener)this);
        FontData[] fontData = textSymbolizerWrapper.getFontData();
        if (fontData != null) {
            this.fontEditor.setFontList(fontData);
        }
        Label fontColorLabel = new Label(this.mainComposite, 0);
        fontColorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        fontColorLabel.setText(Messages.PolygonLabelsParametersComposite_6);
        this.fontColorEditor = new StolenColorEditor(this.mainComposite, (SelectionListener)this);
        this.fontColorButton = this.fontColorEditor.getButton();
        GridData fontColorButtonGD = new GridData(4, 0x1000000, true, false);
        fontColorButtonGD.horizontalSpan = 2;
        this.fontColorButton.setLayoutData((Object)fontColorButtonGD);
        Color tmpColor = null;
        try {
            tmpColor = Color.decode(textSymbolizerWrapper.getColor());
        }
        catch (Exception exception) {
            tmpColor = Color.black;
        }
        this.fontColorEditor.setColor(tmpColor);
        Label haloLabel = new Label(this.mainComposite, 0);
        haloLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        haloLabel.setText(Messages.PolygonLabelsParametersComposite_7);
        this.haloColorEditor = new StolenColorEditor(this.mainComposite, (SelectionListener)this);
        this.haloColorButton = this.haloColorEditor.getButton();
        GridData haloColorButtonGD = new GridData(4, 0x1000000, true, false);
        this.haloColorButton.setLayoutData((Object)haloColorButtonGD);
        tmpColor = null;
        try {
            tmpColor = Color.decode(textSymbolizerWrapper.getHaloColor());
        }
        catch (Exception exception) {
            tmpColor = Color.black;
        }
        this.haloColorEditor.setColor(tmpColor);
        this.haloRadiusSpinner = new Spinner(this.mainComposite, 2048);
        this.haloRadiusSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.haloRadiusSpinner.setMaximum(20);
        this.haloRadiusSpinner.setMinimum(0);
        this.haloRadiusSpinner.setIncrement(1);
        String haloRadius = textSymbolizerWrapper.getHaloRadius();
        Double tmpRadius = this.isDouble(haloRadius);
        tmp = 0;
        if (tmpRadius != null) {
            tmp = tmpRadius.intValue();
        }
        this.haloRadiusSpinner.setSelection(tmp);
        this.haloRadiusSpinner.addSelectionListener((SelectionListener)this);
        Group vendorOptionsGroup = new Group(this.mainComposite, 16);
        GridData vendorOptionsGD = new GridData(4, 4, true, true);
        vendorOptionsGD.horizontalSpan = 3;
        vendorOptionsGroup.setLayoutData((Object)vendorOptionsGD);
        vendorOptionsGroup.setLayout((Layout)new GridLayout(2, false));
        vendorOptionsGroup.setText(Messages.PolygonLabelsParametersComposite_8);
        Label maxDisplacementLabel = new Label((Composite)vendorOptionsGroup, 0);
        maxDisplacementLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        maxDisplacementLabel.setText(VendorOptions.VENDOROPTION_MAXDISPLACEMENT.toGuiString());
        this.maxDisplacementText = new Text((Composite)vendorOptionsGroup, 18436);
        GridData maxDisplacementTextGD = new GridData(4, 0x1000000, true, false);
        this.maxDisplacementText.setLayoutData((Object)maxDisplacementTextGD);
        this.maxDisplacementText.addFocusListener((FocusListener)this);
        String maxDisplacementVO = textSymbolizerWrapper.getMaxDisplacementVO();
        if (maxDisplacementVO != null) {
            this.maxDisplacementText.setText(maxDisplacementVO);
        } else {
            this.maxDisplacementText.setText("");
        }
        Label autoWrapLabel = new Label((Composite)vendorOptionsGroup, 0);
        autoWrapLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        autoWrapLabel.setText(VendorOptions.VENDOROPTION_AUTOWRAP.toGuiString());
        this.autoWrapText = new Text((Composite)vendorOptionsGroup, 18436);
        GridData autoWrapTextGD = new GridData(4, 0x1000000, true, false);
        this.autoWrapText.setLayoutData((Object)autoWrapTextGD);
        this.autoWrapText.addFocusListener((FocusListener)this);
        String autoWrapVO = textSymbolizerWrapper.getAutoWrapVO();
        if (autoWrapVO != null) {
            this.autoWrapText.setText(autoWrapVO);
        } else {
            this.autoWrapText.setText("");
        }
        Label spaceAroundLabel = new Label((Composite)vendorOptionsGroup, 0);
        spaceAroundLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        spaceAroundLabel.setText(VendorOptions.VENDOROPTION_SPACEAROUND.toGuiString());
        this.spaceAroundText = new Text((Composite)vendorOptionsGroup, 18436);
        GridData spaceAroundTextGD = new GridData(4, 0x1000000, true, false);
        this.spaceAroundText.setLayoutData((Object)spaceAroundTextGD);
        this.spaceAroundText.addFocusListener((FocusListener)this);
        String spaceAroundVO = textSymbolizerWrapper.getSpaceAroundVO();
        if (spaceAroundVO != null) {
            this.spaceAroundText.setText(spaceAroundVO);
        } else {
            this.spaceAroundText.setText("");
        }
        this.checkEnablements();
    }

    public void update(RuleWrapper ruleWrapper) {
        String maxDisplacementVO;
        int index;
        int index2;
        String color;
        TextSymbolizerWrapper textSymbolizerWrapper = ruleWrapper.getTextSymbolizersWrapper();
        if (textSymbolizerWrapper == null) {
            this.labelEnableButton.setSelection(false);
            return;
        }
        this.labelEnableButton.setSelection(true);
        String labelName = textSymbolizerWrapper.getLabelName();
        if (labelName != null) {
            int index3 = this.getAttributeIndex(labelName, this.allAttributesArrays);
            if (index3 != -1) {
                this.labelNameAttributecombo.select(index3);
            } else {
                this.labelNameText.setText(labelName);
            }
        } else {
            this.labelNameText.setText("");
        }
        FontData[] fontData = textSymbolizerWrapper.getFontData();
        if (fontData != null) {
            this.fontEditor.setFontList(fontData);
        }
        if ((color = textSymbolizerWrapper.getColor()) != null) {
            this.fontColorEditor.setColor(Color.decode(color));
        }
        String opacity = textSymbolizerWrapper.getOpacity();
        Double tmpOpacity = this.isDouble(opacity);
        int tmp = 100;
        if (tmpOpacity != null) {
            tmp = (int)(tmpOpacity * 100.0);
        }
        this.labelOpacitySpinner.setSelection(tmp);
        if (tmpOpacity == null && (index2 = this.getAttributeIndex(opacity, this.numericAttributesArrays)) != -1) {
            this.labelOpacityAttributecombo.select(index2);
        }
        Color tmpColor = null;
        try {
            tmpColor = Color.decode(textSymbolizerWrapper.getHaloColor());
        }
        catch (Exception exception) {
            tmpColor = Color.black;
        }
        this.haloColorEditor.setColor(tmpColor);
        String haloRadius = textSymbolizerWrapper.getHaloRadius();
        Double tmpRadius = this.isDouble(haloRadius);
        tmp = 0;
        if (tmpRadius != null) {
            tmp = tmpRadius.intValue();
        }
        this.haloRadiusSpinner.setSelection(tmp);
        String rotationStr = textSymbolizerWrapper.getRotation();
        Double tmpRotation = this.isDouble(rotationStr);
        tmp = 0;
        if (tmpRotation != null) {
            tmp = tmpRotation.intValue();
        }
        this.rotationSpinner.setSelection(tmp);
        if (tmpRotation == null && (index = this.getAttributeIndex(rotationStr, this.numericAttributesArrays)) != -1) {
            this.rotationAttributecombo.select(index);
        }
        if ((maxDisplacementVO = textSymbolizerWrapper.getMaxDisplacementVO()) != null) {
            this.maxDisplacementText.setText(maxDisplacementVO);
        } else {
            this.maxDisplacementText.setText("");
        }
        String autoWrapVO = textSymbolizerWrapper.getAutoWrapVO();
        if (autoWrapVO != null) {
            this.autoWrapText.setText(autoWrapVO);
        } else {
            this.autoWrapText.setText("");
        }
        String spaceAroundVO = textSymbolizerWrapper.getSpaceAroundVO();
        if (spaceAroundVO != null) {
            this.spaceAroundText.setText(spaceAroundVO);
        } else {
            this.spaceAroundText.setText("");
        }
        this.checkEnablements();
    }

    private void checkEnablements() {
        boolean comboIsNone = this.comboIsNone(this.labelNameAttributecombo);
        boolean selected = this.labelEnableButton.getSelection();
        if (!selected) {
            this.setEnabled(false);
        } else {
            this.labelNameText.setEnabled(comboIsNone);
            comboIsNone = this.comboIsNone(this.labelOpacityAttributecombo);
            this.labelOpacitySpinner.setEnabled(comboIsNone);
            comboIsNone = this.comboIsNone(this.rotationAttributecombo);
            this.rotationSpinner.setEnabled(comboIsNone);
        }
    }

    private void setEnabled(boolean enable) {
        this.labelOpacitySpinner.setEnabled(enable);
        this.labelOpacityAttributecombo.setEnabled(enable);
        this.haloColorButton.setEnabled(enable);
        this.haloColorEditor.setEnabled(enable);
        this.haloRadiusSpinner.setEnabled(enable);
        this.rotationSpinner.setEnabled(enable);
        this.rotationAttributecombo.setEnabled(enable);
        this.maxDisplacementText.setEnabled(enable);
        this.autoWrapText.setEnabled(enable);
        this.spaceAroundText.setEnabled(enable);
        this.fontEditor.setEnabled(enable);
        this.fontButton.setEnabled(enable);
        this.fontColorEditor.setEnabled(enable);
        this.fontColorButton.setEnabled(enable);
        this.labelNameText.setEnabled(enable);
        this.labelNameAttributecombo.setEnabled(enable);
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.labelEnableButton)) {
            boolean selected = this.labelEnableButton.getSelection();
            this.setEnabled(this.labelEnableButton.getSelection());
            this.notifyListeners(String.valueOf(selected), false, IStyleChangesListener.STYLEEVENTTYPE.LABELENABLE);
        } else if (source.equals(this.labelNameAttributecombo)) {
            boolean comboIsNone = this.comboIsNone(this.labelNameAttributecombo);
            if (comboIsNone) {
                String text = this.labelNameText.getText();
                this.notifyListeners(text, false, IStyleChangesListener.STYLEEVENTTYPE.LABEL);
            } else {
                int index = this.labelNameAttributecombo.getSelectionIndex();
                String nameField = this.labelNameAttributecombo.getItem(index);
                this.notifyListeners(nameField, true, IStyleChangesListener.STYLEEVENTTYPE.LABEL);
            }
        } else if (source.equals(this.fontButton)) {
            FontData[] fontData = this.fontEditor.getFontList();
            if (fontData.length > 0) {
                FontData fd = fontData[0];
                String name = fd.getName();
                String style = String.valueOf(fd.getStyle());
                String height = String.valueOf(fd.getHeight());
                Color color = this.fontEditor.getAWTColor();
                Literal colorExpr = Utilities.ff.literal((Object)color);
                String fontColor = (String)colorExpr.evaluate(null, String.class);
                this.notifyListeners(new String[]{name, style, height, fontColor}, false, IStyleChangesListener.STYLEEVENTTYPE.LABELFONT);
            }
        } else if (source.equals(this.fontColorButton)) {
            Color color = this.fontColorEditor.getColor();
            Literal colorExpr = Utilities.ff.literal((Object)color);
            String fontColor = (String)colorExpr.evaluate(null, String.class);
            this.notifyListeners(fontColor, false, IStyleChangesListener.STYLEEVENTTYPE.LABELCOLOR);
        } else if (source.equals(this.haloColorButton)) {
            Color color = this.haloColorEditor.getColor();
            Literal colorExpr = Utilities.ff.literal((Object)color);
            String haloColor = (String)colorExpr.evaluate(null, String.class);
            this.notifyListeners(haloColor, false, IStyleChangesListener.STYLEEVENTTYPE.LABELHALOCOLOR);
        } else if (source.equals(this.haloRadiusSpinner)) {
            int radius = this.haloRadiusSpinner.getSelection();
            this.notifyListeners(String.valueOf(radius), false, IStyleChangesListener.STYLEEVENTTYPE.LABELHALORADIUS);
        } else if (source.equals(this.rotationSpinner) || source.equals(this.rotationAttributecombo)) {
            boolean comboIsNone = this.comboIsNone(this.rotationAttributecombo);
            if (comboIsNone) {
                int rotation = this.rotationSpinner.getSelection();
                String rotationStr = String.valueOf(rotation);
                this.notifyListeners(rotationStr, false, IStyleChangesListener.STYLEEVENTTYPE.LABELROTATION);
            } else {
                int index = this.rotationAttributecombo.getSelectionIndex();
                String rotationField = this.rotationAttributecombo.getItem(index);
                this.notifyListeners(rotationField, true, IStyleChangesListener.STYLEEVENTTYPE.LABELROTATION);
            }
        } else if (source.equals(this.labelOpacitySpinner) || source.equals(this.labelOpacityAttributecombo)) {
            boolean comboIsNone = this.comboIsNone(this.labelOpacityAttributecombo);
            if (comboIsNone) {
                int opacity = this.labelOpacitySpinner.getSelection();
                String opacityStr = String.valueOf(opacity);
                this.notifyListeners(opacityStr, false, IStyleChangesListener.STYLEEVENTTYPE.LABELOPACITY);
            } else {
                int index = this.labelOpacityAttributecombo.getSelectionIndex();
                String opacityField = this.labelOpacityAttributecombo.getItem(index);
                this.notifyListeners(opacityField, true, IStyleChangesListener.STYLEEVENTTYPE.LABELOPACITY);
            }
        }
        this.checkEnablements();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        if (source.equals(this.maxDisplacementText)) {
            String text = this.maxDisplacementText.getText();
            this.notifyListeners(text, false, IStyleChangesListener.STYLEEVENTTYPE.LABELMAXDISPLACEMENT_VO);
        } else if (source.equals(this.spaceAroundText)) {
            String text = this.spaceAroundText.getText();
            this.notifyListeners(text, false, IStyleChangesListener.STYLEEVENTTYPE.LABELSPACEAROUND_VO);
        } else if (source.equals(this.autoWrapText)) {
            String text = this.autoWrapText.getText();
            this.notifyListeners(text, false, IStyleChangesListener.STYLEEVENTTYPE.LABELAUTOWRAP_VO);
        } else if (source.equals(this.labelNameText)) {
            String text = this.labelNameText.getText();
            this.notifyListeners(text, false, IStyleChangesListener.STYLEEVENTTYPE.LABEL);
        }
        this.checkEnablements();
    }
}

