/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.polygons.widgets;

import eu.udig.style.advanced.common.IStyleChangesListener;
import eu.udig.style.advanced.common.ParameterComposite;
import eu.udig.style.advanced.common.styleattributeclasses.PolygonSymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.utils.Utilities;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class PolygonGeneralParametersComposite
extends ParameterComposite {
    private final Composite parent;
    private Text nameText;
    private Spinner xOffsetSpinner;
    private Spinner yOffsetSpinner;
    private Text maxScaleText;
    private Text minScaleText;
    private Composite mainComposite;

    public PolygonGeneralParametersComposite(Composite parent, String[] numericAttributesArrays) {
        this.parent = parent;
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    public void init(RuleWrapper ruleWrapper) {
        PolygonSymbolizerWrapper polygonSymbolizerWrapper = ruleWrapper.getGeometrySymbolizersWrapper().adapt(PolygonSymbolizerWrapper.class);
        this.mainComposite = new Composite(this.parent, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainComposite.setLayout((Layout)new GridLayout(3, true));
        Label nameLabel = new Label(this.mainComposite, 0);
        nameLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        nameLabel.setText(Messages.PolygonGeneralParametersComposite_0);
        this.nameText = new Text(this.mainComposite, 18436);
        GridData nameTextGD = new GridData(4, 0x1000000, true, false);
        nameTextGD.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)nameTextGD);
        this.nameText.setText(ruleWrapper.getName());
        this.nameText.addFocusListener((FocusListener)this);
        Label offsetLabel = new Label(this.mainComposite, 0);
        GridData offsetLabelGD = new GridData(4, 0x1000000, true, false);
        offsetLabel.setLayoutData((Object)offsetLabelGD);
        offsetLabel.setText(Messages.PolygonGeneralParametersComposite_1);
        String xOffset = polygonSymbolizerWrapper.getxOffset();
        String yOffset = polygonSymbolizerWrapper.getyOffset();
        Integer tmpXOffset = Utilities.isNumber(xOffset, Integer.class);
        Integer tmpYOffset = Utilities.isNumber(yOffset, Integer.class);
        if (tmpXOffset == null || tmpYOffset == null) {
            tmpXOffset = 0;
            tmpYOffset = 0;
        }
        this.xOffsetSpinner = new Spinner(this.mainComposite, 2048);
        this.xOffsetSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.xOffsetSpinner.setMaximum(1000);
        this.xOffsetSpinner.setMinimum(-1000);
        this.xOffsetSpinner.setIncrement(10);
        this.xOffsetSpinner.setSelection(10 * tmpXOffset);
        this.xOffsetSpinner.setDigits(1);
        this.xOffsetSpinner.addSelectionListener((SelectionListener)this);
        this.yOffsetSpinner = new Spinner(this.mainComposite, 2048);
        this.yOffsetSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.yOffsetSpinner.setMaximum(1000);
        this.yOffsetSpinner.setMinimum(-1000);
        this.yOffsetSpinner.setIncrement(10);
        this.yOffsetSpinner.setSelection(10 * tmpYOffset);
        this.yOffsetSpinner.setDigits(1);
        this.yOffsetSpinner.addSelectionListener((SelectionListener)this);
        Label maxScaleLabel = new Label(this.mainComposite, 0);
        GridData maxScaleLabelGD = new GridData(4, 0x1000000, true, false);
        maxScaleLabel.setLayoutData((Object)maxScaleLabelGD);
        maxScaleLabel.setText(Messages.PolygonGeneralParametersComposite_2);
        this.maxScaleText = new Text(this.mainComposite, 18436);
        GridData maxScaleTextSIMPLEGD = new GridData(4, 0x1000000, true, false);
        maxScaleTextSIMPLEGD.horizontalSpan = 2;
        this.maxScaleText.setLayoutData((Object)maxScaleTextSIMPLEGD);
        this.maxScaleText.setText(ruleWrapper.getMaxScale());
        this.maxScaleText.addKeyListener((KeyListener)this);
        Label minScaleLabel = new Label(this.mainComposite, 0);
        GridData minScaleLabelGD = new GridData(4, 0x1000000, true, false);
        minScaleLabel.setLayoutData((Object)minScaleLabelGD);
        minScaleLabel.setText(Messages.PolygonGeneralParametersComposite_3);
        this.minScaleText = new Text(this.mainComposite, 18436);
        GridData mainScaleTextSIMPLEGD = new GridData(4, 0x1000000, true, false);
        mainScaleTextSIMPLEGD.horizontalSpan = 2;
        this.minScaleText.setLayoutData((Object)mainScaleTextSIMPLEGD);
        this.minScaleText.setText(ruleWrapper.getMinScale());
        this.minScaleText.addKeyListener((KeyListener)this);
    }

    public void update(RuleWrapper ruleWrapper) {
        PolygonSymbolizerWrapper polygonSymbolizerWrapper = ruleWrapper.getGeometrySymbolizersWrapper().adapt(PolygonSymbolizerWrapper.class);
        this.nameText.setText(ruleWrapper.getName());
        String xOffset = polygonSymbolizerWrapper.getxOffset();
        String yOffset = polygonSymbolizerWrapper.getyOffset();
        Double tmpXOffset = Utilities.isNumber(xOffset, Double.class);
        Double tmpYOffset = Utilities.isNumber(yOffset, Double.class);
        if (tmpXOffset == null || tmpYOffset == null) {
            tmpXOffset = 0.0;
            tmpYOffset = 0.0;
        }
        this.xOffsetSpinner.setSelection((int)(10.0 * tmpXOffset));
        this.yOffsetSpinner.setSelection((int)(10.0 * tmpYOffset));
        Double maxScaleDouble = this.isDouble(ruleWrapper.getMaxScale());
        if (maxScaleDouble == null || Double.isInfinite(maxScaleDouble)) {
            this.maxScaleText.setText("");
        } else {
            this.maxScaleText.setText(String.valueOf(maxScaleDouble));
        }
        Double minScaleDouble = this.isDouble(ruleWrapper.getMinScale());
        if (minScaleDouble == null || minScaleDouble == 0.0) {
            this.minScaleText.setText("");
        } else {
            this.minScaleText.setText(String.valueOf(minScaleDouble));
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.xOffsetSpinner) || source.equals(this.yOffsetSpinner)) {
            double x = Utilities.getDoubleSpinnerSelection(this.xOffsetSpinner);
            double y = Utilities.getDoubleSpinnerSelection(this.yOffsetSpinner);
            String offsetStr = String.valueOf(x) + "," + y;
            this.notifyListeners(offsetStr, false, IStyleChangesListener.STYLEEVENTTYPE.OFFSET);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Object source = e.getSource();
        if (source.equals(this.maxScaleText)) {
            String maxScale = this.maxScaleText.getText();
            this.notifyListeners(maxScale, false, IStyleChangesListener.STYLEEVENTTYPE.MAXSCALE);
        } else if (source.equals(this.minScaleText)) {
            String minScale = this.minScaleText.getText();
            this.notifyListeners(minScale, false, IStyleChangesListener.STYLEEVENTTYPE.MINSCALE);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        if (source.equals(this.nameText)) {
            String text = this.nameText.getText();
            this.notifyListeners(text, false, IStyleChangesListener.STYLEEVENTTYPE.NAME);
        }
    }
}

