/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.polygons.widgets;

import eu.udig.style.advanced.common.IStyleChangesListener;
import eu.udig.style.advanced.common.ParameterComposite;
import eu.udig.style.advanced.common.styleattributeclasses.PolygonSymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.utils.StolenColorEditor;
import eu.udig.style.advanced.utils.Utilities;
import java.awt.Color;
import java.io.File;
import java.net.MalformedURLException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.opengis.filter.expression.Literal;

public class PolygonFillParametersComposite
extends ParameterComposite
implements ModifyListener {
    private final Composite parent;
    private final String[] numericAttributesArrays;
    private Composite mainComposite;
    private Button fillEnableButton;
    private StolenColorEditor fillColorEditor;
    private Button fillColorButton;
    private Spinner fillOpacitySpinner;
    private Combo fillOpacityAttributecombo;
    private Combo wkmarkNameCombo;
    private Spinner wkmWidthSpinner;
    private StolenColorEditor wkmColorEditor;
    private Text graphicsPathText;
    private Button wkmColorButton;
    private Spinner wkmSizeSpinner;
    private final String[] stringAttributesArrays;
    private Combo fillColorAttributecombo;

    public PolygonFillParametersComposite(Composite parent, String[] numericAttributesArrays, String[] stringAttributesArrays) {
        this.parent = parent;
        this.numericAttributesArrays = numericAttributesArrays;
        this.stringAttributesArrays = stringAttributesArrays;
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    public void init(RuleWrapper ruleWrapper) {
        int index;
        Color tmpWkmColor;
        int index2;
        PolygonSymbolizerWrapper polygonSymbolizerWrapper = ruleWrapper.getGeometrySymbolizersWrapper().adapt(PolygonSymbolizerWrapper.class);
        this.mainComposite = new Composite(this.parent, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainComposite.setLayout((Layout)new GridLayout(3, true));
        boolean widgetEnabled = polygonSymbolizerWrapper.hasFill();
        this.fillEnableButton = new Button(this.mainComposite, 32);
        GridData fillEnableButtonGD = new GridData(1, 0x1000000, false, false);
        fillEnableButtonGD.horizontalSpan = 3;
        this.fillEnableButton.setLayoutData((Object)fillEnableButtonGD);
        this.fillEnableButton.setText(Messages.PolygonFillParametersComposite_0);
        this.fillEnableButton.setSelection(widgetEnabled);
        this.fillEnableButton.addSelectionListener((SelectionListener)this);
        Label colorLabel = new Label(this.mainComposite, 16);
        colorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        colorLabel.setText(Messages.PolygonFillParametersComposite_1);
        String color = polygonSymbolizerWrapper.getFillColor();
        Color tmpColor = null;
        try {
            tmpColor = Color.decode(color);
        }
        catch (Exception exception) {
            tmpColor = Color.gray;
        }
        this.fillColorEditor = new StolenColorEditor(this.mainComposite, (SelectionListener)this);
        this.fillColorEditor.setColor(tmpColor);
        this.fillColorButton = this.fillColorEditor.getButton();
        GridData fillColorButtonGD = new GridData(4, 0x1000000, true, false);
        this.fillColorButton.setLayoutData((Object)fillColorButtonGD);
        this.fillColorAttributecombo = new Combo(this.mainComposite, 12);
        this.fillColorAttributecombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fillColorAttributecombo.setItems(this.stringAttributesArrays);
        this.fillColorAttributecombo.addSelectionListener((SelectionListener)this);
        this.fillColorAttributecombo.select(0);
        if (tmpColor == null && (index2 = this.getAttributeIndex(color, this.stringAttributesArrays)) != -1) {
            this.fillColorAttributecombo.select(index2);
        }
        Label graphicsFillLabel = new Label(this.mainComposite, 16);
        graphicsFillLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        graphicsFillLabel.setText(Messages.PolygonFillParametersComposite_2);
        Composite pathComposite = new Composite(this.mainComposite, 0);
        GridData pathCompositeGD = new GridData(4, 4, true, false);
        pathCompositeGD.horizontalSpan = 2;
        pathComposite.setLayoutData((Object)pathCompositeGD);
        GridLayout pathLayout = new GridLayout(2, false);
        pathLayout.marginWidth = 0;
        pathLayout.marginHeight = 0;
        pathComposite.setLayout((Layout)pathLayout);
        this.graphicsPathText = new Text(pathComposite, 18436);
        this.graphicsPathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        try {
            this.graphicsPathText.setText(polygonSymbolizerWrapper.getFillExternalGraphicFillPath());
        }
        catch (Exception exception) {
            this.graphicsPathText.setText("");
        }
        this.graphicsPathText.addModifyListener((ModifyListener)this);
        Button pathButton = new Button(pathComposite, 8);
        pathButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        pathButton.setText("...");
        pathButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fileDialog = new FileDialog(PolygonFillParametersComposite.this.graphicsPathText.getShell(), 4096);
                String path = fileDialog.open();
                if (path == null || path.length() < 1) {
                    PolygonFillParametersComposite.this.graphicsPathText.setText("");
                } else {
                    PolygonFillParametersComposite.this.graphicsPathText.setText(path);
                }
            }
        });
        Label wkmLabel = new Label(this.mainComposite, 16);
        wkmLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        wkmLabel.setText(Messages.PolygonFillParametersComposite_3);
        this.wkmarkNameCombo = new Combo(this.mainComposite, 12);
        GridData wkmarkNameComboGD = new GridData(4, 4, false, false);
        wkmarkNameComboGD.horizontalSpan = 2;
        this.wkmarkNameCombo.setLayoutData((Object)wkmarkNameComboGD);
        this.wkmarkNameCombo.setItems(Utilities.getAllMarksArray());
        this.wkmarkNameCombo.addSelectionListener((SelectionListener)this);
        String wkMarkNameFill = polygonSymbolizerWrapper.getWkMarkNameFill();
        int attributeIndex = this.getAttributeIndex(wkMarkNameFill, Utilities.getAllMarksArray());
        if (attributeIndex != -1) {
            this.wkmarkNameCombo.select(attributeIndex);
        }
        new Label(this.mainComposite, 0);
        Composite wkmarkComposite = new Composite(this.mainComposite, 0);
        GridData wkmarkCompositeGD = new GridData(4, 4, true, false);
        wkmarkCompositeGD.horizontalSpan = 2;
        wkmarkComposite.setLayoutData((Object)wkmarkCompositeGD);
        GridLayout wkmarkCompositeLayout = new GridLayout(3, false);
        wkmarkCompositeLayout.marginWidth = 0;
        wkmarkCompositeLayout.marginHeight = 0;
        wkmarkComposite.setLayout((Layout)wkmarkCompositeLayout);
        this.wkmWidthSpinner = new Spinner(wkmarkComposite, 2048);
        this.wkmWidthSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.wkmWidthSpinner.setMaximum(200);
        this.wkmWidthSpinner.setMinimum(0);
        this.wkmWidthSpinner.setIncrement(1);
        this.wkmWidthSpinner.setToolTipText(Messages.PolygonFillParametersComposite_4);
        String wkMarkWidth = polygonSymbolizerWrapper.getWkMarkWidthFill();
        Double tmpWidth = this.isDouble(wkMarkWidth);
        int tmpWidthInt = 1;
        if (tmpWidth != null) {
            tmpWidthInt = tmpWidth.intValue();
        }
        this.wkmWidthSpinner.setSelection(tmpWidthInt * 10);
        this.wkmWidthSpinner.setDigits(1);
        this.wkmWidthSpinner.addSelectionListener((SelectionListener)this);
        this.wkmSizeSpinner = new Spinner(wkmarkComposite, 2048);
        this.wkmSizeSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.wkmSizeSpinner.setMaximum(1000);
        this.wkmSizeSpinner.setMinimum(0);
        this.wkmSizeSpinner.setIncrement(1);
        this.wkmSizeSpinner.setToolTipText(Messages.PolygonFillParametersComposite_5);
        String wkMarkSize = polygonSymbolizerWrapper.getWkMarkSizeFill();
        Double tmpSize = this.isDouble(wkMarkSize);
        int tmpSizeInt = 5;
        if (tmpSize != null) {
            tmpSizeInt = tmpSize.intValue();
        }
        this.wkmSizeSpinner.setSelection(tmpSizeInt * 10);
        this.wkmSizeSpinner.setDigits(1);
        this.wkmSizeSpinner.addSelectionListener((SelectionListener)this);
        String wkMarkColor = polygonSymbolizerWrapper.getWkMarkColorFill();
        try {
            tmpWkmColor = Color.decode(wkMarkColor);
        }
        catch (Exception exception) {
            tmpWkmColor = Color.gray;
        }
        this.wkmColorEditor = new StolenColorEditor(wkmarkComposite, (SelectionListener)this);
        this.wkmColorEditor.setColor(tmpWkmColor);
        this.wkmColorButton = this.wkmColorEditor.getButton();
        GridData wkmColorButtonGD = new GridData(4, 0x1000000, true, false);
        this.wkmColorButton.setLayoutData((Object)wkmColorButtonGD);
        new Label(this.mainComposite, 0);
        Label valueLabel = new Label(this.mainComposite, 0);
        valueLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        valueLabel.setText(Messages.PolygonFillParametersComposite_6);
        Label fieldsLabel = new Label(this.mainComposite, 0);
        fieldsLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        fieldsLabel.setText(Messages.PolygonFillParametersComposite_7);
        Label fillOpactityLabel = new Label(this.mainComposite, 0);
        fillOpactityLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        fillOpactityLabel.setText(Messages.PolygonFillParametersComposite_8);
        this.fillOpacitySpinner = new Spinner(this.mainComposite, 2048);
        this.fillOpacitySpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fillOpacitySpinner.setMaximum(100);
        this.fillOpacitySpinner.setMinimum(0);
        this.fillOpacitySpinner.setIncrement(10);
        String opacity = polygonSymbolizerWrapper.getFillOpacity();
        Double tmpOpacity = this.isDouble(opacity);
        int tmp = 100;
        if (tmpOpacity != null) {
            tmp = (int)(tmpOpacity * 100.0);
        }
        this.fillOpacitySpinner.setSelection(tmp);
        this.fillOpacitySpinner.addSelectionListener((SelectionListener)this);
        this.fillOpacityAttributecombo = new Combo(this.mainComposite, 12);
        this.fillOpacityAttributecombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fillOpacityAttributecombo.setItems(this.numericAttributesArrays);
        this.fillOpacityAttributecombo.addSelectionListener((SelectionListener)this);
        this.fillOpacityAttributecombo.select(0);
        if (tmpOpacity == null && (index = this.getAttributeIndex(opacity, this.numericAttributesArrays)) != -1) {
            this.fillOpacityAttributecombo.select(index);
        }
        this.checkEnablements();
    }

    public void update(RuleWrapper ruleWrapper) {
        int index;
        Color tmpWkmColor;
        PolygonSymbolizerWrapper polygonSymbolizerWrapper = ruleWrapper.getGeometrySymbolizersWrapper().adapt(PolygonSymbolizerWrapper.class);
        boolean widgetEnabled = polygonSymbolizerWrapper.hasFill();
        this.fillEnableButton.setSelection(widgetEnabled);
        String color = polygonSymbolizerWrapper.getFillColor();
        Color tmpColor = null;
        try {
            tmpColor = Color.decode(color);
        }
        catch (Exception exception) {}
        if (tmpColor != null) {
            this.fillColorEditor.setColor(tmpColor);
        } else {
            int index2 = this.getAttributeIndex(color, this.stringAttributesArrays);
            if (index2 != -1) {
                this.fillColorAttributecombo.select(index2);
            }
        }
        try {
            this.graphicsPathText.setText(polygonSymbolizerWrapper.getFillExternalGraphicFillPath());
        }
        catch (MalformedURLException malformedURLException) {
            this.graphicsPathText.setText("");
        }
        String wkMarkNameFill = polygonSymbolizerWrapper.getWkMarkNameFill();
        String mName = (String)Utilities.markNamesToDef.inverse().get((Object)wkMarkNameFill);
        int attributeIndex = this.getAttributeIndex(mName, Utilities.getAllMarksArray());
        if (attributeIndex != -1) {
            this.wkmarkNameCombo.select(attributeIndex);
        } else {
            this.wkmarkNameCombo.select(0);
        }
        Double tmpWkmWidth = this.isDouble(polygonSymbolizerWrapper.getWkMarkWidthFill());
        int tmpWkm = 3;
        if (tmpWkmWidth != null) {
            tmpWkm = tmpWkmWidth.intValue();
        }
        this.wkmWidthSpinner.setSelection(tmpWkm * 10);
        Double tmpWkmSize = this.isDouble(polygonSymbolizerWrapper.getWkMarkSizeFill());
        int tmpWkmSizeInt = 3;
        if (tmpWkmSize != null) {
            tmpWkmSizeInt = tmpWkmSize.intValue();
        }
        this.wkmSizeSpinner.setSelection(tmpWkmSizeInt * 10);
        try {
            tmpWkmColor = Color.decode(polygonSymbolizerWrapper.getWkMarkColorFill());
        }
        catch (Exception exception) {
            tmpWkmColor = Color.gray;
        }
        this.wkmColorEditor.setColor(tmpWkmColor);
        String opacity = polygonSymbolizerWrapper.getFillOpacity();
        Double tmpOpacity = this.isDouble(opacity);
        int tmp = 100;
        if (tmpOpacity != null) {
            tmp = (int)(tmpOpacity * 100.0);
        }
        this.fillOpacitySpinner.setSelection(tmp);
        if (tmpOpacity == null && (index = this.getAttributeIndex(opacity, this.numericAttributesArrays)) != -1) {
            this.fillOpacityAttributecombo.select(index);
        }
        this.checkEnablements();
    }

    private void checkEnablements() {
        boolean comboIsNone = this.comboIsNone(this.fillOpacityAttributecombo);
        this.fillOpacitySpinner.setEnabled(comboIsNone);
        comboIsNone = this.comboIsNone(this.fillColorAttributecombo);
        this.fillColorEditor.setEnabled(comboIsNone);
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.fillEnableButton)) {
            boolean selected = this.fillEnableButton.getSelection();
            this.notifyListeners(String.valueOf(selected), false, IStyleChangesListener.STYLEEVENTTYPE.FILLENABLE);
        } else if (source.equals(this.fillColorButton) || source.equals(this.fillColorAttributecombo)) {
            boolean comboIsNone = this.comboIsNone(this.fillColorAttributecombo);
            if (comboIsNone) {
                Color color = this.fillColorEditor.getColor();
                Literal colorExpr = Utilities.ff.literal((Object)color);
                String fillColor = (String)colorExpr.evaluate(null, String.class);
                this.notifyListeners(fillColor, false, IStyleChangesListener.STYLEEVENTTYPE.FILLCOLOR);
            } else {
                int index = this.fillColorAttributecombo.getSelectionIndex();
                String field = this.fillColorAttributecombo.getItem(index);
                if (field.length() == 0) {
                    return;
                }
                this.notifyListeners(field, true, IStyleChangesListener.STYLEEVENTTYPE.FILLCOLOR);
            }
        } else if (source.equals(this.fillOpacitySpinner) || source.equals(this.fillOpacityAttributecombo)) {
            boolean comboIsNone = this.comboIsNone(this.fillOpacityAttributecombo);
            if (comboIsNone) {
                int opacity = this.fillOpacitySpinner.getSelection();
                float opacityNorm = (float)opacity / 100.0f;
                String fillOpacity = String.valueOf(opacityNorm);
                this.notifyListeners(fillOpacity, false, IStyleChangesListener.STYLEEVENTTYPE.FILLOPACITY);
            } else {
                int index = this.fillOpacityAttributecombo.getSelectionIndex();
                String field = this.fillOpacityAttributecombo.getItem(index);
                if (field.length() == 0) {
                    return;
                }
                this.notifyListeners(field, true, IStyleChangesListener.STYLEEVENTTYPE.FILLOPACITY);
            }
        } else if (source.equals(this.wkmarkNameCombo) || source.equals(this.wkmColorButton) || source.equals(this.wkmWidthSpinner) || source.equals(this.wkmSizeSpinner)) {
            this.doWkmGraphics();
        }
        this.checkEnablements();
    }

    public void modifyText(ModifyEvent e) {
        Object source = e.getSource();
        if (source.equals(this.graphicsPathText)) {
            try {
                String text = this.graphicsPathText.getText();
                File graphicsFile = new File(text);
                if (graphicsFile.exists() || text.toLowerCase().startsWith("http")) {
                    text = graphicsFile.toURI().toURL().toExternalForm();
                    this.notifyListeners(text, false, IStyleChangesListener.STYLEEVENTTYPE.GRAPHICSPATHFILL);
                }
            }
            catch (MalformedURLException e1) {
                e1.printStackTrace();
            }
        }
    }

    private void doWkmGraphics() {
        int selectionIndex = this.wkmarkNameCombo.getSelectionIndex();
        String name = this.wkmarkNameCombo.getItem(selectionIndex);
        if (name.equals("")) {
            return;
        }
        name = (String)Utilities.markNamesToDef.get((Object)name);
        int selection = this.wkmWidthSpinner.getSelection();
        int digits = this.wkmWidthSpinner.getDigits();
        double value = (double)selection / Math.pow(10.0, digits);
        String strokeWidth = String.valueOf(value);
        selection = this.wkmSizeSpinner.getSelection();
        digits = this.wkmSizeSpinner.getDigits();
        value = (double)selection / Math.pow(10.0, digits);
        String strokeSize = String.valueOf(value);
        Color color = this.wkmColorEditor.getColor();
        Literal colorExpr = Utilities.ff.literal((Object)color);
        String strokeColor = (String)colorExpr.evaluate(null, String.class);
        this.notifyListeners(new String[]{name, strokeWidth, strokeColor, strokeSize}, false, IStyleChangesListener.STYLEEVENTTYPE.WKMGRAPHICSFILL);
    }
}

