/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.polygons;

import eu.udig.style.advanced.common.BoderParametersComposite;
import eu.udig.style.advanced.common.FiltersComposite;
import eu.udig.style.advanced.common.IStyleChangesListener;
import eu.udig.style.advanced.common.styleattributeclasses.PolygonSymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.TextSymbolizerWrapper;
import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.polygons.PolygonPropertiesEditor;
import eu.udig.style.advanced.polygons.widgets.PolygonFillParametersComposite;
import eu.udig.style.advanced.polygons.widgets.PolygonGeneralParametersComposite;
import eu.udig.style.advanced.polygons.widgets.PolygonLabelsParametersComposite;
import eu.udig.style.advanced.utils.Utilities;
import java.net.MalformedURLException;
import java.util.List;
import net.refractions.udig.style.sld.SLD;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.opengis.filter.Filter;
import org.opengis.filter.expression.Expression;

public class PolygonPropertiesComposite
implements ModifyListener,
IStyleChangesListener {
    private RuleWrapper ruleWrapper;
    private Composite simplePolygonComposite = null;
    private PolygonPropertiesEditor polygonPropertiesEditor;
    private Composite mainComposite;
    private StackLayout mainStackLayout;
    private String[] numericAttributesArrays;
    private Composite parentComposite;
    private final Composite parent;
    private PolygonGeneralParametersComposite generalParametersComposite;
    private BoderParametersComposite borderParametersComposite;
    private PolygonFillParametersComposite fillParametersComposite;
    private PolygonLabelsParametersComposite labelsParametersComposite;
    private String[] allAttributesArrays;
    private FiltersComposite filtersComposite;
    private String[] stringattributesArrays;

    public PolygonPropertiesComposite(PolygonPropertiesEditor polygonPropertiesEditor, Composite parent) {
        this.polygonPropertiesEditor = polygonPropertiesEditor;
        this.parent = parent;
    }

    public void setRule(RuleWrapper ruleWrapper) {
        this.ruleWrapper = ruleWrapper;
        if (this.mainComposite == null) {
            this.init();
            this.createSimpleComposite();
        } else {
            this.update();
        }
        this.setRightPanel();
    }

    private void update() {
        this.generalParametersComposite.update(this.ruleWrapper);
        this.borderParametersComposite.update(this.ruleWrapper);
        this.fillParametersComposite.update(this.ruleWrapper);
        this.labelsParametersComposite.update(this.ruleWrapper);
        this.filtersComposite.update(this.ruleWrapper);
        this.polygonPropertiesEditor.refreshTreeViewer(this.ruleWrapper);
        this.polygonPropertiesEditor.refreshPreviewCanvasOnStyle();
    }

    private void init() {
        List<String> numericAttributeNames = this.polygonPropertiesEditor.getNumericAttributeNames();
        this.numericAttributesArrays = numericAttributeNames.toArray(new String[numericAttributeNames.size()]);
        List<String> allAttributeNames = this.polygonPropertiesEditor.getAllAttributeNames();
        this.allAttributesArrays = allAttributeNames.toArray(new String[allAttributeNames.size()]);
        List<String> stringAttributeNames = this.polygonPropertiesEditor.getStringAttributeNames();
        this.stringattributesArrays = stringAttributeNames.toArray(new String[0]);
        this.parentComposite = new Composite(this.parent, 0);
        this.parentComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.parentComposite.setLayout((Layout)new GridLayout(1, false));
        this.mainComposite = new Composite(this.parentComposite, 0);
        this.mainStackLayout = new StackLayout();
        this.mainComposite.setLayout((Layout)this.mainStackLayout);
        GridData mainCompositeGD = new GridData(4, 4, true, true);
        this.mainComposite.setLayoutData((Object)mainCompositeGD);
    }

    private void setRightPanel() {
        this.mainStackLayout.topControl = this.simplePolygonComposite;
        this.mainComposite.layout();
    }

    public Composite getComposite() {
        return this.parentComposite;
    }

    private void createSimpleComposite() {
        this.simplePolygonComposite = new Composite(this.mainComposite, 0);
        this.simplePolygonComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.simplePolygonComposite.setLayout((Layout)new GridLayout(1, false));
        Composite nameComposite = new Composite(this.simplePolygonComposite, 0);
        nameComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        nameComposite.setLayout((Layout)new GridLayout(2, true));
        Group propertiesGroup = new Group(this.simplePolygonComposite, 16);
        propertiesGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        propertiesGroup.setLayout((Layout)new GridLayout(1, false));
        propertiesGroup.setText(Messages.PolygonPropertiesComposite_1);
        TabFolder tabFolder = new TabFolder((Composite)propertiesGroup, 2048);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.generalParametersComposite = new PolygonGeneralParametersComposite((Composite)tabFolder, this.numericAttributesArrays);
        this.generalParametersComposite.init(this.ruleWrapper);
        this.generalParametersComposite.addListener(this);
        Composite generalParametersInternalComposite = this.generalParametersComposite.getComposite();
        TabItem tabItem1 = new TabItem(tabFolder, 0);
        tabItem1.setText(Messages.PolygonPropertiesComposite_2);
        tabItem1.setControl((Control)generalParametersInternalComposite);
        this.borderParametersComposite = new BoderParametersComposite((Composite)tabFolder, this.numericAttributesArrays, this.stringattributesArrays);
        this.borderParametersComposite.init(this.ruleWrapper);
        this.borderParametersComposite.addListener(this);
        Composite borderParametersInternalComposite = this.borderParametersComposite.getComposite();
        TabItem tabItem2 = new TabItem(tabFolder, 0);
        tabItem2.setText(Messages.PolygonPropertiesComposite_3);
        tabItem2.setControl((Control)borderParametersInternalComposite);
        this.fillParametersComposite = new PolygonFillParametersComposite((Composite)tabFolder, this.numericAttributesArrays, this.stringattributesArrays);
        this.fillParametersComposite.init(this.ruleWrapper);
        this.fillParametersComposite.addListener(this);
        Composite fillParametersInternalComposite = this.fillParametersComposite.getComposite();
        TabItem tabItem3 = new TabItem(tabFolder, 0);
        tabItem3.setText(Messages.PolygonPropertiesComposite_4);
        tabItem3.setControl((Control)fillParametersInternalComposite);
        this.labelsParametersComposite = new PolygonLabelsParametersComposite((Composite)tabFolder, this.numericAttributesArrays, this.allAttributesArrays);
        this.labelsParametersComposite.init(this.ruleWrapper);
        this.labelsParametersComposite.addListener(this);
        Composite labelParametersInternalComposite = this.labelsParametersComposite.getComposite();
        TabItem tabItem4 = new TabItem(tabFolder, 0);
        tabItem4.setText(Messages.PolygonPropertiesComposite_5);
        tabItem4.setControl((Control)labelParametersInternalComposite);
        this.filtersComposite = new FiltersComposite((Composite)tabFolder);
        this.filtersComposite.init(this.ruleWrapper);
        this.filtersComposite.addListener(this);
        Composite filtersInternalComposite = this.filtersComposite.getComposite();
        TabItem tabItem5 = new TabItem(tabFolder, 0);
        tabItem5.setText(Messages.PolygonPropertiesComposite_6);
        tabItem5.setControl((Control)filtersInternalComposite);
    }

    public void modifyText(ModifyEvent e) {
    }

    @Override
    public void onStyleChanged(Object source, String[] values, boolean fromField, IStyleChangesListener.STYLEEVENTTYPE styleEventType) {
        String value = values[0];
        PolygonSymbolizerWrapper polygonSymbolizerWrapper = this.ruleWrapper.getGeometrySymbolizersWrapper().adapt(PolygonSymbolizerWrapper.class);
        TextSymbolizerWrapper textSymbolizerWrapper = this.ruleWrapper.getTextSymbolizersWrapper();
        switch (styleEventType) {
            case NAME: {
                this.ruleWrapper.setName(value);
                break;
            }
            case OFFSET: {
                polygonSymbolizerWrapper.setOffset(value);
                break;
            }
            case MAXSCALE: {
                this.ruleWrapper.setMaxScale(value);
                break;
            }
            case MINSCALE: {
                this.ruleWrapper.setMinScale(value);
                break;
            }
            case BORDERENABLE: {
                boolean enabled = Boolean.parseBoolean(value);
                polygonSymbolizerWrapper.setHasStroke(enabled);
                break;
            }
            case BORDERWIDTH: {
                polygonSymbolizerWrapper.setStrokeWidth(value, fromField);
                break;
            }
            case BORDERCOLOR: {
                polygonSymbolizerWrapper.setStrokeColor(value, fromField);
                break;
            }
            case BORDEROPACITY: {
                polygonSymbolizerWrapper.setStrokeOpacity(value, fromField);
                break;
            }
            case GRAPHICSPATHBORDER: {
                String url = values[0];
                String width = values[1];
                String size = values[2];
                try {
                    polygonSymbolizerWrapper.setStrokeExternalGraphicStrokePath(url);
                    Graphic graphicStroke = polygonSymbolizerWrapper.getStrokeGraphicStroke();
                    graphicStroke.setSize((Expression)Utilities.ff.literal((Object)size));
                    graphicStroke.setGap((Expression)Utilities.ff.literal((Object)width));
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                break;
            }
            case DASH: {
                polygonSymbolizerWrapper.setDash(value);
                break;
            }
            case DASHOFFSET: {
                polygonSymbolizerWrapper.setDashOffset(value);
                break;
            }
            case LINECAP: {
                polygonSymbolizerWrapper.setLineCap(value);
                break;
            }
            case LINEJOIN: {
                polygonSymbolizerWrapper.setLineJoin(value);
                break;
            }
            case FILLENABLE: {
                boolean enabled = Boolean.parseBoolean(value);
                polygonSymbolizerWrapper.setHasFill(enabled);
                break;
            }
            case FILLCOLOR: {
                polygonSymbolizerWrapper.setFillColor(value, fromField);
                break;
            }
            case FILLOPACITY: {
                polygonSymbolizerWrapper.setFillOpacity(value, fromField);
                break;
            }
            case WKMGRAPHICSFILL: {
                String wkmname = values[0];
                String wkmwidth = values[1];
                String wkmcolor = values[2];
                String wkmsize = values[3];
                polygonSymbolizerWrapper.setWkMarkNameFill(wkmname);
                polygonSymbolizerWrapper.setWkMarkWidthFill(wkmwidth);
                polygonSymbolizerWrapper.setWkMarkColorFill(wkmcolor);
                polygonSymbolizerWrapper.setWkMarkSizeFill(wkmsize);
                break;
            }
            case GRAPHICSPATHFILL: {
                try {
                    polygonSymbolizerWrapper.setFillExternalGraphicFillPath(value);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                break;
            }
            case LABELENABLE: {
                boolean doEnable = Boolean.parseBoolean(value);
                if (doEnable) {
                    if (textSymbolizerWrapper != null) break;
                    TextSymbolizer textSymbolizer = Utilities.createDefaultTextSymbolizer(SLD.POLYGON);
                    this.ruleWrapper.addSymbolizer((Symbolizer)textSymbolizer, TextSymbolizerWrapper.class);
                    this.labelsParametersComposite.update(this.ruleWrapper);
                    break;
                }
                this.ruleWrapper.removeTextSymbolizersWrapper();
                break;
            }
            case LABEL: {
                if (textSymbolizerWrapper == null) break;
                textSymbolizerWrapper.setLabelName(value, fromField);
                break;
            }
            case LABELFONT: {
                if (textSymbolizerWrapper == null) break;
                String name = values[0];
                int style = Integer.parseInt(values[1]);
                int height = Integer.parseInt(values[2]);
                Font font = Utilities.sb.createFont(name, style == 2, style == 1, (double)height);
                textSymbolizerWrapper.setFont(font);
                break;
            }
            case LABELCOLOR: {
                if (textSymbolizerWrapper == null) break;
                textSymbolizerWrapper.setColor(value);
                break;
            }
            case LABELHALOCOLOR: {
                if (textSymbolizerWrapper == null) break;
                textSymbolizerWrapper.setHaloColor(value);
                break;
            }
            case LABELHALORADIUS: {
                if (textSymbolizerWrapper == null) break;
                textSymbolizerWrapper.setHaloRadius(value);
                break;
            }
            case LABELROTATION: {
                if (textSymbolizerWrapper == null) break;
                textSymbolizerWrapper.setRotation(value, fromField);
                break;
            }
            case LABELMAXDISPLACEMENT_VO: {
                if (textSymbolizerWrapper == null) break;
                textSymbolizerWrapper.setMaxDisplacementVO(value);
                break;
            }
            case LABELAUTOWRAP_VO: {
                if (textSymbolizerWrapper == null) break;
                textSymbolizerWrapper.setAutoWrapVO(value);
                break;
            }
            case LABELSPACEAROUND_VO: {
                if (textSymbolizerWrapper == null) break;
                textSymbolizerWrapper.setSpaceAroundVO(value);
                break;
            }
            case FILTER: {
                if (value.length() <= 0) break;
                try {
                    Filter filter = ECQL.toFilter((String)value);
                    this.ruleWrapper.getRule().setFilter(filter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        this.polygonPropertiesEditor.refreshTreeViewer(this.ruleWrapper);
        this.polygonPropertiesEditor.refreshPreviewCanvasOnStyle();
    }
}

