/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.points.widgets;

import eu.udig.style.advanced.common.IStyleChangesListener;
import eu.udig.style.advanced.common.ParameterComposite;
import eu.udig.style.advanced.common.styleattributeclasses.PointSymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.utils.Utilities;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class PointGeneralParametersComposite
extends ParameterComposite {
    private final Composite parent;
    private final String[] numericAttributesArrays;
    private Text nameText;
    private Spinner sizeSpinner;
    private Combo sizeAttributecombo;
    private Spinner rotationSpinner;
    private Combo rotationAttributecombo;
    private Spinner xOffsetSpinner;
    private Spinner yOffsetSpinner;
    private Text maxScaleText;
    private Text minScaleText;
    private Composite mainComposite;

    public PointGeneralParametersComposite(Composite parent, String[] numericAttributesArrays) {
        this.parent = parent;
        this.numericAttributesArrays = numericAttributesArrays;
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    public void init(RuleWrapper ruleWrapper) {
        int index;
        int index2;
        PointSymbolizerWrapper pointSymbolizerWrapper = ruleWrapper.getGeometrySymbolizersWrapper().adapt(PointSymbolizerWrapper.class);
        this.mainComposite = new Composite(this.parent, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainComposite.setLayout((Layout)new GridLayout(3, true));
        Label nameLabel = new Label(this.mainComposite, 0);
        nameLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        nameLabel.setText(Messages.PointGeneralParametersComposite_0);
        this.nameText = new Text(this.mainComposite, 18436);
        GridData nameTextGD = new GridData(4, 0x1000000, true, false);
        nameTextGD.horizontalSpan = 2;
        this.nameText.setLayoutData((Object)nameTextGD);
        this.nameText.setText(ruleWrapper.getName());
        this.nameText.addFocusListener((FocusListener)this);
        new Label(this.mainComposite, 0);
        Label valueLabel = new Label(this.mainComposite, 0);
        valueLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        valueLabel.setText(Messages.PointGeneralParametersComposite_1);
        Label fieldsLabel = new Label(this.mainComposite, 0);
        fieldsLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        fieldsLabel.setText(Messages.PointGeneralParametersComposite_2);
        Label sizeLabel = new Label(this.mainComposite, 0);
        sizeLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        sizeLabel.setText(Messages.PointGeneralParametersComposite_3);
        this.sizeSpinner = new Spinner(this.mainComposite, 2048);
        this.sizeSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sizeSpinner.setMaximum(200);
        this.sizeSpinner.setMinimum(0);
        this.sizeSpinner.setIncrement(1);
        String size = pointSymbolizerWrapper.getSize();
        Double tmpSize = this.isDouble(size);
        int tmp = 3;
        if (tmpSize != null) {
            tmp = tmpSize.intValue();
        }
        this.sizeSpinner.setSelection(tmp);
        this.sizeSpinner.addSelectionListener((SelectionListener)this);
        this.sizeAttributecombo = new Combo(this.mainComposite, 12);
        this.sizeAttributecombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sizeAttributecombo.setItems(this.numericAttributesArrays);
        this.sizeAttributecombo.addSelectionListener((SelectionListener)this);
        if (tmpSize == null && (index2 = this.getAttributeIndex(size, this.numericAttributesArrays)) != -1) {
            this.sizeAttributecombo.select(index2);
        }
        Label rotationLabel = new Label(this.mainComposite, 0);
        rotationLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        rotationLabel.setText(Messages.PointGeneralParametersComposite_4);
        this.rotationSpinner = new Spinner(this.mainComposite, 2048);
        this.rotationSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.rotationSpinner.setMaximum(360);
        this.rotationSpinner.setMinimum(0);
        this.rotationSpinner.setIncrement(5);
        String rotation = pointSymbolizerWrapper.getRotation();
        Double tmpRotation = this.isDouble(rotation);
        tmp = 0;
        if (tmpRotation != null) {
            tmp = tmpRotation.intValue();
        }
        this.rotationSpinner.setSelection(tmp);
        this.rotationSpinner.addSelectionListener((SelectionListener)this);
        this.rotationAttributecombo = new Combo(this.mainComposite, 12);
        this.rotationAttributecombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.rotationAttributecombo.setItems(this.numericAttributesArrays);
        this.rotationAttributecombo.addSelectionListener((SelectionListener)this);
        if (tmpSize == null && (index = this.getAttributeIndex(rotation, this.numericAttributesArrays)) != -1) {
            this.rotationAttributecombo.select(index);
        }
        Label offsetLabel = new Label(this.mainComposite, 0);
        GridData offsetLabelGD = new GridData(4, 0x1000000, true, false);
        offsetLabel.setLayoutData((Object)offsetLabelGD);
        offsetLabel.setText(Messages.PointGeneralParametersComposite_5);
        String xOffset = pointSymbolizerWrapper.getxOffset();
        String yOffset = pointSymbolizerWrapper.getyOffset();
        Double tmpXOffset = Utilities.isNumber(xOffset, Double.class);
        Double tmpYOffset = Utilities.isNumber(yOffset, Double.class);
        if (tmpXOffset == null || tmpYOffset == null) {
            tmpXOffset = 0.0;
            tmpYOffset = 0.0;
        }
        this.xOffsetSpinner = new Spinner(this.mainComposite, 2048);
        this.xOffsetSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.xOffsetSpinner.setMaximum(1000);
        this.xOffsetSpinner.setMinimum(-1000);
        this.xOffsetSpinner.setIncrement(10);
        this.xOffsetSpinner.setSelection((int)(10.0 * tmpXOffset));
        this.xOffsetSpinner.setDigits(1);
        this.xOffsetSpinner.addSelectionListener((SelectionListener)this);
        this.yOffsetSpinner = new Spinner(this.mainComposite, 2048);
        this.yOffsetSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.yOffsetSpinner.setMaximum(1000);
        this.yOffsetSpinner.setMinimum(-1000);
        this.yOffsetSpinner.setIncrement(10);
        this.yOffsetSpinner.setSelection((int)(10.0 * tmpYOffset));
        this.yOffsetSpinner.setDigits(1);
        this.yOffsetSpinner.addSelectionListener((SelectionListener)this);
        Label maxScaleLabel = new Label(this.mainComposite, 0);
        GridData maxScaleLabelGD = new GridData(4, 0x1000000, true, false);
        maxScaleLabel.setLayoutData((Object)maxScaleLabelGD);
        maxScaleLabel.setText(Messages.PointGeneralParametersComposite_6);
        this.maxScaleText = new Text(this.mainComposite, 18436);
        GridData maxScaleTextSIMPLEGD = new GridData(4, 0x1000000, true, false);
        maxScaleTextSIMPLEGD.horizontalSpan = 2;
        this.maxScaleText.setLayoutData((Object)maxScaleTextSIMPLEGD);
        this.maxScaleText.setText(ruleWrapper.getMaxScale());
        this.maxScaleText.addKeyListener((KeyListener)this);
        Label minScaleLabel = new Label(this.mainComposite, 0);
        GridData minScaleLabelGD = new GridData(4, 0x1000000, true, false);
        minScaleLabel.setLayoutData((Object)minScaleLabelGD);
        minScaleLabel.setText(Messages.PointGeneralParametersComposite_7);
        this.minScaleText = new Text(this.mainComposite, 18436);
        GridData mainScaleTextSIMPLEGD = new GridData(4, 0x1000000, true, false);
        mainScaleTextSIMPLEGD.horizontalSpan = 2;
        this.minScaleText.setLayoutData((Object)mainScaleTextSIMPLEGD);
        this.minScaleText.setText(ruleWrapper.getMinScale());
        this.minScaleText.addKeyListener((KeyListener)this);
        this.checkEnablements();
    }

    public void update(RuleWrapper ruleWrapper) {
        int index;
        int index2;
        PointSymbolizerWrapper pointSymbolizerWrapper = ruleWrapper.getGeometrySymbolizersWrapper().adapt(PointSymbolizerWrapper.class);
        this.nameText.setText(ruleWrapper.getName());
        String size = pointSymbolizerWrapper.getSize();
        Double tmpSize = this.isDouble(size);
        int tmp = 3;
        if (tmpSize != null) {
            tmp = tmpSize.intValue();
        }
        this.sizeSpinner.setSelection(tmp);
        if (tmpSize == null && (index2 = this.getAttributeIndex(size, this.numericAttributesArrays)) != -1) {
            this.sizeAttributecombo.select(index2);
        }
        String rotation = pointSymbolizerWrapper.getRotation();
        Double tmpRotation = this.isDouble(rotation);
        tmp = 0;
        if (tmpRotation != null) {
            tmp = tmpRotation.intValue();
        }
        this.rotationSpinner.setSelection(tmp);
        if (tmpSize == null && (index = this.getAttributeIndex(rotation, this.numericAttributesArrays)) != -1) {
            this.rotationAttributecombo.select(index);
        }
        String xOffset = pointSymbolizerWrapper.getxOffset();
        String yOffset = pointSymbolizerWrapper.getyOffset();
        Double tmpXOffset = Utilities.isNumber(xOffset, Double.class);
        Double tmpYOffset = Utilities.isNumber(yOffset, Double.class);
        if (tmpXOffset == null || tmpYOffset == null) {
            tmpXOffset = 0.0;
            tmpYOffset = 0.0;
        }
        this.xOffsetSpinner.setSelection((int)(10.0 * tmpXOffset));
        this.yOffsetSpinner.setSelection((int)(10.0 * tmpYOffset));
        Double maxScaleDouble = this.isDouble(ruleWrapper.getMaxScale());
        if (maxScaleDouble == null || Double.isInfinite(maxScaleDouble)) {
            this.maxScaleText.setText("");
        } else {
            this.maxScaleText.setText(String.valueOf(maxScaleDouble));
        }
        Double minScaleDouble = this.isDouble(ruleWrapper.getMinScale());
        if (minScaleDouble == null || minScaleDouble == 0.0) {
            this.minScaleText.setText("");
        } else {
            this.minScaleText.setText(String.valueOf(minScaleDouble));
        }
        this.checkEnablements();
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.sizeAttributecombo) || source.equals(this.sizeSpinner)) {
            boolean comboIsNone = this.comboIsNone(this.sizeAttributecombo);
            if (comboIsNone) {
                int sizeInt = this.sizeSpinner.getSelection();
                String size = String.valueOf(sizeInt);
                this.notifyListeners(size, false, IStyleChangesListener.STYLEEVENTTYPE.SIZE);
            } else {
                int index = this.sizeAttributecombo.getSelectionIndex();
                String field = this.sizeAttributecombo.getItem(index);
                if (field.length() == 0) {
                    return;
                }
                this.notifyListeners(field, true, IStyleChangesListener.STYLEEVENTTYPE.SIZE);
            }
        } else if (source.equals(this.rotationSpinner) || source.equals(this.rotationAttributecombo)) {
            boolean comboIsNone = this.comboIsNone(this.rotationAttributecombo);
            if (comboIsNone) {
                int rotationInt = this.rotationSpinner.getSelection();
                String rotation = String.valueOf(rotationInt);
                this.notifyListeners(rotation, false, IStyleChangesListener.STYLEEVENTTYPE.ROTATION);
            } else {
                int index = this.rotationAttributecombo.getSelectionIndex();
                String field = this.rotationAttributecombo.getItem(index);
                if (field.length() == 0) {
                    return;
                }
                this.notifyListeners(field, true, IStyleChangesListener.STYLEEVENTTYPE.ROTATION);
            }
        } else if (source.equals(this.xOffsetSpinner) || source.equals(this.yOffsetSpinner)) {
            double x = Utilities.getDoubleSpinnerSelection(this.xOffsetSpinner);
            double y = Utilities.getDoubleSpinnerSelection(this.yOffsetSpinner);
            String offsetStr = String.valueOf(x) + "," + y;
            this.notifyListeners(offsetStr, false, IStyleChangesListener.STYLEEVENTTYPE.OFFSET);
        }
        this.checkEnablements();
    }

    private void checkEnablements() {
        boolean comboIsNone = this.comboIsNone(this.rotationAttributecombo);
        this.rotationSpinner.setEnabled(comboIsNone);
        comboIsNone = this.comboIsNone(this.sizeAttributecombo);
        this.sizeSpinner.setEnabled(comboIsNone);
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        Object source = e.getSource();
        if (source.equals(this.maxScaleText)) {
            String maxScale = this.maxScaleText.getText();
            this.notifyListeners(maxScale, false, IStyleChangesListener.STYLEEVENTTYPE.MAXSCALE);
        } else if (source.equals(this.minScaleText)) {
            String minScale = this.minScaleText.getText();
            this.notifyListeners(minScale, false, IStyleChangesListener.STYLEEVENTTYPE.MINSCALE);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        if (source.equals(this.nameText)) {
            String text = this.nameText.getText();
            this.notifyListeners(text, false, IStyleChangesListener.STYLEEVENTTYPE.NAME);
        }
    }
}

