/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.style.advanced.points.widgets;

import eu.udig.style.advanced.common.IStyleChangesListener;
import eu.udig.style.advanced.common.ParameterComposite;
import eu.udig.style.advanced.common.styleattributeclasses.PointSymbolizerWrapper;
import eu.udig.style.advanced.common.styleattributeclasses.RuleWrapper;
import eu.udig.style.advanced.internal.Messages;
import eu.udig.style.advanced.utils.StolenColorEditor;
import eu.udig.style.advanced.utils.Utilities;
import java.awt.Color;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.opengis.filter.expression.Literal;

public class PointFillParametersComposite
extends ParameterComposite {
    private final Composite parent;
    private final String[] numericAttributesArrays;
    private Composite mainComposite;
    private Button fillEnableButton;
    private StolenColorEditor fillColorEditor;
    private Button fillColorButton;
    private Spinner fillOpacitySpinner;
    private Combo fillOpacityAttributecombo;

    public PointFillParametersComposite(Composite parent, String[] numericAttributesArrays) {
        this.parent = parent;
        this.numericAttributesArrays = numericAttributesArrays;
    }

    @Override
    public Composite getComposite() {
        return this.mainComposite;
    }

    public void init(RuleWrapper ruleWrapper) {
        int index;
        PointSymbolizerWrapper pointSymbolizerWrapper = ruleWrapper.getGeometrySymbolizersWrapper().adapt(PointSymbolizerWrapper.class);
        this.mainComposite = new Composite(this.parent, 0);
        this.mainComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.mainComposite.setLayout((Layout)new GridLayout(3, true));
        boolean widgetEnabled = pointSymbolizerWrapper.hasFill();
        this.fillEnableButton = new Button(this.mainComposite, 32);
        GridData fillEnableButtonGD = new GridData(1, 0x1000000, false, false);
        fillEnableButtonGD.horizontalSpan = 3;
        this.fillEnableButton.setLayoutData((Object)fillEnableButtonGD);
        this.fillEnableButton.setText(Messages.PointFillParametersComposite_0);
        this.fillEnableButton.setSelection(widgetEnabled);
        this.fillEnableButton.addSelectionListener((SelectionListener)this);
        new Label(this.mainComposite, 0);
        Label valueLabel = new Label(this.mainComposite, 0);
        valueLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        valueLabel.setText(Messages.PointFillParametersComposite_1);
        Label fieldsLabel = new Label(this.mainComposite, 0);
        fieldsLabel.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, false));
        fieldsLabel.setText(Messages.PointFillParametersComposite_2);
        Label fillOpactityLabel = new Label(this.mainComposite, 0);
        fillOpactityLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        fillOpactityLabel.setText(Messages.PointFillParametersComposite_3);
        this.fillOpacitySpinner = new Spinner(this.mainComposite, 2048);
        this.fillOpacitySpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fillOpacitySpinner.setMaximum(100);
        this.fillOpacitySpinner.setMinimum(0);
        this.fillOpacitySpinner.setIncrement(10);
        String opacity = pointSymbolizerWrapper.getFillOpacity();
        Double tmpOpacity = this.isDouble(opacity);
        int tmp = 100;
        if (tmpOpacity != null) {
            tmp = (int)(tmpOpacity * 100.0);
        }
        this.fillOpacitySpinner.setSelection(tmp);
        this.fillOpacitySpinner.addSelectionListener((SelectionListener)this);
        this.fillOpacityAttributecombo = new Combo(this.mainComposite, 12);
        this.fillOpacityAttributecombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fillOpacityAttributecombo.setItems(this.numericAttributesArrays);
        this.fillOpacityAttributecombo.addSelectionListener((SelectionListener)this);
        this.fillOpacityAttributecombo.select(0);
        if (tmpOpacity == null && (index = this.getAttributeIndex(opacity, this.numericAttributesArrays)) != -1) {
            this.fillOpacityAttributecombo.select(index);
        }
        Label fillColorLabel = new Label(this.mainComposite, 0);
        fillColorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        fillColorLabel.setText(Messages.PointFillParametersComposite_4);
        Color tmpColor = null;
        try {
            tmpColor = Color.decode(pointSymbolizerWrapper.getFillColor());
        }
        catch (Exception exception) {
            tmpColor = Color.gray;
        }
        this.fillColorEditor = new StolenColorEditor(this.mainComposite, (SelectionListener)this);
        this.fillColorEditor.setColor(tmpColor);
        this.fillColorButton = this.fillColorEditor.getButton();
        GridData fillColorButtonGD = new GridData(4, 0x1000000, true, false);
        fillColorButtonGD.horizontalSpan = 2;
        this.fillColorButton.setLayoutData((Object)fillColorButtonGD);
        this.checkEnablements();
    }

    public void update(RuleWrapper ruleWrapper) {
        int index;
        PointSymbolizerWrapper pointSymbolizerWrapper = ruleWrapper.getGeometrySymbolizersWrapper().adapt(PointSymbolizerWrapper.class);
        boolean widgetEnabled = pointSymbolizerWrapper.hasFill();
        this.fillEnableButton.setSelection(widgetEnabled);
        Color tmpColor = null;
        try {
            tmpColor = Color.decode(pointSymbolizerWrapper.getFillColor());
        }
        catch (Exception exception) {
            tmpColor = Color.gray;
        }
        this.fillColorEditor.setColor(tmpColor);
        String opacity = pointSymbolizerWrapper.getFillOpacity();
        Double tmpOpacity = this.isDouble(opacity);
        int tmp = 100;
        if (tmpOpacity != null) {
            tmp = (int)(tmpOpacity * 100.0);
        }
        this.fillOpacitySpinner.setSelection(tmp);
        if (tmpOpacity == null && (index = this.getAttributeIndex(opacity, this.numericAttributesArrays)) != -1) {
            this.fillOpacityAttributecombo.select(index);
        }
        this.checkEnablements();
    }

    private void checkEnablements() {
        boolean comboIsNone = this.comboIsNone(this.fillOpacityAttributecombo);
        this.fillOpacitySpinner.setEnabled(comboIsNone);
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source.equals(this.fillEnableButton)) {
            boolean selected = this.fillEnableButton.getSelection();
            this.notifyListeners(String.valueOf(selected), false, IStyleChangesListener.STYLEEVENTTYPE.FILLENABLE);
        } else if (source.equals(this.fillColorButton)) {
            Color color = this.fillColorEditor.getColor();
            Literal colorExpr = Utilities.ff.literal((Object)color);
            String fillColor = (String)colorExpr.evaluate(null, String.class);
            this.notifyListeners(fillColor, false, IStyleChangesListener.STYLEEVENTTYPE.FILLCOLOR);
        } else if (source.equals(this.fillOpacitySpinner) || source.equals(this.fillOpacityAttributecombo)) {
            boolean comboIsNone = this.comboIsNone(this.fillOpacityAttributecombo);
            if (comboIsNone) {
                int opacity = this.fillOpacitySpinner.getSelection();
                float opacityNorm = (float)opacity / 100.0f;
                String fillOpacity = String.valueOf(opacityNorm);
                this.notifyListeners(fillOpacity, false, IStyleChangesListener.STYLEEVENTTYPE.FILLOPACITY);
            } else {
                int index = this.fillOpacityAttributecombo.getSelectionIndex();
                String field = this.fillOpacityAttributecombo.getItem(index);
                if (field.length() == 0) {
                    return;
                }
                this.notifyListeners(field, true, IStyleChangesListener.STYLEEVENTTYPE.FILLOPACITY);
            }
        }
        this.checkEnablements();
    }
}

